"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.register = void 0;
const cancellation_1 = require("../utils/cancellation");
const transform_1 = require("../utils/transform");
function register(context) {
    return async (item, token = cancellation_1.NoneCancellationToken) => {
        const data = item.data;
        if (data) {
            const service = context.services[data.serviceIndex];
            if (!service[1].resolveCompletionItem) {
                return item;
            }
            item = Object.assign(item, data.original);
            if (data.embeddedDocumentUri) {
                const decoded = context.decodeEmbeddedDocumentUri(data.embeddedDocumentUri);
                const sourceScript = decoded && context.language.scripts.get(decoded[0]);
                const virtualCode = decoded && sourceScript?.generated?.embeddedCodes.get(decoded[1]);
                if (virtualCode) {
                    for (const map of context.documents.getMaps(virtualCode)) {
                        item = await service[1].resolveCompletionItem(item, token);
                        item = service[1].transformCompletionItem?.(item) ?? (0, transform_1.transformCompletionItem)(item, embeddedRange => map.getSourceRange(embeddedRange), map.embeddedDocument, context);
                    }
                }
            }
            else {
                item = await service[1].resolveCompletionItem(item, token);
            }
        }
        // TODO: monkey fix import ts file icon
        if (item.detail !== item.detail + '.ts') {
            item.detail = item.detail;
        }
        return item;
    };
}
exports.register = register;
//# sourceMappingURL=resolveCompletionItem.js.map