/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.business.internal.migration.description;

import com.google.common.collect.Iterables;
import java.util.List;
import org.eclipse.sirius.business.api.migration.AbstractVSMMigrationParticipant;
import org.eclipse.sirius.diagram.description.ConditionalContainerStyleDescription;
import org.eclipse.sirius.diagram.description.ContainerMapping;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.diagram.description.DiagramExtensionDescription;
import org.eclipse.sirius.diagram.description.Layer;
import org.eclipse.sirius.diagram.description.style.ContainerStyleDescription;
import org.eclipse.sirius.diagram.model.business.internal.helper.LayerModelHelper;
import org.eclipse.sirius.viewpoint.description.Group;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.osgi.framework.Version;

public class BorderSizeComputationExpressionMigrationParticipant
extends AbstractVSMMigrationParticipant {
    public static final Version MIGRATION_VERSION = new Version("11.0.0.201511131800");
    public static final Version INITIAL_MIGRATION_VERSION = new Version("10.1.0.201507101000");
    public static final Version ALREADY_MIGRATED_VERSION = new Version("10.1.3.201511131800");

    public Version getMigrationVersion() {
        return MIGRATION_VERSION;
    }

    protected void postLoad(Group group, Version loadedVersion) {
        if (loadedVersion.compareTo(MIGRATION_VERSION) < 0) {
            if (loadedVersion.compareTo(INITIAL_MIGRATION_VERSION) < 0) {
                this.migrateBorderSizeComputationExpressions(group);
            } else {
                loadedVersion.compareTo(ALREADY_MIGRATED_VERSION);
            }
        }
    }

    private void migrateBorderSizeComputationExpressions(Group group) {
        for (Viewpoint viewpoint : group.getOwnedViewpoints()) {
            for (DiagramDescription diagramDescription : Iterables.filter((Iterable)viewpoint.getOwnedRepresentations(), DiagramDescription.class)) {
                for (Layer layer : LayerModelHelper.getAllLayers((DiagramDescription)diagramDescription)) {
                    this.migrateBorderSizeComputationExpressions((List<ContainerMapping>)layer.getContainerMappings());
                }
                this.migrateBorderSizeComputationExpressions((List<ContainerMapping>)diagramDescription.getContainerMappings());
            }
            for (DiagramExtensionDescription diagramExtensionDescription : Iterables.filter((Iterable)viewpoint.getOwnedRepresentationExtensions(), DiagramExtensionDescription.class)) {
                for (Layer layer : diagramExtensionDescription.getLayers()) {
                    this.migrateBorderSizeComputationExpressions((List<ContainerMapping>)layer.getContainerMappings());
                }
            }
        }
    }

    private void migrateBorderSizeComputationExpressions(List<ContainerMapping> containerMappings) {
        for (ContainerMapping containerMapping : containerMappings) {
            this.migrateBorderSizeComputationExpression(containerMapping.getStyle());
            for (ConditionalContainerStyleDescription conditionalStyleDescription : containerMapping.getConditionnalStyles()) {
                this.migrateBorderSizeComputationExpression(conditionalStyleDescription.getStyle());
            }
            this.migrateBorderSizeComputationExpressions((List<ContainerMapping>)containerMapping.getSubContainerMappings());
        }
    }

    private void migrateBorderSizeComputationExpression(ContainerStyleDescription styleDescription) {
        if (styleDescription != null && "0".equals(styleDescription.getBorderSizeComputationExpression())) {
            styleDescription.setBorderSizeComputationExpression("1");
        }
    }
}

