/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.ui;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.mylyn.commons.ui.CommonImages;
import org.eclipse.mylyn.commons.ui.compatibility.CommonFonts;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.DayDateRange;
import org.eclipse.mylyn.internal.tasks.core.Person;
import org.eclipse.mylyn.internal.tasks.core.RepositoryQuery;
import org.eclipse.mylyn.internal.tasks.core.ScheduledTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.TaskCategory;
import org.eclipse.mylyn.internal.tasks.core.TaskGroup;
import org.eclipse.mylyn.internal.tasks.core.UncategorizedTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.UnmatchedTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.UnsubmittedTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.WeekDateRange;
import org.eclipse.mylyn.internal.tasks.ui.Messages;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.core.IRepositoryElement;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskContainer;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.AbstractRepositoryConnectorUi;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.TasksUiImages;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.themes.IThemeManager;

public class TaskElementLabelProvider
extends LabelProvider
implements IColorProvider,
IFontProvider {
    private final IThemeManager themeManager = PlatformUI.getWorkbench().getThemeManager();
    private boolean wideImages = false;

    public TaskElementLabelProvider() {
        this(false);
    }

    public TaskElementLabelProvider(boolean wideImages) {
        this.wideImages = wideImages;
    }

    public Image getImage(Object element) {
        CompositeImageDescriptor compositeDescriptor = this.getImageDescriptor(element);
        if (element instanceof ITask) {
            if (compositeDescriptor.overlayKind == null) {
                compositeDescriptor.overlayKind = CommonImages.OVERLAY_CLEAR;
            }
            return CommonImages.getCompositeTaskImage((ImageDescriptor)compositeDescriptor.icon, (ImageDescriptor)compositeDescriptor.overlayKind, (boolean)this.wideImages);
        }
        if (element instanceof ITaskContainer) {
            return CommonImages.getCompositeTaskImage((ImageDescriptor)compositeDescriptor.icon, (ImageDescriptor)CommonImages.OVERLAY_CLEAR, (boolean)this.wideImages);
        }
        return CommonImages.getCompositeTaskImage((ImageDescriptor)compositeDescriptor.icon, null, (boolean)this.wideImages);
    }

    /*
     * WARNING - void declaration
     */
    private CompositeImageDescriptor getImageDescriptor(Object object) {
        CompositeImageDescriptor compositeDescriptor = new CompositeImageDescriptor();
        if (object instanceof UncategorizedTaskContainer) {
            compositeDescriptor.icon = TasksUiImages.CATEGORY_UNCATEGORIZED;
            return compositeDescriptor;
        }
        if (object instanceof UnsubmittedTaskContainer) {
            compositeDescriptor.icon = TasksUiImages.CATEGORY_UNCATEGORIZED;
            return compositeDescriptor;
        }
        if (object instanceof TaskCategory) {
            compositeDescriptor.icon = TasksUiImages.CATEGORY;
        } else if (object instanceof TaskGroup) {
            compositeDescriptor.icon = CommonImages.GROUPING;
        }
        if (object instanceof ITaskContainer) {
            IRepositoryElement element = (IRepositoryElement)object;
            AbstractRepositoryConnectorUi connectorUi = null;
            IRepositoryElement iRepositoryElement = element;
            if (iRepositoryElement instanceof ITask) {
                ITask iTask = (ITask)iRepositoryElement;
                ITask cfr_ignored_0 = (ITask)iRepositoryElement;
                connectorUi = TasksUiPlugin.getConnectorUi(((ITask)element).getConnectorKind());
                if (connectorUi != null) {
                    void repositoryTask;
                    compositeDescriptor.overlayKind = connectorUi.getTaskKindOverlay((ITask)repositoryTask);
                }
            } else if (element instanceof IRepositoryQuery) {
                connectorUi = TasksUiPlugin.getConnectorUi(((IRepositoryQuery)element).getConnectorKind());
            }
            if (connectorUi != null) {
                compositeDescriptor.icon = connectorUi.getImageDescriptor(element);
                return compositeDescriptor;
            }
            if (element instanceof UnmatchedTaskContainer) {
                compositeDescriptor.icon = TasksUiImages.QUERY_UNMATCHED;
            } else if (element instanceof RepositoryQuery) {
                compositeDescriptor.icon = ((RepositoryQuery)element).getAutoUpdate() ? TasksUiImages.QUERY : TasksUiImages.QUERY_OFFLINE;
            } else if (element instanceof ITask) {
                compositeDescriptor.icon = TasksUiImages.TASK;
            } else {
                IRepositoryElement iRepositoryElement2 = element;
                if (iRepositoryElement2 instanceof ScheduledTaskContainer) {
                    void scheduledTaskContainer;
                    ScheduledTaskContainer scheduledTaskContainer2 = (ScheduledTaskContainer)iRepositoryElement2;
                    ScheduledTaskContainer cfr_ignored_1 = (ScheduledTaskContainer)iRepositoryElement2;
                    compositeDescriptor.icon = scheduledTaskContainer.getDateRange() instanceof DayDateRange ? (scheduledTaskContainer.isPresent() ? CommonImages.SCHEDULE_DAY : CommonImages.SCHEDULE) : (scheduledTaskContainer.getDateRange() instanceof WeekDateRange ? CommonImages.SCHEDULE_WEEK : TasksUiImages.QUERY_UNMATCHED);
                } else if (element instanceof Person) {
                    compositeDescriptor.icon = CommonImages.PERSON;
                    Person person = (Person)element;
                    TaskRepository repository = TasksUi.getRepositoryManager().getRepository(person.getConnectorKind(), person.getRepositoryUrl());
                    if (repository != null && !repository.isAnonymous() && repository.getUserName() != null && repository.getUserName().equalsIgnoreCase(element.getHandleIdentifier())) {
                        compositeDescriptor.icon = CommonImages.PERSON_ME;
                    }
                }
            }
            return compositeDescriptor;
        }
        return compositeDescriptor;
    }

    /*
     * WARNING - void declaration
     */
    public String getText(Object object) {
        Object object2 = object;
        if (object2 instanceof ITask) {
            String taskKey;
            void task;
            ITask iTask = (ITask)object2;
            ITask cfr_ignored_0 = (ITask)object2;
            String summary = task.getSummary();
            if (summary == null) {
                summary = Messages.TaskElementLabelProvider__no_summary_available_;
            }
            if ((taskKey = task.getTaskKey()) != null) {
                return taskKey + ": " + summary;
            }
            return summary;
        }
        Object object3 = object;
        if (object3 instanceof IRepositoryElement) {
            void element;
            IRepositoryElement summary = (IRepositoryElement)object3;
            IRepositoryElement cfr_ignored_1 = (IRepositoryElement)object3;
            return element.getSummary();
        }
        return super.getText(object);
    }

    /*
     * WARNING - void declaration
     */
    public Color getForeground(Object object) {
        Object object2 = object;
        if (object2 instanceof AbstractTask) {
            void task;
            AbstractTask abstractTask = (AbstractTask)object2;
            AbstractTask cfr_ignored_0 = (AbstractTask)object2;
            if (task != null) {
                if (TasksUiPlugin.getTaskActivityManager().isCompletedToday((ITask)task)) {
                    return this.themeManager.getCurrentTheme().getColorRegistry().get("org.eclipse.mylyn.tasks.ui.colors.foreground.today.completed");
                }
                if (task.isCompleted()) {
                    return this.themeManager.getCurrentTheme().getColorRegistry().get("org.eclipse.mylyn.tasks.ui.colors.foreground.completed");
                }
                if (TasksUi.getTaskActivityManager().isActive((ITask)task)) {
                    return this.themeManager.getCurrentTheme().getColorRegistry().get("org.eclipse.mylyn.tasks.ui.colors.foreground.task.active");
                }
                if (TasksUiPlugin.getTaskActivityManager().isOverdue((ITask)task)) {
                    return this.themeManager.getCurrentTheme().getColorRegistry().get("org.eclipse.mylyn.tasks.ui.colors.foreground.past.due");
                }
                if (TasksUiPlugin.getTaskActivityManager().isDueToday((ITask)task)) {
                    return this.themeManager.getCurrentTheme().getColorRegistry().get("org.eclipse.mylyn.tasks.ui.colors.foreground.today.scheduled");
                }
                if (task.getScheduledForDate() != null && TasksUiPlugin.getTaskActivityManager().isPastReminder((AbstractTask)task)) {
                    return this.themeManager.getCurrentTheme().getColorRegistry().get("org.eclipse.mylyn.tasks.ui.colors.foreground.past.scheduled");
                }
                if (TasksUiPlugin.getTaskActivityManager().isOverdueForOther((ITask)task)) {
                    return this.themeManager.getCurrentTheme().getColorRegistry().get("org.eclipse.mylyn.tasks.ui.colors.foreground.overdue.for.others");
                }
                if (TasksUiPlugin.getTaskActivityManager().isScheduledForToday((AbstractTask)task)) {
                    return this.themeManager.getCurrentTheme().getColorRegistry().get("org.eclipse.mylyn.tasks.ui.colors.foreground.today.scheduled");
                }
                if (TasksUiPlugin.getTaskActivityManager().isScheduledForThisWeek((AbstractTask)task)) {
                    return this.themeManager.getCurrentTheme().getColorRegistry().get("org.eclipse.mylyn.tasks.ui.colors.foreground.thisweek.scheduled");
                }
            }
        } else if (object instanceof ITaskContainer) {
            if (object instanceof ScheduledTaskContainer) {
                return null;
            }
            for (ITask child : ((ITaskContainer)object).getChildren()) {
                if (child.isActive() || child instanceof ITaskContainer && this.showHasActiveChild((ITaskContainer)child)) {
                    return this.themeManager.getCurrentTheme().getColorRegistry().get("org.eclipse.mylyn.tasks.ui.colors.foreground.task.active");
                }
                if (!TasksUiPlugin.getTaskActivityManager().isOverdue(child)) continue;
                return this.themeManager.getCurrentTheme().getColorRegistry().get("org.eclipse.mylyn.tasks.ui.colors.foreground.past.due");
            }
        }
        return null;
    }

    public Color getBackground(Object element) {
        return null;
    }

    public Font getFont(Object element) {
        if (element instanceof AbstractTask && ((AbstractTask)element).isSynchronizing()) {
            if (((AbstractTask)element).isActive()) {
                return CommonFonts.BOLD_ITALIC;
            }
            return CommonFonts.ITALIC;
        }
        if (element instanceof IRepositoryQuery && ((RepositoryQuery)element).isSynchronizing()) {
            return CommonFonts.ITALIC;
        }
        if (element instanceof ITaskContainer) {
            for (ITask child : ((ITaskContainer)element).getChildren()) {
                if (!child.isActive() && (!(child instanceof ITaskContainer) || !this.showHasActiveChild((ITaskContainer)child))) continue;
                return CommonFonts.BOLD;
            }
        }
        if (element instanceof AbstractTask) {
            if (((AbstractTask)element).isActive()) {
                return CommonFonts.BOLD;
            }
            if (((AbstractTask)element).isCompleted()) {
                if (CommonFonts.HAS_STRIKETHROUGH && TasksUiPlugin.getDefault().getPluginPreferences().getBoolean("org.eclipse.mylyn.tasks.ui.strikethrough.for.completed")) {
                    return CommonFonts.STRIKETHROUGH;
                }
                return null;
            }
            for (ITask child : ((ITaskContainer)element).getChildren()) {
                if (!child.isActive() && (!(child instanceof ITaskContainer) || !this.showHasActiveChild((ITaskContainer)child))) continue;
                return CommonFonts.BOLD;
            }
        }
        return null;
    }

    private boolean showHasActiveChild(ITaskContainer container) {
        if (!TasksUiPlugin.getDefault().groupSubtasks(container)) {
            return false;
        }
        return this.showHasActiveChildHelper(container, new HashSet<IRepositoryElement>());
    }

    private boolean showHasActiveChildHelper(ITaskContainer container, Set<IRepositoryElement> visitedContainers) {
        for (IRepositoryElement child : container.getChildren()) {
            if (visitedContainers.contains(child)) continue;
            visitedContainers.add(child);
            if (child instanceof ITask && ((AbstractTask)child).isActive()) {
                return true;
            }
            if (!(child instanceof ITaskContainer) || !this.showHasActiveChildHelper((ITaskContainer)child, visitedContainers)) continue;
            return true;
        }
        return false;
    }

    private class CompositeImageDescriptor {
        ImageDescriptor icon;
        ImageDescriptor overlayKind;

        private CompositeImageDescriptor() {
        }
    }
}

