/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.internal.extension.impl;

import org.eclipse.emf.compare.EMFCompare;
import org.eclipse.emf.compare.conflict.IConflictDetector;
import org.eclipse.emf.compare.diff.IDiffEngine;
import org.eclipse.emf.compare.equi.IEquiEngine;
import org.eclipse.emf.compare.match.IMatchEngine;
import org.eclipse.emf.compare.postprocessor.IPostProcessor;
import org.eclipse.emf.compare.rcp.EMFCompareRCPPlugin;
import org.eclipse.emf.compare.rcp.internal.extension.IEMFCompareBuilderConfigurator;
import org.eclipse.emf.compare.rcp.internal.extension.impl.ItemUtil;
import org.eclipse.emf.compare.req.IReqEngine;

public class EMFCompareBuilderConfigurator
implements IEMFCompareBuilderConfigurator {
    private final IMatchEngine.Factory.Registry matchEngineFactoryRegistry;
    private final IPostProcessor.Descriptor.Registry<String> postProcessorRegistry;

    protected EMFCompareBuilderConfigurator(IMatchEngine.Factory.Registry matchEngineFactoryRegistry, IPostProcessor.Descriptor.Registry<String> postProcessorRegistry) {
        this.matchEngineFactoryRegistry = matchEngineFactoryRegistry;
        this.postProcessorRegistry = postProcessorRegistry;
    }

    public static EMFCompareBuilderConfigurator createDefault() {
        return new EMFCompareBuilderConfigurator(EMFCompareRCPPlugin.getDefault().getMatchEngineFactoryRegistry(), EMFCompareRCPPlugin.getDefault().getPostProcessorRegistry());
    }

    private IDiffEngine getDiffEngine() {
        return ItemUtil.getItem(EMFCompareRCPPlugin.getDefault().getDiffEngineDescriptorRegistry(), "org.eclipse.emf.compare.preference.diff.engine");
    }

    private IEquiEngine getEquiEngine() {
        return ItemUtil.getItem(EMFCompareRCPPlugin.getDefault().getEquiEngineDescriptorRegistry(), "org.eclipse.emf.compare.preference.equi.engine");
    }

    private IReqEngine getReqEngine() {
        return ItemUtil.getItem(EMFCompareRCPPlugin.getDefault().getReqEngineDescriptorRegistry(), "org.eclipse.emf.compare.preference.req.engine");
    }

    private IConflictDetector getConflictDetector() {
        return ItemUtil.getItem(EMFCompareRCPPlugin.getDefault().getConflictDetectorDescriptorRegistry(), "org.eclipse.emf.compare.preference.conflict.detector");
    }

    @Override
    public void configure(EMFCompare.Builder builder) {
        IEquiEngine equiEngine;
        IReqEngine reqEngine;
        IConflictDetector conflictDetector;
        IDiffEngine diffEngine;
        if (this.matchEngineFactoryRegistry != null) {
            builder.setMatchEngineFactoryRegistry(this.matchEngineFactoryRegistry);
        }
        if (this.postProcessorRegistry != null) {
            builder.setPostProcessorRegistry(this.postProcessorRegistry);
        }
        if ((diffEngine = this.getDiffEngine()) != null) {
            builder.setDiffEngine(diffEngine);
        }
        if ((conflictDetector = this.getConflictDetector()) != null) {
            builder.setConflictDetector(conflictDetector);
        }
        if ((reqEngine = this.getReqEngine()) != null) {
            builder.setRequirementEngine(reqEngine);
        }
        if ((equiEngine = this.getEquiEngine()) != null) {
            builder.setEquivalenceEngine(equiEngine);
        }
    }
}

