/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tools.internal;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.tools.internal.MacGenerator;
import org.eclipse.swt.tools.internal.ProgressMonitor;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MacGeneratorUI {
    MacGenerator gen;
    boolean actions = true;
    public static boolean SHOW_SWT_PREFIX = true;
    Tree nodesTree;
    Table attribTable;
    TreeItem lastParent;
    ArrayList<Node> flatNodes;

    public MacGeneratorUI(MacGenerator gen) {
        this.gen = gen;
    }

    TreeItem addChild(Node node, TreeItem superItem) {
        TreeItem item;
        if (node.getNodeType() == 3) {
            return null;
        }
        String name = node.getNodeName();
        TreeItem parentItem = null;
        if (this.lastParent != null && !this.lastParent.isDisposed() && this.lastParent.getParentItem() == superItem && name.equals(this.lastParent.getData())) {
            parentItem = this.lastParent;
        } else {
            TreeItem[] treeItemArray = superItem.getItems();
            int n = treeItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                item = treeItemArray[n2];
                if (name.equals(item.getData())) {
                    parentItem = item;
                    break;
                }
                ++n2;
            }
            if (parentItem == null) {
                parentItem = new TreeItem(superItem, 0);
                parentItem.setData((Object)name);
                parentItem.setText(this.getPrettyText(name));
            }
            this.lastParent = parentItem;
        }
        item = new TreeItem(parentItem, 0);
        Node idAttrib = this.gen.getIDAttribute(node);
        item.setText(idAttrib != null ? idAttrib.getNodeValue() : name);
        item.setData((Object)node);
        this.checkItem(node, item);
        NodeList childNodes = node.getChildNodes();
        if (childNodes.getLength() > 0) {
            new TreeItem(item, 0);
        }
        return item;
    }

    void checkPath(TreeItem item, boolean checked, boolean grayed) {
        if (item == null) {
            return;
        }
        if (grayed) {
            checked = true;
        } else {
            int index = 0;
            TreeItem[] items = item.getItems();
            while (index < items.length) {
                TreeItem child = items[index];
                if (child.getGrayed() || checked != child.getChecked()) {
                    grayed = true;
                    checked = true;
                    break;
                }
                ++index;
            }
        }
        item.setChecked(checked);
        item.setGrayed(grayed);
        this.updateGenAttribute(item);
        this.checkPath(item.getParentItem(), checked, grayed);
    }

    void checkItem(Node node, TreeItem item) {
        NamedNodeMap attributes = node.getAttributes();
        Node gen = attributes.getNamedItem("swt_gen");
        if (gen != null) {
            String value = gen.getNodeValue();
            boolean grayed = value.equals("mixed");
            boolean checked = grayed || value.equals("true");
            item.setChecked(checked);
            item.setGrayed(grayed);
        }
    }

    boolean getEditable(TableItem item, int column) {
        if (!(item.getData() instanceof Node)) {
            return false;
        }
        if (column == 0) {
            return false;
        }
        String attribName = item.getText();
        return attribName.startsWith("swt_") || item.getData("swt_") != null;
    }

    String getPrettyText(String text) {
        if (text.equals("class")) {
            return "Classes";
        }
        if (text.equals("depends_on")) {
            return "Depends_on";
        }
        return text.substring(0, 1).toUpperCase() + text.substring(1) + "s";
    }

    void checkChildren(TreeItem item) {
        TreeItem dummy;
        if (item.getItemCount() == 1 && (dummy = item.getItem(0)).getData() == null) {
            dummy.dispose();
            Node node = (Node)item.getData();
            NodeList childNodes = node.getChildNodes();
            int i = 0;
            int length = childNodes.getLength();
            while (i < length) {
                this.addChild(childNodes.item(i), item);
                ++i;
            }
            TreeItem[] treeItemArray = item.getItems();
            int n = treeItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem child = treeItemArray[n2];
                TreeItem[] children = child.getItems();
                int checkedCount = 0;
                TreeItem[] treeItemArray2 = children;
                int n3 = children.length;
                int n4 = 0;
                while (n4 < n3) {
                    TreeItem element = treeItemArray2[n4];
                    if (element.getChecked()) {
                        ++checkedCount;
                    }
                    if (element.getGrayed()) break;
                    ++n4;
                }
                child.setChecked(checkedCount != 0);
                child.setGrayed(checkedCount != children.length);
                ++n2;
            }
        }
    }

    void checkItems(TreeItem item, boolean checked) {
        item.setGrayed(false);
        item.setChecked(checked);
        this.updateGenAttribute(item);
        TreeItem[] items = item.getItems();
        if (items.length == 1 && items[0].getData() == null) {
            Node node = (Node)item.getData();
            NodeList childNodes = node.getChildNodes();
            int i = 0;
            int length = childNodes.getLength();
            while (i < length) {
                this.checkNodes(childNodes.item(i), checked);
                ++i;
            }
        } else {
            TreeItem[] treeItemArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem item2 = treeItemArray[n2];
                this.checkItems(item2, checked);
                ++n2;
            }
        }
    }

    void checkNodes(Node node, boolean checked) {
        if (node instanceof Element) {
            if (checked) {
                ((Element)node).setAttribute("swt_gen", "true");
            } else {
                ((Element)node).removeAttribute("swt_gen");
            }
        }
        NodeList childNodes = node.getChildNodes();
        int i = 0;
        int length = childNodes.getLength();
        while (i < length) {
            this.checkNodes(childNodes.item(i), checked);
            ++i;
        }
    }

    void cleanup() {
    }

    Composite createSignaturesPanel(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginLeft = 5;
        layout.marginWidth = 0;
        comp.setLayout((Layout)layout);
        Label label = new Label(comp, 0);
        label.setText("Signatures:");
        Text search = new Text(comp, 2180);
        GridData data = new GridData(768);
        search.setLayoutData((Object)data);
        search.setText(".*");
        search.addListener(14, arg0 -> this.searchFor(search.getText()));
        search.addListener(1, event -> {
            if (event.keyCode == 0x100000F) {
                this.searchFor(search.getText());
            }
        });
        this.nodesTree = new Tree(comp, 67620);
        data = new GridData(1808);
        data.horizontalSpan = 2;
        this.nodesTree.setLayoutData((Object)data);
        this.nodesTree.addListener(13, event -> {
            TreeItem item = (TreeItem)event.item;
            if (item == null) {
                return;
            }
            if (event.detail != 32) {
                this.selectChild(item);
                return;
            }
            boolean checked = item.getChecked();
            item.getParent().setRedraw(false);
            this.checkItems(item, checked);
            this.checkPath(item.getParentItem(), checked, false);
            item.getParent().setRedraw(true);
        });
        this.nodesTree.addListener(17, event -> this.checkChildren((TreeItem)event.item));
        return comp;
    }

    Composite createPropertiesPanel(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        if (!this.actions) {
            layout.marginRight = 5;
        }
        comp.setLayout((Layout)layout);
        Label label = new Label(comp, 0);
        label.setText("Properties:");
        this.attribTable = new Table(comp, 67584);
        GridData data = new GridData(1808);
        this.attribTable.setLayoutData((Object)data);
        this.attribTable.setLinesVisible(true);
        this.attribTable.setHeaderVisible(true);
        TableColumn nameColumn = new TableColumn(this.attribTable, 0);
        nameColumn.setText("Name");
        nameColumn.pack();
        TableColumn valueColumn = new TableColumn(this.attribTable, 0);
        valueColumn.setText("Value");
        valueColumn.pack();
        final Text editorTx = new Text((Composite)this.attribTable, 4);
        final TableEditor editor = new TableEditor(this.attribTable);
        editor.grabHorizontal = true;
        editor.setEditor((Control)editorTx);
        Listener textListener = e -> {
            if (e.type == 1 && e.keyCode != 0x100000F) {
                return;
            }
            if (e.type == 31) {
                switch (e.detail) {
                    case 2: {
                        editor.setItem(null);
                        break;
                    }
                    default: {
                        return;
                    }
                }
            }
            editorTx.setVisible(false);
            TableItem item = editor.getItem();
            if (item == null) {
                return;
            }
            int column = editor.getColumn();
            String value = editorTx.getText();
            item.setText(column, value);
            Element node = (Element)item.getData();
            Object name = item.getText();
            if (!((String)name).startsWith("swt_")) {
                name = "swt_" + (String)name;
            }
            if (value.length() != 0) {
                node.setAttribute((String)name, value);
            } else {
                node.removeAttribute((String)name);
            }
        };
        editorTx.addListener(14, textListener);
        editorTx.addListener(1, textListener);
        editorTx.addListener(31, textListener);
        this.attribTable.addListener(3, e -> e.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (MacGeneratorUI.this.attribTable.isDisposed()) {
                    return;
                }
                if (e.button != 1) {
                    return;
                }
                Point pt = new Point(e.x, e.y);
                TableItem item = MacGeneratorUI.this.attribTable.getItem(pt);
                if (item == null) {
                    return;
                }
                int column = -1;
                int i = 0;
                while (i < MacGeneratorUI.this.attribTable.getColumnCount()) {
                    if (item.getBounds(i).contains(pt)) {
                        column = i;
                        break;
                    }
                    ++i;
                }
                if (column == -1) {
                    return;
                }
                if (!MacGeneratorUI.this.getEditable(item, column)) {
                    return;
                }
                editor.setColumn(column);
                editor.setItem(item);
                editorTx.setText(item.getText(column));
                editorTx.selectAll();
                editorTx.setVisible(true);
                editorTx.setFocus();
            }
        }));
        return comp;
    }

    Composite createActionsPanel(Composite parent) {
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 10;
        panel.setLayout((Layout)layout);
        Button generate = new Button(panel, 8);
        generate.setText("Generate");
        generate.addListener(13, event -> this.generate(null));
        return panel;
    }

    public void generate(ProgressMonitor progress) {
        this.gen.generate(progress);
    }

    public boolean getActionsVisible() {
        return this.actions;
    }

    public void open(Composite parent) {
        FormLayout layout = new FormLayout();
        parent.setLayout((Layout)layout);
        Composite signaturePanel = this.createSignaturesPanel(parent);
        Sash sash = new Sash(parent, 66048);
        Composite propertiesPanel = this.createPropertiesPanel(parent);
        Composite actionsPanel = null;
        if (this.actions) {
            actionsPanel = this.createActionsPanel(parent);
        }
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)sash, 0);
        data.bottom = new FormAttachment(100, 0);
        signaturePanel.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(null, Math.max(200, parent.getSize().x / 2));
        data.top = new FormAttachment(0, 0);
        data.bottom = new FormAttachment(100, 0);
        sash.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment((Control)sash, sash.computeSize((int)-1, (int)-1).x);
        data.top = new FormAttachment(0, 0);
        data.right = actionsPanel != null ? new FormAttachment((Control)actionsPanel, 0) : new FormAttachment(100, 0);
        data.bottom = new FormAttachment(100, 0);
        propertiesPanel.setLayoutData((Object)data);
        if (actionsPanel != null) {
            data = new FormData();
            data.top = new FormAttachment(0, 0);
            data.right = new FormAttachment(100, 0);
            data.bottom = new FormAttachment(100, 0);
            actionsPanel.setLayoutData((Object)data);
        }
        sash.addListener(13, event -> {
            Composite parent1 = sash.getParent();
            Rectangle rect = parent1.getClientArea();
            event.x = Math.min(Math.max(event.x, 60), rect.width - 60);
            if (event.detail != 1) {
                FormData data1 = (FormData)sash.getLayoutData();
                data1.left.offset = event.x;
                parent1.layout(true);
            }
        });
        this.updateNodes();
    }

    public void dispose() {
        this.cleanup();
    }

    void searchFor(String name) {
        Node attribName;
        TreeItem[] selection = this.nodesTree.getSelection();
        Node node = null;
        if (selection.length != 0) {
            if (selection[0].getData() instanceof Node) {
                node = (Node)selection[0].getData();
            } else if (selection[0].getItemCount() > 0 && selection[0].getItem(0).getData() instanceof Node) {
                node = (Node)selection[0].getItem(0).getData();
            }
        }
        Document[] documents = this.gen.getDocuments();
        if (node == null && documents.length > 0) {
            int index = 0;
            while (index < documents.length && (node = documents[index]) == null) {
                ++index;
            }
        }
        if (this.flatNodes == null) {
            this.flatNodes = new ArrayList();
            Document[] documentArray = documents;
            int n = documents.length;
            int n2 = 0;
            while (n2 < n) {
                Document document = documentArray[n2];
                if (document != null) {
                    this.addNodes(document, this.flatNodes);
                }
                ++n2;
            }
        }
        int index = 0;
        while (this.flatNodes.get(index++) != node) {
        }
        int start = index;
        while (index < this.flatNodes.size()) {
            Node child = this.flatNodes.get(index);
            attribName = this.gen.getIDAttribute(child);
            if (attribName != null && attribName.getNodeValue().matches(name)) {
                this.selectNode(child);
                return;
            }
            ++index;
        }
        index = 0;
        while (index < start) {
            Node child = this.flatNodes.get(index);
            attribName = this.gen.getIDAttribute(child);
            if (attribName != null && attribName.getNodeValue().matches(name)) {
                this.selectNode(child);
                return;
            }
            ++index;
        }
        this.nodesTree.getDisplay().beep();
    }

    void selectNode(Node node) {
        ArrayList<Node> path = new ArrayList<Node>();
        do {
            path.add(node);
        } while ((node = node.getParentNode()) != null);
        TreeItem[] items = this.nodesTree.getItems();
        Collections.reverse(path);
        path.remove(0);
        TreeItem item;
        while ((item = this.findItem(items, (Node)path.remove(0))) != null) {
            if (path.isEmpty()) {
                this.nodesTree.setSelection(item);
                this.selectChild(item);
                return;
            }
            items = item.getItems();
        }
        return;
    }

    TreeItem findItem(TreeItem[] items, Node node) {
        TreeItem item;
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            item = treeItemArray[n2];
            this.checkChildren(item);
            if (item.getData() == node) {
                return item;
            }
            ++n2;
        }
        treeItemArray = items;
        n = items.length;
        n2 = 0;
        while (n2 < n) {
            item = treeItemArray[n2];
            TreeItem child = this.findItem(item.getItems(), node);
            if (child != null) {
                return child;
            }
            ++n2;
        }
        return null;
    }

    void addNodes(Node node, ArrayList<Node> list) {
        if (node.getNodeType() == 3) {
            return;
        }
        list.add(node);
        NodeList children = node.getChildNodes();
        int i = 0;
        int length = children.getLength();
        while (i < length) {
            Node child = children.item(i);
            this.addNodes(child, list);
            ++i;
        }
    }

    void selectChild(TreeItem item) {
        TableItem attribItem;
        this.attribTable.removeAll();
        if (!(item.getData() instanceof Node)) {
            return;
        }
        Node node = (Node)item.getData();
        NamedNodeMap attributes = node.getAttributes();
        String[] stringArray = this.gen.getExtraAttributeNames(node);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String extraAttrib = stringArray[n2];
            attribItem = new TableItem(this.attribTable, 0);
            String attribName = extraAttrib;
            if (!SHOW_SWT_PREFIX && attribName.startsWith("swt_")) {
                attribName = attribName.substring("swt_".length(), attribName.length());
                attribItem.setData("swt_", (Object)"swt_");
            }
            attribItem.setText(attribName);
            attribItem.setData((Object)node);
            attribItem.setForeground(item.getDisplay().getSystemColor(9));
            Node attrib = attributes.getNamedItem(extraAttrib);
            if (attrib != null) {
                attribItem.setText(1, attrib.getNodeValue());
            }
            ++n2;
        }
        this.checkItem(node, item);
        int i = 0;
        int length = attributes.getLength();
        while (i < length) {
            Node attrib = attributes.item(i);
            String attribName = attrib.getNodeName();
            if (!attribName.startsWith("swt_")) {
                attribItem = new TableItem(this.attribTable, 0);
                attribItem.setText(attribName);
                attribItem.setText(1, attrib.getNodeValue());
            }
            ++i;
        }
        this.attribTable.getColumn(0).pack();
        this.attribTable.getColumn(1).setWidth(500);
    }

    void updateGenAttribute(TreeItem item) {
        if (item.getData() instanceof Element) {
            Element node = (Element)item.getData();
            if (item.getChecked()) {
                if (item.getGrayed()) {
                    node.setAttribute("swt_gen", "mixed");
                } else {
                    node.setAttribute("swt_gen", "true");
                }
            } else {
                node.removeAttribute("swt_gen");
            }
        }
    }

    void updateNodes() {
        String[] xmls = this.gen.getXmls();
        if (xmls == null) {
            return;
        }
        Document[] documents = this.gen.getDocuments();
        int x = 0;
        while (x < xmls.length) {
            String xmlPath = xmls[x];
            Document document = documents[x];
            if (document == null) {
                System.out.println("Could not find: " + xmlPath);
            } else {
                TreeItem item = new TreeItem(this.nodesTree, 0);
                String fileName = this.gen.getFileName(xmlPath);
                if (fileName.endsWith("Full.bridgesupport")) {
                    fileName = fileName.substring(0, fileName.length() - "Full.bridgesupport".length());
                }
                item.setText(fileName);
                Element node = document.getDocumentElement();
                item.setData((Object)node);
                this.checkItem(node, item);
                new TreeItem(item, 0);
            }
            ++x;
        }
        TreeColumn[] treeColumnArray = this.nodesTree.getColumns();
        int n = treeColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeColumn column = treeColumnArray[n2];
            column.pack();
            ++n2;
        }
    }

    public void refresh() {
        if (this.nodesTree == null) {
            return;
        }
        this.gen.setXmls(null);
        this.flatNodes = null;
        this.nodesTree.getDisplay().asyncExec(() -> {
            if (this.nodesTree == null || this.nodesTree.isDisposed()) {
                return;
            }
            this.nodesTree.removeAll();
            this.attribTable.removeAll();
            this.updateNodes();
        });
    }

    public void setActionsVisible(boolean visible) {
        this.actions = visible;
    }

    public void setFocus() {
        this.nodesTree.setFocus();
    }

    public static void main(String[] args) {
        String mainClass = args.length > 0 ? args[0] : "org.eclipse.swt.internal.cocoa.OS";
        String outputDir = args.length > 1 ? args[1] : "../org.eclipse.swt/Eclipse SWT PI/cocoa/";
        String selectorEnumClass = args.length > 2 ? args[2] : "org.eclipse.swt.internal.cocoa.Selector";
        String[] xmls = new String[]{};
        if (args.length > 3) {
            xmls = new String[args.length - 3];
            System.arraycopy(args, 3, xmls, 0, xmls.length);
        }
        try {
            Display display = new Display();
            Shell shell = new Shell(display);
            MacGenerator gen = new MacGenerator();
            gen.setXmls(xmls);
            gen.setOutputDir(outputDir);
            gen.setMainClass(mainClass);
            gen.setSelectorEnum(selectorEnumClass);
            MacGeneratorUI ui = new MacGeneratorUI(gen);
            ui.open((Composite)shell);
            shell.open();
            while (!shell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
            ui.dispose();
            display.dispose();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

