/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.gcov.view.annotatedsource;

import java.io.IOException;
import java.net.URI;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.ui.CDTUITools;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModelEvent;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.jface.text.source.IAnnotationModelListener;
import org.eclipse.jface.text.source.IAnnotationModelListenerExtension;
import org.eclipse.linuxtools.binutils.link2source.STLink2SourceSupport;
import org.eclipse.linuxtools.internal.gcov.parser.CovManager;
import org.eclipse.linuxtools.internal.gcov.parser.Line;
import org.eclipse.linuxtools.internal.gcov.parser.SourceFile;
import org.eclipse.linuxtools.internal.gcov.view.annotatedsource.GcovAnnotation;
import org.eclipse.linuxtools.internal.gcov.view.annotatedsource.GcovAnnotationModelTracker;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public final class GcovAnnotationModel
implements IAnnotationModel {
    private static final String THOROUGH_COVERAGE = "org.eclipse.linuxtools.gcov.ThoroughCoverageAnnotation";
    private static final String COVERAGE = "org.eclipse.linuxtools.gcov.CoverageAnnotation";
    private static final String NO_COVERAGE = "org.eclipse.linuxtools.gcov.NoCoverageAnnotation";
    private static final Object KEY = new Object();
    private List<Annotation> annotations = new ArrayList<Annotation>();
    private List<IAnnotationModelListener> annotationModelListeners = new ArrayList<IAnnotationModelListener>();
    private final ITextEditor editor;
    private final IDocument document;
    private int openConnections = 0;
    private boolean annotated = false;
    private IDocumentListener documentListener = new IDocumentListener(){

        public void documentChanged(DocumentEvent event) {
            GcovAnnotationModel.this.updateAnnotations(false);
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
        }
    };

    private GcovAnnotationModel(ITextEditor editor, IDocument document) {
        this.editor = editor;
        this.document = document;
        this.updateAnnotations(true);
    }

    /*
     * WARNING - void declaration
     */
    public static void attach(ITextEditor editor) {
        void modelex;
        IDocumentProvider provider = editor.getDocumentProvider();
        if (provider == null) {
            return;
        }
        IAnnotationModel model = provider.getAnnotationModel((Object)editor.getEditorInput());
        IAnnotationModel iAnnotationModel = model;
        if (!(iAnnotationModel instanceof IAnnotationModelExtension)) {
            return;
        }
        IAnnotationModelExtension iAnnotationModelExtension = (IAnnotationModelExtension)iAnnotationModel;
        IAnnotationModelExtension cfr_ignored_0 = (IAnnotationModelExtension)iAnnotationModel;
        IDocument document = provider.getDocument((Object)editor.getEditorInput());
        GcovAnnotationModel coveragemodel = (GcovAnnotationModel)modelex.getAnnotationModel(KEY);
        if (coveragemodel == null) {
            coveragemodel = new GcovAnnotationModel(editor, document);
            modelex.addAnnotationModel(KEY, (IAnnotationModel)coveragemodel);
        } else {
            coveragemodel.updateAnnotations(false);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void clear(ITextEditor editor) {
        void modelex;
        IDocumentProvider provider = editor.getDocumentProvider();
        if (provider == null) {
            return;
        }
        IAnnotationModel model = provider.getAnnotationModel((Object)editor.getEditorInput());
        IAnnotationModel iAnnotationModel = model;
        if (!(iAnnotationModel instanceof IAnnotationModelExtension)) {
            return;
        }
        IAnnotationModelExtension iAnnotationModelExtension = (IAnnotationModelExtension)iAnnotationModel;
        IAnnotationModelExtension cfr_ignored_0 = (IAnnotationModelExtension)iAnnotationModel;
        IAnnotationModel coverageModel = modelex.getAnnotationModel(KEY);
        if (coverageModel instanceof GcovAnnotationModel) {
            ((GcovAnnotationModel)coverageModel).clear();
        }
    }

    private void updateAnnotations(boolean force) {
        SourceFile coverage = this.findSourceCoverageForEditor();
        if (coverage != null) {
            if (!this.annotated || force) {
                this.createAnnotations(coverage);
            }
        } else if (this.annotated) {
            this.clear();
        }
    }

    private SourceFile findSourceCoverageForEditor() {
        if (this.editor.isDirty()) {
            return null;
        }
        IEditorInput input = this.editor.getEditorInput();
        if (input == null) {
            return null;
        }
        ICElement element = CDTUITools.getEditorInputCElement((IEditorInput)input);
        if (element == null) {
            return null;
        }
        return this.findSourceCoverageForElement(element);
    }

    private SourceFile findSourceCoverageForElement(ICElement element) {
        URI elementURI;
        IPath elementLocation;
        int n;
        int n2;
        IProject[] iProjectArray;
        ArrayList<SourceFile> sources = new ArrayList<SourceFile>();
        ICProject cProject = element.getCProject();
        IResource elementResource = element.getResource();
        IPath target = GcovAnnotationModelTracker.getInstance().getBinaryPath(cProject.getProject());
        if (target == null) {
            IProject[] trackedProjects;
            iProjectArray = trackedProjects = GcovAnnotationModelTracker.getInstance().getTrackedProjects();
            n2 = trackedProjects.length;
            n = 0;
            while (n < n2) {
                IProject proj = iProjectArray[n];
                try {
                    FindLinkedResourceVisitor visitor = new FindLinkedResourceVisitor(element);
                    proj.accept((IResourceProxyVisitor)visitor, 2);
                    if (visitor.foundElement()) {
                        target = GcovAnnotationModelTracker.getInstance().getBinaryPath(proj);
                        cProject = CoreModel.getDefault().getCModel().getCProject(proj.getName());
                        elementResource = visitor.getResource();
                        break;
                    }
                }
                catch (CoreException visitor) {
                    // empty catch block
                }
                ++n;
            }
            if (target == null) {
                return null;
            }
        }
        try {
            IBinary[] binaries = cProject.getBinaryContainer().getBinaries();
            iProjectArray = binaries;
            n2 = binaries.length;
            n = 0;
            while (n < n2) {
                IProject b = iProjectArray[n];
                if (b.getResource().getLocation().equals((Object)target)) {
                    CovManager covManager = new CovManager(b.getResource().getLocation().toOSString());
                    covManager.processCovFiles(covManager.getGCDALocations(), null);
                    sources.addAll(covManager.getAllSrcs());
                }
                ++n;
            }
        }
        catch (IOException | InterruptedException | CoreException binaries) {
            // empty catch block
        }
        if (elementResource != null && (elementLocation = elementResource.getLocation()) != null) {
            for (SourceFile sf : sources) {
                Path sfPath = new Path(sf.getName());
                IFile file = STLink2SourceSupport.getFileForPath((IPath)sfPath, (IProject)cProject.getProject());
                if (file != null && elementLocation.equals((Object)file.getLocation())) {
                    return sf;
                }
                if (sfPath.isAbsolute() || !elementLocation.equals((Object)(sfPath = target.removeLastSegments(1).append(sf.getName())).makeAbsolute()) || !sfPath.toFile().exists()) continue;
                return sf;
            }
        }
        if ((elementURI = element.getLocationURI()) != null) {
            IPath binFolder = target.removeLastSegments(1);
            for (SourceFile sf : sources) {
                String sfPath = Paths.get(binFolder.toOSString(), new String[0]).resolve(sf.getName()).normalize().toString();
                if (!sfPath.equals(elementURI.getPath())) continue;
                return sf;
            }
        }
        return null;
    }

    private void createAnnotations(SourceFile sourceFile) {
        AnnotationModelEvent event = new AnnotationModelEvent((IAnnotationModel)this);
        this.clear(event);
        ArrayList<Line> lines = sourceFile.getLines();
        ArrayList<Long> tmp = new ArrayList<Long>();
        for (Line line : lines) {
            if (line.getCount() == 0L) continue;
            tmp.add(line.getCount());
        }
        Object[] counts = tmp.toArray(new Long[0]);
        Arrays.sort(counts);
        float outlierThreshold = 0.0f;
        if (!tmp.isEmpty()) {
            int q1 = (int)Math.floor(0.25 * (double)counts.length);
            int q3 = (int)Math.floor(0.75 * (double)counts.length);
            outlierThreshold = (float)((Long)counts[q3]).longValue() + 1.5f * (float)((Long)counts[q3] - (Long)counts[q1]);
        }
        int i = 0;
        while (i < lines.size()) {
            try {
                Line line = (Line)lines.get((i + 1) % lines.size());
                String type = COVERAGE;
                if (line.getCount() == 0L) {
                    type = NO_COVERAGE;
                } else if ((float)line.getCount() > outlierThreshold) {
                    type = THOROUGH_COVERAGE;
                }
                if (line.exists()) {
                    GcovAnnotation ca = new GcovAnnotation(this.document.getLineOffset(i), this.document.getLineLength(i), line.getCount(), type);
                    this.annotations.add(ca);
                    event.annotationAdded((Annotation)ca);
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            ++i;
        }
        this.fireModelChanged(event);
        this.annotated = true;
    }

    private void clear() {
        AnnotationModelEvent event = new AnnotationModelEvent((IAnnotationModel)this);
        this.clear(event);
        this.fireModelChanged(event);
        this.annotated = false;
    }

    private void clear(AnnotationModelEvent event) {
        for (Annotation ca : this.annotations) {
            event.annotationRemoved(ca, ((GcovAnnotation)ca).getPosition());
        }
        this.annotations.clear();
    }

    public void addAnnotationModelListener(IAnnotationModelListener listener) {
        if (!this.annotationModelListeners.contains(listener)) {
            this.annotationModelListeners.add(listener);
            this.fireModelChanged(new AnnotationModelEvent((IAnnotationModel)this, true));
        }
    }

    public void removeAnnotationModelListener(IAnnotationModelListener listener) {
        this.annotationModelListeners.remove(listener);
    }

    private void fireModelChanged(AnnotationModelEvent event) {
        event.markSealed();
        if (!event.isEmpty()) {
            for (IAnnotationModelListener l : this.annotationModelListeners) {
                if (l instanceof IAnnotationModelListenerExtension) {
                    ((IAnnotationModelListenerExtension)l).modelChanged(event);
                    continue;
                }
                l.modelChanged((IAnnotationModel)this);
            }
        }
    }

    public void connect(IDocument document) {
        if (this.document != document) {
            throw new IllegalArgumentException("Can't connect to different document.");
        }
        for (Annotation ca : this.annotations) {
            try {
                document.addPosition(((GcovAnnotation)ca).getPosition());
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        if (this.openConnections++ == 0) {
            document.addDocumentListener(this.documentListener);
        }
    }

    public void disconnect(IDocument document) {
        if (this.document != document) {
            throw new IllegalArgumentException("Can't disconnect from different document.");
        }
        for (Annotation ca : this.annotations) {
            if (!(ca instanceof GcovAnnotation)) continue;
            document.removePosition(((GcovAnnotation)ca).getPosition());
        }
        if (--this.openConnections == 0) {
            document.removeDocumentListener(this.documentListener);
        }
    }

    public Position getPosition(Annotation annotation) {
        return annotation instanceof GcovAnnotation ? ((GcovAnnotation)annotation).getPosition() : null;
    }

    public Iterator<Annotation> getAnnotationIterator() {
        return this.annotations.iterator();
    }

    public void addAnnotation(Annotation annotation, Position position) {
    }

    public void removeAnnotation(Annotation annotation) {
    }

    private class FindLinkedResourceVisitor
    implements IResourceProxyVisitor {
        private final ICElement element;
        private boolean keepSearching = true;
        private boolean found;
        private IResource resource;
        private String lastLinkPath;

        public FindLinkedResourceVisitor(ICElement element) {
            this.element = element;
        }

        public boolean foundElement() {
            return this.found;
        }

        public IResource getResource() {
            return this.resource;
        }

        public boolean visit(IResourceProxy proxy) {
            if (proxy.isLinked()) {
                this.lastLinkPath = proxy.requestFullPath().toString();
            }
            if (this.lastLinkPath != null && proxy.requestFullPath().toString().startsWith(this.lastLinkPath) && proxy.requestResource().getLocationURI().equals(this.element.getLocationURI())) {
                this.found = true;
                this.resource = proxy.requestResource();
                this.keepSearching = false;
            }
            return this.keepSearching;
        }
    }
}

