/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.design.ui.wizard.pages;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;

public class SelectAirdWizardPage
extends WizardNewFileCreationPage {
    private final String fileExtension;
    private IFile selectedFile;

    public SelectAirdWizardPage(String pageName, IStructuredSelection selection, String fileExtension) {
        super(pageName, selection);
        this.fileExtension = fileExtension;
        if (selection.getFirstElement() instanceof IFile) {
            this.selectedFile = (IFile)selection.getFirstElement();
        }
        this.setAllowExistingResources(true);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.setFileName(String.valueOf(this.getDefaultFileName()) + "." + this.getExtension());
        this.setPageComplete(this.validatePage());
        this.setErrorMessage(null);
        this.setMessage(null);
    }

    public String getDefaultFileName() {
        if (this.selectedFile != null && this.selectedFile.getFullPath().removeFileExtension().lastSegment() != null) {
            String name = this.selectedFile.getFullPath().removeFileExtension().lastSegment();
            return name;
        }
        return this.getNoselectionFileName();
    }

    protected String getExtension() {
        return this.fileExtension;
    }

    protected IPath getFilePath() {
        String fileName;
        IPath path = this.getContainerFullPath();
        if (path == null) {
            path = new Path("");
        }
        if ((fileName = this.getFileName()) != null) {
            path = path.append(fileName);
        }
        return path;
    }

    protected String getNoselectionFileName() {
        return "representations";
    }

    public URI getURI() {
        return URI.createPlatformResourceURI((String)this.getFilePath().toString(), (boolean)true);
    }

    protected boolean validatePage() {
        boolean result = true;
        if (!super.validatePage()) {
            return false;
        }
        IPath resourcePath = this.getContainerFullPath().append(this.getFileName());
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (workspace.getRoot().getFile(resourcePath).exists()) {
            this.setMessage("The representation will be added in the file.", 1);
        } else {
            this.setMessage("A new file will be created to store the representation.", 1);
        }
        String extension = this.getExtension();
        if (extension != null && !this.getFilePath().toString().endsWith("." + extension)) {
            this.setErrorMessage("The file extension is wrong. It should be " + extension);
            result = false;
        }
        return result;
    }
}

