/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.build;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.CommandLauncherManager;
import org.eclipse.cdt.core.ICommandLauncher;
import org.eclipse.cdt.core.IConsoleParser;
import org.eclipse.cdt.core.IConsoleParser2;
import org.eclipse.cdt.core.IMarkerGenerator;
import org.eclipse.cdt.core.ProblemMarkerInfo;
import org.eclipse.cdt.core.build.ICBuildConfiguration;
import org.eclipse.cdt.core.build.ICBuildConfiguration2;
import org.eclipse.cdt.core.build.IToolChain;
import org.eclipse.cdt.core.build.IToolChain2;
import org.eclipse.cdt.core.build.IToolChainManager;
import org.eclipse.cdt.core.build.ScannerInfoCache;
import org.eclipse.cdt.core.envvar.IEnvironmentVariable;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ElementChangedEvent;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.IBinaryContainer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICElementDelta;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IElementChangedListener;
import org.eclipse.cdt.core.model.IIncludeEntry;
import org.eclipse.cdt.core.model.IIncludeFileEntry;
import org.eclipse.cdt.core.model.IMacroEntry;
import org.eclipse.cdt.core.model.IMacroFileEntry;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.parser.ExtendedScannerInfo;
import org.eclipse.cdt.core.parser.IExtendedScannerInfo;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.IScannerInfoChangeListener;
import org.eclipse.cdt.core.resources.IConsole;
import org.eclipse.cdt.internal.core.BuildRunnerHelper;
import org.eclipse.cdt.internal.core.ConsoleOutputSniffer;
import org.eclipse.cdt.internal.core.build.Messages;
import org.eclipse.cdt.internal.core.model.BinaryRunner;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.internal.core.scannerinfo.ExtendedScannerInfoSerializer;
import org.eclipse.cdt.internal.core.scannerinfo.IExtendedScannerInfoDeserializer;
import org.eclipse.cdt.utils.CommandLineUtil;
import org.eclipse.cdt.utils.spawner.EnvironmentReader;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IBuildConfiguration;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public abstract class CBuildConfiguration
extends PlatformObject
implements ICBuildConfiguration,
ICBuildConfiguration2,
IMarkerGenerator,
IConsoleParser2,
IElementChangedListener {
    private static final String LAUNCH_MODE = "cdt.launchMode";
    private static final String NEED_REFRESH = "cdt.needScannerRefresh";
    private static final List<String> DEFAULT_COMMAND = new ArrayList<String>(0);
    private final Map<IResource, IToolChain> tcMap = new HashMap<IResource, IToolChain>();
    private final String name;
    private final IBuildConfiguration config;
    private final IToolChain toolChain;
    private String launchMode;
    private Object scannerInfoLock = new Object();
    private final Map<IResource, List<IScannerInfoChangeListener>> scannerInfoListeners = new HashMap<IResource, List<IScannerInfoChangeListener>>();
    private ScannerInfoCache scannerInfoCache;
    private ICommandLauncher launcher;
    private boolean infoChanged = false;

    protected CBuildConfiguration(IBuildConfiguration config, String name) throws CoreException {
        this.config = config;
        this.name = name;
        Preferences settings = this.getSettings();
        String typeId = settings.get("cdt.toolChain.type", "");
        String id = settings.get("cdt.toolChain.id", "");
        IToolChainManager toolChainManager = CCorePlugin.getService(IToolChainManager.class);
        IToolChain tc = toolChainManager.getToolChain(typeId, id);
        if (tc == null && (tc = toolChainManager.getToolChain(typeId, id)) == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.core", 5, String.format(Messages.CBuildConfiguration_ToolchainMissing, config.getName()), null));
        }
        this.toolChain = tc;
        this.launchMode = settings.get(LAUNCH_MODE, "run");
        CoreModel.getDefault().addElementChangedListener(this);
    }

    protected CBuildConfiguration(IBuildConfiguration config, String name, IToolChain toolChain) {
        this(config, name, toolChain, "run");
    }

    protected CBuildConfiguration(IBuildConfiguration config, String name, IToolChain toolChain, String launchMode) {
        this.config = config;
        this.name = name;
        this.toolChain = toolChain;
        this.launchMode = launchMode;
        Preferences settings = this.getSettings();
        settings.put("cdt.toolChain.type", toolChain.getTypeId());
        settings.put("cdt.toolChain.id", toolChain.getId());
        if (launchMode != null) {
            settings.put(LAUNCH_MODE, launchMode);
        }
        try {
            settings.flush();
        }
        catch (BackingStoreException e) {
            CCorePlugin.log(e);
        }
        CoreModel.getDefault().addElementChangedListener(this);
    }

    protected CBuildConfiguration(IBuildConfiguration config, IToolChain toolChain) {
        this(config, "default", toolChain);
    }

    @Override
    public IBuildConfiguration getBuildConfiguration() {
        return this.config;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getLaunchMode() {
        return this.launchMode;
    }

    protected void setLaunchMode(String launchMode) {
        this.launchMode = launchMode;
        Preferences settings = this.getSettings();
        settings.put(LAUNCH_MODE, launchMode);
        try {
            settings.flush();
        }
        catch (BackingStoreException e) {
            CCorePlugin.log(e);
        }
    }

    public IProject getProject() {
        return this.config.getProject();
    }

    @Override
    public List<String> getBinaryParserIds() throws CoreException {
        return this.toolChain != null ? this.toolChain.getBinaryParserIds() : List.of("org.eclipse.cdt.core.ELF");
    }

    public IContainer getBuildContainer() throws CoreException {
        IProject project = this.getProject();
        IFolder buildRootFolder = project.getFolder("build");
        IFolder buildFolder = buildRootFolder.getFolder(this.name);
        NullProgressMonitor monitor = new NullProgressMonitor();
        if (!buildRootFolder.exists()) {
            buildRootFolder.create(1025, true, (IProgressMonitor)monitor);
        }
        if (!buildFolder.exists()) {
            buildFolder.create(1025, true, (IProgressMonitor)monitor);
        }
        return buildFolder;
    }

    @Override
    public URI getBuildDirectoryURI() throws CoreException {
        return this.getBuildContainer().getLocationURI();
    }

    public java.nio.file.Path getBuildDirectory() throws CoreException {
        return Paths.get(this.getBuildDirectoryURI());
    }

    @Override
    public void setBuildEnvironment(Map<String, String> env) {
        CCorePlugin.getDefault().getBuildEnvironmentManager().setEnvironment(env, this.config, true);
    }

    @Override
    public IBinary[] getBuildOutput() throws CoreException {
        IPath outputPath;
        ICProject cproject = CoreModel.getDefault().create(this.config.getProject());
        IBinaryContainer binaries = cproject.getBinaryContainer();
        IBinary[] outputs = this.getBuildOutput(binaries, outputPath = this.getBuildContainer().getFullPath());
        if (outputs.length > 0) {
            return outputs;
        }
        BinaryRunner runner = CModelManager.getDefault().getBinaryRunner(cproject);
        runner.start();
        runner.waitIfRunning();
        return this.getBuildOutput(binaries, outputPath);
    }

    private IBinary[] getBuildOutput(IBinaryContainer binaries, IPath outputPath) throws CoreException {
        return (IBinary[])Arrays.stream(binaries.getBinaries()).filter(b -> b.isExecutable() && outputPath.isPrefixOf(b.getPath())).toArray(IBinary[]::new);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setActive(IProgressMonitor monitor) throws CoreException {
        CoreModel m;
        IProject project = this.config.getProject();
        if (this.config.equals(project.getActiveBuildConfig())) {
            return;
        }
        CoreModel coreModel = m = CoreModel.getDefault();
        synchronized (coreModel) {
            IProjectDescription projectDesc = project.getDescription();
            IBuildConfiguration[] bconfigs = project.getBuildConfigs();
            LinkedHashSet<String> names = new LinkedHashSet<String>();
            IBuildConfiguration[] iBuildConfigurationArray = bconfigs;
            int n = bconfigs.length;
            int n2 = 0;
            while (n2 < n) {
                IBuildConfiguration bconfig = iBuildConfigurationArray[n2];
                names.add(bconfig.getName());
                ++n2;
            }
            names.add("");
            names.remove(this.config.getName());
            names.add(this.config.getName());
            projectDesc.setBuildConfigs(names.toArray(new String[0]));
            projectDesc.setActiveBuildConfig(this.config.getName());
            project.setDescription(projectDesc, monitor);
        }
    }

    protected Preferences getSettings() {
        return InstanceScope.INSTANCE.getNode("org.eclipse.cdt.core").node("config").node(this.getProject().getName()).node(this.config.getName());
    }

    @Override
    public IToolChain getToolChain() throws CoreException {
        return this.toolChain;
    }

    protected IToolChain getToolChain(List<String> command) throws CoreException {
        return this.getToolChain();
    }

    private IToolChain getToolChain(IResource resource) throws CoreException {
        IToolChain tc = this.tcMap.get(resource);
        if (tc == null) {
            return this.getToolChain();
        }
        return tc;
    }

    @Override
    public IEnvironmentVariable getVariable(String name) {
        IEnvironmentVariable[] vars = this.getVariables();
        if (vars != null) {
            IEnvironmentVariable[] iEnvironmentVariableArray = vars;
            int n = vars.length;
            int n2 = 0;
            while (n2 < n) {
                IEnvironmentVariable var = iEnvironmentVariableArray[n2];
                if (var.getName().equals(name)) {
                    return var;
                }
                ++n2;
            }
        }
        return null;
    }

    @Override
    public IEnvironmentVariable[] getVariables() {
        return null;
    }

    @Override
    public void addMarker(IResource file, int lineNumber, String errorDesc, int severity, String errorVar) {
        this.addMarker(new ProblemMarkerInfo(file, lineNumber, errorDesc, severity, errorVar, null));
    }

    @Override
    public void addMarker(ProblemMarkerInfo problemMarkerInfo) {
        try {
            Map<String, String> attributes;
            IMarker[] markers;
            IProject project = this.config.getProject();
            IResource markerResource = problemMarkerInfo.file;
            if (markerResource == null) {
                markerResource = project;
            }
            String externalLocation = null;
            if (problemMarkerInfo.externalPath != null && !problemMarkerInfo.externalPath.isEmpty()) {
                externalLocation = problemMarkerInfo.externalPath.toOSString();
            }
            IMarker[] iMarkerArray = markers = markerResource.findMarkers("org.eclipse.cdt.core.problem", true, 1);
            int n = markers.length;
            int n2 = 0;
            while (n2 < n) {
                String extloc;
                IMarker m = iMarkerArray[n2];
                int line = m.getAttribute("lineNumber", -1);
                int sev = m.getAttribute("severity", -1);
                String msg = (String)m.getAttribute("message");
                if (line == problemMarkerInfo.lineNumber && sev == this.mapMarkerSeverity(problemMarkerInfo.severity) && msg.equals(problemMarkerInfo.description) && ((extloc = (String)m.getAttribute("problem.externalLocation")) == externalLocation || extloc != null && extloc.equals(externalLocation))) {
                    if (project == null || project.equals((Object)markerResource.getProject())) {
                        return;
                    }
                    String source = (String)m.getAttribute("sourceId");
                    if (project.getName().equals(source)) {
                        return;
                    }
                }
                ++n2;
            }
            String type = problemMarkerInfo.getType();
            if (type == null) {
                type = "org.eclipse.cdt.core.problem";
            }
            IMarker marker = markerResource.createMarker(type);
            marker.setAttribute("message", (Object)problemMarkerInfo.description);
            marker.setAttribute("severity", this.mapMarkerSeverity(problemMarkerInfo.severity));
            marker.setAttribute("lineNumber", problemMarkerInfo.lineNumber);
            marker.setAttribute("charStart", problemMarkerInfo.startChar);
            marker.setAttribute("charEnd", problemMarkerInfo.endChar);
            if (problemMarkerInfo.variableName != null) {
                marker.setAttribute("problem.variable", (Object)problemMarkerInfo.variableName);
            }
            if (externalLocation != null) {
                URI uri = URIUtil.toURI((String)externalLocation);
                if (uri.getScheme() != null) {
                    marker.setAttribute("problem.externalLocation", (Object)externalLocation);
                    String locationText = String.format(Messages.CBuildConfiguration_Location, problemMarkerInfo.lineNumber, externalLocation);
                    marker.setAttribute("location", (Object)locationText);
                }
            } else if (problemMarkerInfo.lineNumber == 0) {
                marker.setAttribute("location", (Object)" ");
            }
            if (project != null && !project.equals((Object)markerResource.getProject())) {
                marker.setAttribute("sourceId", (Object)project.getName());
            }
            if ((attributes = problemMarkerInfo.getAttributes()) != null) {
                for (Map.Entry<String, String> entry : attributes.entrySet()) {
                    marker.setAttribute(entry.getKey(), (Object)entry.getValue());
                }
            }
        }
        catch (CoreException e) {
            CCorePlugin.log(e.getStatus());
        }
    }

    private int mapMarkerSeverity(int severity) {
        switch (severity) {
            case 2: 
            case 3: {
                return 2;
            }
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
        }
        return 2;
    }

    protected java.nio.file.Path findCommand(String command) {
        String pathStr;
        block10: {
            java.nio.file.Path cmdPath = Paths.get(command, new String[0]);
            if (cmdPath.isAbsolute()) {
                return cmdPath;
            }
            Properties environmentVariables = EnvironmentReader.getEnvVars();
            HashMap<String, String> env = new HashMap<String, String>();
            for (String key : environmentVariables.stringPropertyNames()) {
                String value = environmentVariables.getProperty(key);
                env.put(key, value);
            }
            this.setBuildEnvironment(env);
            pathStr = (String)env.get("PATH");
            if (pathStr != null) break block10;
            return null;
        }
        try {
            String[] path;
            String[] stringArray = path = pathStr.split(File.pathSeparator);
            int n = path.length;
            int n2 = 0;
            while (n2 < n) {
                String dir = stringArray[n2];
                java.nio.file.Path commandPath = Paths.get(dir, command);
                if (Files.exists(commandPath, new LinkOption[0]) && Files.isRegularFile(commandPath, new LinkOption[0])) {
                    return commandPath;
                }
                if (Platform.getOS().equals("win32") && !command.endsWith(".exe") && !command.endsWith(".bat") && Files.exists(commandPath = Paths.get(dir, String.valueOf(command) + ".exe"), new LinkOption[0])) {
                    return commandPath;
                }
                ++n2;
            }
            IToolChain tc = this.getToolChain();
            if (tc instanceof IToolChain2) {
                return Paths.get(command, new String[0]);
            }
        }
        catch (InvalidPathException invalidPathException) {
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return null;
    }

    public Process startBuildProcess(List<String> commands, IEnvironmentVariable[] envVars, IPath buildDirectory, IConsole console, IProgressMonitor monitor) throws IOException, CoreException {
        Process process = null;
        IToolChain tc = this.getToolChain();
        if (tc instanceof IToolChain2) {
            process = ((IToolChain2)((Object)tc)).startBuildProcess(this, commands, buildDirectory.toString(), envVars, console, monitor);
        } else {
            java.nio.file.Path commandPath = this.findCommand(commands.get(0));
            if (commandPath == null) {
                console.getErrorStream().write(String.format(Messages.CBuildConfiguration_CommandNotFound, commands.get(0)));
                return null;
            }
            Path cmd = new Path(commandPath.toString());
            List<String> args = commands.subList(1, commands.size());
            boolean needRefresh = CommandLauncherManager.getInstance().checkIfIncludesChanged(this);
            IToolChain t = this.getToolChain();
            if (t != null) {
                t.setProperty(NEED_REFRESH, Boolean.valueOf(needRefresh).toString());
            }
            this.launcher = CommandLauncherManager.getInstance().getCommandLauncher(this);
            Properties envProps = this.launcher.getEnvironment();
            HashMap environment = envProps.entrySet().stream().collect(Collectors.toMap(e -> String.valueOf(e.getKey()), e -> String.valueOf(e.getValue()), (prev, next) -> next, HashMap::new));
            IEnvironmentVariable[] iEnvironmentVariableArray = envVars;
            int n = envVars.length;
            int n2 = 0;
            while (n2 < n) {
                IEnvironmentVariable envVar = iEnvironmentVariableArray[n2];
                environment.put(envVar.getName(), envVar.getValue());
                ++n2;
            }
            this.setBuildEnvironment(environment);
            this.launcher.setProject(this.getProject());
            process = this.launcher.execute((IPath)cmd, args.toArray(new String[0]), BuildRunnerHelper.envMapToEnvp(environment), buildDirectory, monitor);
        }
        return process;
    }

    protected int watchProcess(IConsole console, IProgressMonitor monitor) throws CoreException {
        this.assertLauncherNotNull(this.launcher);
        return this.launcher.waitAndRead(console.getInfoStream(), console.getErrorStream(), monitor);
    }

    protected int watchProcess(IConsoleParser[] consoleParsers, IProgressMonitor monitor) throws CoreException {
        this.assertLauncherNotNull(this.launcher);
        ConsoleOutputSniffer sniffer = new ConsoleOutputSniffer(consoleParsers);
        return this.launcher.waitAndRead(sniffer.getOutputStream(), sniffer.getErrorStream(), monitor);
    }

    private void assertLauncherNotNull(ICommandLauncher launcher) {
        Assert.isNotNull((Object)launcher, (String)"Only processes launched with startBuildProcess can be watched.");
    }

    private File getScannerInfoCacheFile() {
        return CCorePlugin.getDefault().getStateLocation().append("infoCache").append(this.getProject().getName()).append(String.valueOf(this.name) + ".json").toFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadScannerInfoCache() {
        Object object = this.scannerInfoLock;
        synchronized (object) {
            if (this.scannerInfoCache == null) {
                File cacheFile = this.getScannerInfoCacheFile();
                if (cacheFile.exists()) {
                    try {
                        Throwable throwable = null;
                        Object var4_6 = null;
                        try (FileReader reader = new FileReader(cacheFile);){
                            Gson gson = this.createGson();
                            this.scannerInfoCache = (ScannerInfoCache)gson.fromJson((Reader)reader, ScannerInfoCache.class);
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (IOException e) {
                        CCorePlugin.log(e);
                    }
                }
                if (this.scannerInfoCache == null) {
                    this.scannerInfoCache = new ScannerInfoCache();
                }
                this.scannerInfoCache.initCache();
            }
        }
    }

    private Gson createGson() {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter(IExtendedScannerInfo.class, (Object)new IExtendedScannerInfoDeserializer());
        gsonBuilder.registerTypeAdapter(ExtendedScannerInfo.class, (Object)new ExtendedScannerInfoSerializer());
        Gson gson = gsonBuilder.create();
        return gson;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void saveScannerInfoCache() {
        File cacheFile = this.getScannerInfoCacheFile();
        if (!cacheFile.getParentFile().exists()) {
            try {
                Files.createDirectories(cacheFile.getParentFile().toPath(), new FileAttribute[0]);
            }
            catch (IOException e) {
                CCorePlugin.log(e);
                return;
            }
        }
        try {
            Throwable e = null;
            Object var3_6 = null;
            try (FileWriter writer = new FileWriter(this.getScannerInfoCacheFile());){
                Gson gson = this.createGson();
                Object object = this.scannerInfoLock;
                synchronized (object) {
                    gson.toJson((Object)this.scannerInfoCache, (Appendable)writer);
                }
            }
            catch (Throwable throwable) {
                if (e == null) {
                    e = throwable;
                } else if (e != throwable) {
                    e.addSuppressed(throwable);
                }
                throw e;
            }
        }
        catch (IOException e) {
            CCorePlugin.log(e);
        }
    }

    protected ScannerInfoCache getScannerInfoCache() {
        return this.scannerInfoCache;
    }

    private IExtendedScannerInfo getBaseScannerInfo(IResource resource) throws CoreException {
        IPath resPath = resource.getFullPath();
        IIncludeEntry[] includeEntries = CoreModel.getIncludeEntries(resPath);
        String[] includes = new String[includeEntries.length];
        int i = 0;
        while (i < includeEntries.length) {
            includes[i] = includeEntries[i].getFullIncludePath().toOSString();
            ++i;
        }
        IIncludeFileEntry[] includeFileEntries = CoreModel.getIncludeFileEntries(resPath);
        String[] includeFiles = new String[includeFileEntries.length];
        int i2 = 0;
        while (i2 < includeFiles.length) {
            includeFiles[i2] = includeFileEntries[i2].getFullIncludeFilePath().toOSString();
            ++i2;
        }
        IMacroEntry[] macros = CoreModel.getMacroEntries(resPath);
        HashMap<String, String> symbolMap = new HashMap<String, String>();
        int i3 = 0;
        while (i3 < macros.length) {
            symbolMap.put(macros[i3].getMacroName(), macros[i3].getMacroValue());
            ++i3;
        }
        IMacroFileEntry[] macroFileEntries = CoreModel.getMacroFileEntries(resPath);
        String[] macroFiles = new String[macroFileEntries.length];
        int i4 = 0;
        while (i4 < macroFiles.length) {
            macroFiles[i4] = macroFileEntries[i4].getFullMacroFilePath().toOSString();
            ++i4;
        }
        return new ExtendedScannerInfo(symbolMap, includes, includeFiles, macroFiles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IScannerInfo getScannerInformation(IResource resource) {
        ICElement celement;
        Object object;
        this.loadScannerInfoCache();
        IExtendedScannerInfo info = null;
        Object object2 = this.scannerInfoLock;
        synchronized (object2) {
            info = this.scannerInfoCache.getScannerInfo(resource);
        }
        boolean needsFixing = false;
        if (info != null && info.getIncludePaths().length > 0 && this.toolChain != null && this.toolChain.getId().startsWith("gcc-img-sha")) {
            needsFixing = true;
            object = info.getIncludePaths();
            int n = ((String[])object).length;
            int n2 = 0;
            while (n2 < n) {
                String includePath = object[n2];
                if (includePath.contains("org.eclipse.cdt.docker.launcher")) {
                    needsFixing = false;
                    break;
                }
                ++n2;
            }
        }
        if ((info == null || info.getIncludePaths().length == 0 || needsFixing) && (celement = CCorePlugin.getDefault().getCoreModel().create(resource)) instanceof ITranslationUnit) {
            try {
                ITranslationUnit tu = (ITranslationUnit)celement;
                IToolChain tc = this.getToolChain(resource);
                info = tc.getDefaultScannerInfo(this.getBuildConfiguration(), this.getBaseScannerInfo(resource), tu.getLanguage(), this.getBuildDirectoryURI());
                object = this.scannerInfoLock;
                synchronized (object) {
                    this.scannerInfoCache.addScannerInfo(DEFAULT_COMMAND, info, resource);
                }
                this.saveScannerInfoCache();
            }
            catch (CoreException e) {
                CCorePlugin.log(e.getStatus());
            }
        }
        return info;
    }

    @Override
    public void elementChanged(ElementChangedEvent event) {
        this.processElementDelta(event.getDelta());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processElementDelta(ICElementDelta delta) {
        IResource resource;
        if (delta == null) {
            return;
        }
        int flags = delta.getFlags();
        int kind = delta.getKind();
        if (kind == 4 && (flags & 0xC00) != 0 && (resource = delta.getElement().getResource()).getProject().equals((Object)this.getProject())) {
            this.loadScannerInfoCache();
            Object object = this.scannerInfoLock;
            synchronized (object) {
                if (!this.scannerInfoCache.hasResource(DEFAULT_COMMAND, resource)) {
                    this.scannerInfoCache.removeCommand(DEFAULT_COMMAND);
                    return;
                }
                this.scannerInfoCache.removeResource(resource);
            }
        }
        ICElementDelta[] affectedChildren = delta.getAffectedChildren();
        int i = 0;
        while (i < affectedChildren.length) {
            this.processElementDelta(affectedChildren[i]);
            ++i;
        }
    }

    private List<String> stripArgs(String argString) {
        String[] args = CommandLineUtil.argumentsToArray(argString);
        return new ArrayList<String>(Arrays.asList(args));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean processLine(String line) {
        String[] compileCommands;
        IToolChain tc;
        List<String> command = this.stripArgs(line);
        try {
            tc = this.getToolChain(command);
            compileCommands = tc.getCompileCommands();
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return false;
        }
        boolean found = false;
        block10: for (String arg : command) {
            String cc;
            if (arg.startsWith("-")) {
                return false;
            }
            String[] stringArray = compileCommands;
            int n = compileCommands.length;
            int n2 = 0;
            while (n2 < n) {
                cc = stringArray[n2];
                if (arg.endsWith(cc) && (arg.equals(cc) || arg.endsWith("/" + cc) || arg.endsWith("\\" + cc))) {
                    found = true;
                    break block10;
                }
                ++n2;
            }
            if (!Platform.getOS().equals("win32") || arg.endsWith(".exe")) continue;
            arg = String.valueOf(arg) + ".exe";
            stringArray = compileCommands;
            n = compileCommands.length;
            n2 = 0;
            while (n2 < n) {
                cc = stringArray[n2];
                if (arg.endsWith(cc) && (arg.equals(cc) || arg.endsWith("/" + cc) || arg.endsWith("\\" + cc))) {
                    found = true;
                    break block10;
                }
                ++n2;
            }
        }
        if (!found) {
            return false;
        }
        try {
            IResource[] resources = tc.getResourcesFromCommand(command, this.getBuildDirectoryURI());
            if (resources != null && resources.length > 0) {
                List<String> commandStrings = tc.stripCommand(command, resources);
                boolean needScannerRefresh = false;
                String needRefresh = tc.getProperty(NEED_REFRESH);
                if ("true".equals(needRefresh)) {
                    needScannerRefresh = true;
                }
                IResource[] iResourceArray = resources;
                int n = resources.length;
                int n3 = 0;
                while (n3 < n) {
                    java.nio.file.Path commandPath;
                    IExtendedScannerInfo info;
                    IResource resource = iResourceArray[n3];
                    this.tcMap.put(resource, tc);
                    this.loadScannerInfoCache();
                    boolean hasCommand = true;
                    Object object = this.scannerInfoLock;
                    synchronized (object) {
                        if (this.scannerInfoCache.hasCommand(commandStrings)) {
                            info = this.scannerInfoCache.getScannerInfo(commandStrings);
                            if (info.getIncludePaths().length == 0) {
                                needScannerRefresh = true;
                            }
                            if (!this.scannerInfoCache.hasResource(commandStrings, resource)) {
                                this.scannerInfoCache.addResource(commandStrings, resource);
                                this.infoChanged = true;
                            }
                        } else {
                            hasCommand = false;
                        }
                    }
                    if ((!hasCommand || needScannerRefresh) && (commandPath = this.findCommand(command.get(0))) != null) {
                        command.set(0, commandPath.toString());
                        info = tc.getScannerInfo(this.getBuildConfiguration(), command, null, resource, this.getBuildDirectoryURI());
                        Object object2 = this.scannerInfoLock;
                        synchronized (object2) {
                            this.scannerInfoCache.addScannerInfo(commandStrings, info, resource);
                            this.infoChanged = true;
                        }
                    }
                    ++n3;
                }
                return true;
            }
            return false;
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean processLine(String line, List<Job> jobsArray) {
        String[] compileCommands;
        IToolChain tc;
        List<String> command = this.stripArgs(line);
        try {
            tc = this.getToolChain(command);
            compileCommands = tc.getCompileCommands();
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return false;
        }
        boolean found = false;
        block7: for (String arg : command) {
            String cc;
            if (arg.startsWith("-")) {
                return false;
            }
            String[] stringArray = compileCommands;
            int n = compileCommands.length;
            int n2 = 0;
            while (n2 < n) {
                cc = stringArray[n2];
                if (arg.endsWith(cc) && (arg.equals(cc) || arg.endsWith("/" + cc) || arg.endsWith("\\" + cc))) {
                    found = true;
                    break block7;
                }
                ++n2;
            }
            if (!Platform.getOS().equals("win32") || arg.endsWith(".exe")) continue;
            arg = String.valueOf(arg) + ".exe";
            stringArray = compileCommands;
            n = compileCommands.length;
            n2 = 0;
            while (n2 < n) {
                cc = stringArray[n2];
                if (arg.endsWith(cc) && (arg.equals(cc) || arg.endsWith("/" + cc) || arg.endsWith("\\" + cc))) {
                    found = true;
                    break block7;
                }
                ++n2;
            }
        }
        if (!found) {
            return false;
        }
        try {
            IResource[] resources = tc.getResourcesFromCommand(command, this.getBuildDirectoryURI());
            if (resources != null && resources.length > 0) {
                List<String> commandStrings = tc.stripCommand(command, resources);
                boolean needScannerRefresh = false;
                String needRefresh = tc.getProperty(NEED_REFRESH);
                if ("true".equals(needRefresh)) {
                    needScannerRefresh = true;
                }
                IResource[] iResourceArray = resources;
                int n = resources.length;
                int n3 = 0;
                while (n3 < n) {
                    java.nio.file.Path commandPath;
                    IResource resource = iResourceArray[n3];
                    this.tcMap.put(resource, tc);
                    this.loadScannerInfoCache();
                    boolean hasCommand = true;
                    Object object = this.scannerInfoLock;
                    synchronized (object) {
                        if (this.scannerInfoCache.hasCommand(commandStrings)) {
                            IExtendedScannerInfo info = this.scannerInfoCache.getScannerInfo(commandStrings);
                            if (info.getIncludePaths().length == 0) {
                                needScannerRefresh = true;
                            }
                            if (!this.scannerInfoCache.hasResource(commandStrings, resource)) {
                                this.scannerInfoCache.addResource(commandStrings, resource);
                                this.infoChanged = true;
                            }
                        } else {
                            hasCommand = false;
                        }
                    }
                    if ((!hasCommand || needScannerRefresh) && (commandPath = this.findCommand(command.get(0))) != null) {
                        command.set(0, commandPath.toString());
                        ScannerInfoJob job = new ScannerInfoJob(String.format(Messages.CBuildConfiguration_RunningScannerInfo, resource), tc, command, resource, this.getBuildDirectoryURI(), commandStrings);
                        job.schedule();
                        jobsArray.add(job);
                    }
                    ++n3;
                }
                return true;
            }
            return false;
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return false;
        }
    }

    @Override
    public void setActive() {
        try {
            this.refreshScannerInfo();
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    protected void refreshScannerInfo() throws CoreException {
        CCorePlugin.getIndexManager().reindex(CoreModel.getDefault().create(this.getProject()));
        this.infoChanged = false;
    }

    @Override
    public void shutdown() {
        if (this.infoChanged) {
            this.saveScannerInfoCache();
            CCorePlugin.getIndexManager().reindex(CoreModel.getDefault().create(this.getProject()));
            this.infoChanged = false;
        }
    }

    @Override
    public void subscribe(IResource resource, IScannerInfoChangeListener listener) {
        List<IScannerInfoChangeListener> listeners = this.scannerInfoListeners.get(resource);
        if (listeners == null) {
            listeners = new ArrayList<IScannerInfoChangeListener>();
            this.scannerInfoListeners.put(resource, listeners);
        }
        listeners.add(listener);
    }

    @Override
    public void unsubscribe(IResource resource, IScannerInfoChangeListener listener) {
        List<IScannerInfoChangeListener> listeners = this.scannerInfoListeners.get(resource);
        if (listeners != null) {
            listeners.remove(listener);
            if (listeners.isEmpty()) {
                this.scannerInfoListeners.remove(resource);
            }
        }
    }

    public static java.nio.file.Path getCommandFromPath(java.nio.file.Path command) {
        if (command.isAbsolute()) {
            return command;
        }
        if (Platform.getOS().equals("win32") && !command.toString().endsWith(".exe")) {
            command = Paths.get(String.valueOf(command.toString()) + ".exe", new String[0]);
        }
        String path = System.getenv("PATH");
        String[] stringArray = path.split(File.pathSeparator);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String entry = stringArray[n2];
            java.nio.file.Path entryPath = Paths.get(entry, new String[0]);
            java.nio.file.Path cmdPath = entryPath.resolve(command);
            if (Files.isExecutable(cmdPath)) {
                return cmdPath;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public boolean setProperties(Map<String, String> properties) {
        Preferences settings = this.getSettings();
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            settings.put(entry.getKey(), entry.getValue());
        }
        return true;
    }

    @Override
    public Map<String, String> getProperties() {
        HashMap<String, String> properties = new HashMap<String, String>();
        Preferences settings = this.getSettings();
        try {
            String[] stringArray = settings.keys();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                String value = settings.get(key, null);
                if (value != null) {
                    properties.put(key, value);
                }
                ++n2;
            }
        }
        catch (BackingStoreException e) {
            CCorePlugin.log(e);
        }
        return properties;
    }

    @Override
    public String getProperty(String name) {
        return this.getSettings().get(name, null);
    }

    @Override
    public void setProperty(String name, String value) {
        Preferences settings = this.getSettings();
        settings.put(name, value);
    }

    @Override
    public void removeProperty(String name) {
        Preferences settings = this.getSettings();
        settings.remove(name);
    }

    @Override
    public Map<String, String> getDefaultProperties() {
        return new HashMap<String, String>();
    }

    private class ScannerInfoJob
    extends Job {
        private IToolChain toolchain;
        private List<String> command;
        private List<String> commandStrings;
        private IResource resource;
        private URI buildDirectoryURI;

        public ScannerInfoJob(String msg, IToolChain toolchain, List<String> command, IResource resource, URI buildDirectoryURI, List<String> commandStrings) {
            super(msg);
            this.toolchain = toolchain;
            this.command = command;
            this.commandStrings = commandStrings;
            this.resource = resource;
            this.buildDirectoryURI = buildDirectoryURI;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            IExtendedScannerInfo info = this.toolchain.getScannerInfo(CBuildConfiguration.this.getBuildConfiguration(), this.command, null, this.resource, this.buildDirectoryURI);
            Object object = CBuildConfiguration.this.scannerInfoLock;
            synchronized (object) {
                CBuildConfiguration.this.scannerInfoCache.addScannerInfo(this.commandStrings, info, this.resource);
                CBuildConfiguration.this.infoChanged = true;
            }
            return Status.OK_STATUS;
        }
    }
}

