/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.util;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.Protocol;

public abstract class TCFTask<V>
implements Runnable,
Future<V> {
    private V result;
    private boolean done;
    private Throwable error;
    private boolean canceled;
    private IChannel channel;
    private IChannel.IChannelListener channel_listener;

    public TCFTask() {
        Protocol.invokeLater(new Runnable(){

            @Override
            public void run() {
                block2: {
                    try {
                        TCFTask.this.run();
                    }
                    catch (Throwable x) {
                        if (TCFTask.this.done || TCFTask.this.error != null) break block2;
                        TCFTask.this.error(x);
                    }
                }
            }
        });
    }

    public TCFTask(long timeout) {
        Protocol.invokeLater(new Runnable(){

            @Override
            public void run() {
                block2: {
                    try {
                        TCFTask.this.run();
                    }
                    catch (Throwable x) {
                        if (TCFTask.this.done || TCFTask.this.error != null) break block2;
                        TCFTask.this.error(x);
                    }
                }
            }
        });
        Protocol.invokeLater(timeout, new Runnable(){

            @Override
            public void run() {
                TCFTask.this.cancel(true);
            }
        });
    }

    public TCFTask(final IChannel channel) {
        Protocol.invokeLater(new Runnable(){

            @Override
            public void run() {
                block3: {
                    try {
                        if (channel.getState() != 1) {
                            throw new Exception("Channel is closed");
                        }
                        TCFTask.this.channel = channel;
                        TCFTask.this.channel_listener = new IChannel.IChannelListener(){

                            @Override
                            public void congestionLevel(int level) {
                            }

                            @Override
                            public void onChannelClosed(Throwable error) {
                                if (error != null) {
                                    TCFTask.this.error(error);
                                } else {
                                    TCFTask.this.cancel(true);
                                }
                            }

                            @Override
                            public void onChannelOpened() {
                            }
                        };
                        channel.addChannelListener(TCFTask.this.channel_listener);
                        TCFTask.this.run();
                    }
                    catch (Throwable x) {
                        if (TCFTask.this.done || TCFTask.this.error != null) break block3;
                        TCFTask.this.error(x);
                    }
                }
            }
        });
    }

    public synchronized void done(V result) {
        assert (Protocol.isDispatchThread());
        if (this.canceled) {
            return;
        }
        assert (!this.done);
        assert (this.error == null);
        assert (this.result == null);
        this.result = result;
        this.done = true;
        if (this.channel != null) {
            this.channel.removeChannelListener(this.channel_listener);
        }
        this.notifyAll();
    }

    public synchronized void error(Throwable error) {
        assert (Protocol.isDispatchThread());
        assert (error != null);
        if (this.canceled) {
            return;
        }
        assert (this.error == null);
        assert (this.result == null);
        assert (!this.done);
        this.error = error;
        if (this.channel != null) {
            this.channel.removeChannelListener(this.channel_listener);
        }
        this.notifyAll();
    }

    @Override
    public synchronized boolean cancel(boolean mayInterruptIfRunning) {
        assert (Protocol.isDispatchThread());
        if (this.isDone()) {
            return false;
        }
        this.canceled = true;
        this.error = new CancellationException();
        if (this.channel != null) {
            this.channel.removeChannelListener(this.channel_listener);
        }
        this.notifyAll();
        return true;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public synchronized V get() throws InterruptedException, ExecutionException {
        if (TCFTask.$assertionsDisabled || !Protocol.isDispatchThread()) ** GOTO lbl4
        throw new AssertionError();
lbl-1000:
        // 1 sources

        {
            this.wait();
lbl4:
            // 2 sources

            ** while (!this.isDone())
        }
lbl5:
        // 1 sources

        if (this.error != null) {
            if (this.error instanceof ExecutionException) {
                throw (ExecutionException)this.error;
            }
            if (this.error instanceof InterruptedException) {
                throw (InterruptedException)this.error;
            }
            throw new ExecutionException("TCF task aborted", this.error);
        }
        return this.result;
    }

    /*
     * Unable to fully structure code
     */
    public synchronized V getE() {
        if (TCFTask.$assertionsDisabled || !Protocol.isDispatchThread()) ** GOTO lbl8
        throw new AssertionError();
lbl-1000:
        // 1 sources

        {
            try {
                this.wait();
                continue;
            }
            catch (InterruptedException x) {
                throw new Error(x);
            }
lbl8:
            // 2 sources

            ** while (!this.isDone())
        }
lbl9:
        // 1 sources

        if (this.error != null) {
            if (this.error instanceof Error) {
                throw (Error)this.error;
            }
            throw new Error("TCF task aborted", this.error);
        }
        return this.result;
    }

    /*
     * Unable to fully structure code
     */
    public synchronized V getIO() throws IOException {
        if (TCFTask.$assertionsDisabled || !Protocol.isDispatchThread()) ** GOTO lbl8
        throw new AssertionError();
lbl-1000:
        // 1 sources

        {
            try {
                this.wait();
                continue;
            }
            catch (InterruptedException x) {
                throw new InterruptedIOException();
            }
lbl8:
            // 2 sources

            ** while (!this.isDone())
        }
lbl9:
        // 1 sources

        if (this.error != null) {
            if (this.error instanceof IOException) {
                throw (IOException)this.error;
            }
            y = new IOException("TCF task aborted");
            y.initCause(this.error);
            throw y;
        }
        return this.result;
    }

    @Override
    public synchronized V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        assert (!Protocol.isDispatchThread());
        if (!this.isDone()) {
            this.wait(unit.toMillis(timeout));
            if (!this.isDone()) {
                throw new TimeoutException();
            }
        }
        if (this.error != null) {
            if (this.error instanceof InterruptedException) {
                throw (InterruptedException)this.error;
            }
            if (this.error instanceof ExecutionException) {
                throw (ExecutionException)this.error;
            }
            if (this.error instanceof TimeoutException) {
                throw (TimeoutException)this.error;
            }
            throw new ExecutionException("TCF task aborted", this.error);
        }
        return this.result;
    }

    @Override
    public synchronized boolean isCancelled() {
        return this.canceled;
    }

    @Override
    public synchronized boolean isDone() {
        return this.error != null || this.done;
    }

    protected Throwable getError() {
        return this.error;
    }

    protected V getResult() {
        return this.result;
    }
}

