/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.services.remote;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.tcf.core.Command;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.IService;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.protocol.JSON;
import org.eclipse.tcf.services.IMemoryMap;
import org.eclipse.tcf.util.TCFMemoryRegion;

public class MemoryMapProxy
implements IMemoryMap {
    private final IChannel channel;
    private final Map<IMemoryMap.MemoryMapListener, IChannel.IEventListener> listeners = new HashMap<IMemoryMap.MemoryMapListener, IChannel.IEventListener>();

    static {
        JSON.addObjectWriter(IMemoryMap.MemoryRegion.class, new JSON.ObjectWriter<IMemoryMap.MemoryRegion>(){

            @Override
            public void write(IMemoryMap.MemoryRegion r) throws IOException {
                JSON.writeObject(r.getProperties());
            }
        });
    }

    public MemoryMapProxy(IChannel channel) {
        this.channel = channel;
    }

    @Override
    public String getName() {
        return "MemoryMap";
    }

    @Override
    public IToken get(String id, final IMemoryMap.DoneGet done) {
        return new Command((IChannel)this.channel, (IService)this, (String)"get", (Object[])new Object[]{id}){

            @Override
            public void done(Exception error, Object[] args) {
                IMemoryMap.MemoryRegion[] map = null;
                if (error == null) {
                    if (!$assertionsDisabled && args.length != 2) {
                        throw new AssertionError();
                    }
                    error = this.toError(args[0]);
                    map = MemoryMapProxy.this.toMemoryMap(args[1]);
                }
                done.doneGet(this.token, error, map);
            }
        }.token;
    }

    @Override
    public IToken set(String id, IMemoryMap.MemoryRegion[] map, final IMemoryMap.DoneSet done) {
        return new Command((IChannel)this.channel, (IService)this, (String)"set", (Object[])new Object[]{id, map}){

            @Override
            public void done(Exception error, Object[] args) {
                if (error == null) {
                    if (!$assertionsDisabled && args.length != 1) {
                        throw new AssertionError();
                    }
                    error = this.toError(args[0]);
                }
                done.doneSet(this.token, error);
            }
        }.token;
    }

    private IMemoryMap.MemoryRegion[] toMemoryMap(Object o) {
        if (o == null) {
            return null;
        }
        int i = 0;
        Collection c = (Collection)o;
        IMemoryMap.MemoryRegion[] map = new IMemoryMap.MemoryRegion[c.size()];
        for (Object x : c) {
            map[i++] = this.toMemoryRegion(x);
        }
        return map;
    }

    private IMemoryMap.MemoryRegion toMemoryRegion(Object o) {
        if (o == null) {
            return null;
        }
        return new TCFMemoryRegion((Map)o);
    }

    @Override
    public void addListener(final IMemoryMap.MemoryMapListener listener) {
        IChannel.IEventListener l = new IChannel.IEventListener(){

            @Override
            public void event(String name, byte[] data) {
                try {
                    Object[] args = JSON.parseSequence(data);
                    if (name.equals("changed")) {
                        if (!$assertionsDisabled && args.length != 1) {
                            throw new AssertionError();
                        }
                    } else {
                        throw new IOException("Memory Map service: unknown event: " + name);
                    }
                    listener.changed((String)args[0]);
                }
                catch (Throwable x) {
                    MemoryMapProxy.this.channel.terminate(x);
                }
            }
        };
        this.channel.addEventListener(this, l);
        this.listeners.put(listener, l);
    }

    @Override
    public void removeListener(IMemoryMap.MemoryMapListener listener) {
        IChannel.IEventListener l = this.listeners.remove(listener);
        if (l != null) {
            this.channel.removeEventListener(this, l);
        }
    }
}

