/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.views;

import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.linuxtools.docker.core.IDockerContainer;
import org.eclipse.swt.widgets.TableColumn;

public class DockerContainersComparator
extends ViewerComparator {
    private final TableViewer tableViewer;
    private int sortColumnIndex;
    private int sortDirection;

    public DockerContainersComparator(TableViewer tableViewer) {
        this.tableViewer = tableViewer;
    }

    public void setColumn(TableColumn sortColumn) {
        TableColumn[] tableColumns = this.tableViewer.getTable().getColumns();
        int newSortColumnIndex = 0;
        int i = 0;
        while (i < tableColumns.length) {
            if (this.tableViewer.getTable().getColumns()[i] == sortColumn) {
                newSortColumnIndex = i;
                break;
            }
            ++i;
        }
        this.sortDirection = this.sortColumnIndex != newSortColumnIndex ? 128 : (this.sortDirection == 128 ? 1024 : 128);
        this.sortColumnIndex = newSortColumnIndex;
        this.tableViewer.getTable().setSortColumn(sortColumn);
        this.tableViewer.getTable().setSortDirection(this.sortDirection);
    }

    public int getDirection() {
        return this.sortDirection;
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        if (!(e1 instanceof IDockerContainer) || !(e2 instanceof IDockerContainer)) {
            return 0;
        }
        int tmp = this.compareByColumn((IDockerContainer)e1, (IDockerContainer)e2);
        return tmp * this.sortDirection;
    }

    private int compareByColumn(IDockerContainer container1, IDockerContainer container2) {
        ColumnLabelProvider sortColumnLabelProvider = (ColumnLabelProvider)this.tableViewer.getLabelProvider(this.sortColumnIndex);
        String container1ColumnValue = sortColumnLabelProvider.getText((Object)container1);
        String container2ColumnValue = sortColumnLabelProvider.getText((Object)container2);
        if (this.sortDirection == 128) {
            return container1ColumnValue.compareToIgnoreCase(container2ColumnValue);
        }
        return container1ColumnValue.compareToIgnoreCase(container2ColumnValue) * -1;
    }
}

