/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.lexer;

import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import org.eclipse.photran.internal.core.lexer.DynamicIntArray;
import org.eclipse.photran.internal.core.lexer.OffsetLineReader;
import org.eclipse.photran.internal.core.lexer.PositionInFile;
import org.eclipse.photran.internal.core.lexer.PreLexerLine;
import org.eclipse.photran.internal.core.preferences.FortranPreferences;

class FixedFormLexerPrepass {
    private static final int inStart = 0;
    private static final int inHollerith = 1;
    private static final int inDblQuote = 2;
    private static final int inDblQuoteEnd = 3;
    private static final int inQuote = 4;
    private static final int inQuoteEnd = 5;
    private StringBuilder strBuilder = new StringBuilder();
    private int state = 0;
    private int hollerithLength = -2;
    private int actLinePos = 0;
    private PreLexerLine actLine = null;
    private OffsetLineReader in;
    private DynamicIntArray lineMapping = new DynamicIntArray(1000);
    private DynamicIntArray columnMapping = new DynamicIntArray(1000);
    private DynamicIntArray offsetMapping = new DynamicIntArray(1000);
    private HashMap<PositionInFile, String> whiteSpaceMapping = new HashMap();
    private String prevWhiteSpace = "";
    private int EOFLinePos = 0;
    private int EOFColPos = 0;
    private int EOFOffsetPos = 0;

    public FixedFormLexerPrepass(Reader in) {
        this.in = new OffsetLineReader(in);
    }

    public int getLine(int absCharPos) {
        if (absCharPos < 0) {
            return 0;
        }
        int lastCharPos = this.lineMapping.length() - 1;
        return this.lineMapping.get(Math.min(absCharPos, lastCharPos));
    }

    public int getColumn(int absCharPos) {
        if (absCharPos < 0) {
            return 0;
        }
        int lastCharPos = this.lineMapping.length() - 1;
        return this.columnMapping.get(Math.min(absCharPos, lastCharPos));
    }

    public int getOffset(int absCharPos) {
        if (absCharPos < 0) {
            return absCharPos;
        }
        int lastCharPos = this.lineMapping.length() - 1;
        return this.offsetMapping.get(Math.min(absCharPos, lastCharPos));
    }

    public int read() throws Exception {
        int c = this.internalRead();
        return c;
    }

    public String getTokenText(int offset, int length) {
        int strLen = this.strBuilder.length();
        if (offset >= 0 && length > 0 && offset < strLen && length <= strLen && offset + length < strLen) {
            String res = this.strBuilder.substring(offset, offset + length);
            return res;
        }
        return "";
    }

    public String getTokenText(int offset) {
        if (offset >= 0 && offset < this.strBuilder.length()) {
            String res = this.strBuilder.substring(offset);
            return res;
        }
        return "";
    }

    public String getTrailingWhitespace() {
        String trimmed = this.strBuilder.toString().trim();
        int start = this.strBuilder.indexOf(trimmed) + trimmed.length() + this.in.getFileEOL().length();
        String res = this.strBuilder.substring(start);
        return res;
    }

    private void markPosition(int line, int col, int offset) {
        this.offsetMapping.pushBack(offset);
        this.lineMapping.pushBack(line);
        this.columnMapping.pushBack(col);
    }

    private int internalRead() throws Exception {
        PreLexerLine prevLine = null;
        while (true) {
            if (this.actLine == null) {
                this.actLine = this.getNextLine();
                if (this.actLine == null) {
                    this.markPosition(this.EOFLinePos, this.EOFColPos, this.EOFOffsetPos);
                    return -1;
                }
                this.actLinePos = 0;
            } else if (this.actLinePos == this.actLine.length() || this.actLinePos == FortranPreferences.FIXED_FORM_COMMENT_COLUMN.getValue()) {
                prevLine = this.actLine;
                this.actLine = this.getNextLine();
                if (this.actLine == null) {
                    this.hollerithLength = -2;
                    this.state = 0;
                    this.markPosition(prevLine.linePos, this.actLinePos, prevLine.offset + this.actLinePos + 1);
                    return 10;
                }
                if (this.actLine.type == 1) {
                    this.actLinePos = 6;
                } else if (this.actLine.type == 0) {
                    this.prevWhiteSpace = this.prevWhiteSpace.concat(this.actLine.getText());
                    this.prevWhiteSpace = this.prevWhiteSpace.concat(this.in.getFileEOL());
                    this.actLinePos = this.actLine.length();
                } else {
                    this.actLinePos = 0;
                    this.hollerithLength = -2;
                    this.state = 0;
                    this.markPosition(prevLine.linePos, prevLine.length(), prevLine.offset + prevLine.length());
                    return 10;
                }
            }
            this.actLinePos = this.getNextSigPos(this.actLine, this.actLinePos);
            if (this.actLinePos >= 0) break;
            this.actLinePos = this.actLine.length();
        }
        this.markPosition(this.actLine.linePos, this.actLinePos, this.actLine.offset + this.actLinePos);
        return this.actLine.charAt(this.actLinePos++);
    }

    private PreLexerLine getNextLine() {
        String line;
        int actOffset;
        block3: {
            try {
                actOffset = this.in.getOffset();
                line = this.in.readLine();
                if (line != null) break block3;
                return null;
            }
            catch (IOException e) {
                return null;
            }
        }
        this.strBuilder.append(line);
        this.strBuilder.append(this.in.getFileEOL());
        this.EOFLinePos = this.in.getLineNumber() + 1;
        this.EOFColPos = 0;
        this.EOFOffsetPos = actOffset + line.length() + this.in.getFileEOL().length();
        PreLexerLine pll = new PreLexerLine(line, this.in.getLineNumber() - 1, actOffset);
        return pll;
    }

    private boolean isWhitespace(char c) {
        return c == ' ' || c == '\t' || c == '\r' || c == '\n';
    }

    public String getWhitespaceBefore(int ln, int lastCol, int lastOffset) {
        int colBefore = lastCol;
        int offsetBefore = lastOffset;
        if (colBefore < 0 || offsetBefore < 0) {
            return "";
        }
        PositionInFile posInFile = new PositionInFile(ln, colBefore, offsetBefore, false);
        String result = this.whiteSpaceMapping.get(posInFile);
        if (result == null) {
            return "";
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    private int extractWhitespace(PreLexerLine line, int startPos) {
        whiteAgg = "";
        charPos = startPos;
        startWhitespace = -1;
        length = line.length();
        if (line.type != 0) ** GOTO lbl25
        startWhitespace = this.saveWhitespace(line, charPos, startWhitespace);
        charPos = -1;
        return charPos;
lbl-1000:
        // 1 sources

        {
            c = line.charAt(charPos);
            if (line.type == 1 && charPos == 6) {
                if (startWhitespace == -1) {
                    startWhitespace = 0;
                }
                prevLineWhite = this.in.getFileEOL().concat(line.getText().substring(0, 6));
                whiteAgg = whiteAgg.concat(prevLineWhite);
            }
            if (this.isWhitespace(c)) {
                if (startWhitespace == -1) {
                    startWhitespace = charPos;
                }
            } else {
                if (c != '!' && charPos < FortranPreferences.FIXED_FORM_COMMENT_COLUMN.getValue()) break;
                startWhitespace = this.saveWhitespace(line, charPos, startWhitespace);
                charPos = -1;
                return charPos;
            }
            whiteAgg = whiteAgg.concat(String.valueOf(c));
            ++charPos;
lbl25:
            // 2 sources

            ** while (charPos < line.length())
        }
lbl26:
        // 2 sources

        if ((whiteAgg.length() != 0 || this.prevWhiteSpace.length() != 0) && startWhitespace != -1) {
            posInFile = new PositionInFile(line.linePos, startWhitespace, charPos, line.offset + startWhitespace, line.offset + charPos);
            combinedWhite = this.prevWhiteSpace.concat(whiteAgg);
            this.whiteSpaceMapping.put(posInFile, combinedWhite);
            this.prevWhiteSpace = "";
            if (charPos >= FortranPreferences.FIXED_FORM_COMMENT_COLUMN.getValue()) {
                charPos = -1;
            }
        }
        if (charPos >= length) {
            return -1;
        }
        return charPos;
    }

    private int saveWhitespace(PreLexerLine line, int charPos, int startWhitespace) {
        if (startWhitespace == -1) {
            startWhitespace = charPos;
        }
        this.prevWhiteSpace = this.prevWhiteSpace.concat(line.getText().substring(charPos));
        this.prevWhiteSpace = this.prevWhiteSpace.concat(this.in.getFileEOL());
        return startWhitespace;
    }

    private int getNextSigPos(PreLexerLine line, int startPos) {
        int charPos = startPos;
        while (charPos < line.length()) {
            char c = line.charAt(charPos);
            if (line.type == 3) {
                return charPos;
            }
            if (line.type != 1 || charPos > 5) {
                if (this.state == 0 && (this.isWhitespace(c) || c == '!' || line.type == 0 || charPos >= FortranPreferences.FIXED_FORM_COMMENT_COLUMN.getValue() || line.type == 1)) {
                    if ((charPos = this.extractWhitespace(line, charPos)) >= 0 && charPos < line.length()) {
                        c = line.charAt(charPos);
                    } else {
                        return -1;
                    }
                }
                if (this.state == 0) {
                    if (charPos > 4 || Character.isDigit(c)) {
                        if (c == '\'') {
                            this.hollerithLength = -1;
                            this.state = 4;
                        } else if (c == '\"') {
                            this.hollerithLength = -1;
                            this.state = 2;
                        } else if ((c == 'h' || c == 'H') && line.hollerithsOK()) {
                            if (this.hollerithLength > 0) {
                                this.state = 1;
                            } else if (this.hollerithLength < 0) {
                                this.hollerithLength = -2;
                            }
                        } else {
                            this.hollerithLength = this.hollerithLength != -2 && Character.isDigit(c) ? (this.hollerithLength == -1 ? Character.digit(c, 10) : this.hollerithLength * 10 + Character.digit(c, 10)) : (Character.isLetter(c) || c == '_' ? -2 : (charPos == 0 ? -2 : -1));
                        }
                        return charPos;
                    }
                } else {
                    if (this.state == 4) {
                        if (c == '\'') {
                            this.state = 5;
                        }
                        return charPos;
                    }
                    if (this.state == 5) {
                        if (c == '\'') {
                            this.state = 4;
                            return charPos;
                        }
                        this.state = 0;
                        --charPos;
                    } else {
                        if (this.state == 2) {
                            if (c == '\"') {
                                this.state = 5;
                            }
                            return charPos;
                        }
                        if (this.state == 3) {
                            if (c == '\"') {
                                this.state = 2;
                                return charPos;
                            }
                            this.state = 0;
                            --charPos;
                        } else {
                            if (this.state == 1) {
                                --this.hollerithLength;
                                if (this.hollerithLength == 0) {
                                    this.state = 0;
                                }
                                return charPos;
                            }
                            throw new RuntimeException("Undefined state in FixedFormPreLexer");
                        }
                    }
                }
            }
            ++charPos;
        }
        return -1;
    }

    public String getFileEOL() {
        return this.in.getFileEOL();
    }
}

