/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ua.core.cheatsheet.comp;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.pde.internal.core.XMLPrintHandler;
import org.eclipse.pde.internal.core.util.PDETextHelper;
import org.eclipse.pde.internal.ua.core.cheatsheet.comp.CompCSObject;
import org.eclipse.pde.internal.ua.core.icheatsheet.comp.ICompCS;
import org.eclipse.pde.internal.ua.core.icheatsheet.comp.ICompCSModel;
import org.eclipse.pde.internal.ua.core.icheatsheet.comp.ICompCSModelFactory;
import org.eclipse.pde.internal.ua.core.icheatsheet.comp.ICompCSObject;
import org.eclipse.pde.internal.ua.core.icheatsheet.comp.ICompCSTaskObject;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class CompCS
extends CompCSObject
implements ICompCS {
    private String fFieldName;
    private ICompCSTaskObject fFieldTaskObject;
    private static final long serialVersionUID = 1L;

    public CompCS(ICompCSModel model) {
        super(model, null);
        this.reset();
    }

    @Override
    public List<ICompCSTaskObject> getChildren() {
        ArrayList<ICompCSTaskObject> list = new ArrayList<ICompCSTaskObject>();
        if (this.fFieldTaskObject != null) {
            list.add(this.fFieldTaskObject);
        }
        return list;
    }

    @Override
    public String getName() {
        return this.fFieldName;
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    protected void parseAttributes(Element element) {
        this.fFieldName = element.getAttribute("name").trim();
    }

    @Override
    protected void parseElement(Element element) {
        String name = element.getNodeName();
        ICompCSModelFactory factory = this.getModel().getFactory();
        if (name.equals("task")) {
            this.fFieldTaskObject = factory.createCompCSTask(this);
            this.fFieldTaskObject.parse(element);
        } else if (name.equals("taskGroup")) {
            this.fFieldTaskObject = factory.createCompCSTaskGroup(this);
            this.fFieldTaskObject.parse(element);
        }
    }

    @Override
    public void reset() {
        this.fFieldName = null;
        this.fFieldTaskObject = null;
    }

    @Override
    public void write(String indent, PrintWriter writer) {
        try {
            XMLPrintHandler.printHead((Writer)writer, (String)"UTF-8");
            super.write(indent, writer);
        }
        catch (IOException iOException) {}
    }

    @Override
    protected void writeAttributes(StringBuilder buffer) {
        if (this.fFieldName != null && this.fFieldName.length() > 0) {
            buffer.append(XMLPrintHandler.wrapAttribute((String)"name", (String)PDETextHelper.translateWriteText((String)this.fFieldName.trim(), (HashMap)DEFAULT_SUBSTITUTE_CHARS)));
        }
    }

    @Override
    protected void writeElements(String indent, PrintWriter writer) {
        String newIndent = String.valueOf(indent) + "   ";
        if (this.fFieldTaskObject != null) {
            this.fFieldTaskObject.write(newIndent, writer);
        }
    }

    @Override
    public String getFieldName() {
        return this.fFieldName;
    }

    @Override
    public ICompCSTaskObject getFieldTaskObject() {
        return this.fFieldTaskObject;
    }

    @Override
    public void setFieldName(String name) {
        String old = this.fFieldName;
        this.fFieldName = name;
        if (this.isEditable()) {
            this.firePropertyChanged("name", old, this.fFieldName);
        }
    }

    @Override
    public void setFieldTaskObject(ICompCSTaskObject taskObject) {
        ICompCSTaskObject old = this.fFieldTaskObject;
        this.fFieldTaskObject = taskObject;
        if (this.isEditable()) {
            this.fireStructureChanged((ICompCSObject)this.fFieldTaskObject, old);
        }
    }

    @Override
    public String getElement() {
        return "compositeCheatsheet";
    }

    @Override
    protected void parseText(Text text) {
    }
}

