/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.rete.network.mailbox.timely;

import java.util.Map;
import java.util.TreeMap;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.matchers.util.CollectionsFactory;
import org.eclipse.viatra.query.runtime.rete.network.Direction;
import org.eclipse.viatra.query.runtime.rete.network.Receiver;
import org.eclipse.viatra.query.runtime.rete.network.ReteContainer;
import org.eclipse.viatra.query.runtime.rete.network.communication.CommunicationGroup;
import org.eclipse.viatra.query.runtime.rete.network.communication.MessageSelector;
import org.eclipse.viatra.query.runtime.rete.network.communication.Timestamp;
import org.eclipse.viatra.query.runtime.rete.network.mailbox.AdaptableMailbox;
import org.eclipse.viatra.query.runtime.rete.network.mailbox.FallThroughCapableMailbox;
import org.eclipse.viatra.query.runtime.rete.network.mailbox.Mailbox;

public class TimelyMailbox
implements AdaptableMailbox,
FallThroughCapableMailbox {
    protected TreeMap<Timestamp, Map<Tuple, Integer>> queue;
    protected TreeMap<Timestamp, Map<Tuple, Integer>> buffer;
    protected final Receiver receiver;
    protected final ReteContainer container;
    protected boolean delivering;
    protected Mailbox adapter;
    protected CommunicationGroup group;
    protected boolean fallThrough;

    public TimelyMailbox(Receiver receiver, ReteContainer container) {
        this.receiver = receiver;
        this.container = container;
        this.queue = CollectionsFactory.createTreeMap();
        this.buffer = CollectionsFactory.createTreeMap();
        this.adapter = this;
    }

    protected TreeMap<Timestamp, Map<Tuple, Integer>> getActiveQueue() {
        if (this.delivering) {
            return this.buffer;
        }
        return this.queue;
    }

    @Override
    public Mailbox getAdapter() {
        return this.adapter;
    }

    @Override
    public void setAdapter(Mailbox adapter) {
        this.adapter = adapter;
    }

    @Override
    public boolean isEmpty() {
        return this.getActiveQueue().isEmpty();
    }

    @Override
    public void postMessage(Direction direction, Tuple update, Timestamp timestamp) {
        Integer count;
        TreeMap<Timestamp, Map<Tuple, Integer>> activeQueue = this.getActiveQueue();
        Map tupleMap = activeQueue.get(timestamp);
        boolean wasEmpty = tupleMap == null;
        boolean significantChange = false;
        if (tupleMap == null) {
            tupleMap = CollectionsFactory.createMap();
            activeQueue.put(timestamp, tupleMap);
            significantChange = true;
        }
        if ((count = (Integer)tupleMap.get(update)) == null) {
            count = 0;
            significantChange = true;
        }
        if ((count = direction == Direction.REVOKE ? Integer.valueOf(count - 1) : Integer.valueOf(count + 1)) == 0) {
            tupleMap.remove(update);
            if (tupleMap.isEmpty()) {
                activeQueue.remove(timestamp);
            }
            significantChange = true;
        } else {
            tupleMap.put(update, count);
        }
        if (significantChange) {
            Mailbox targetMailbox = this.adapter;
            CommunicationGroup targetGroup = this.adapter.getCurrentGroup();
            if (wasEmpty) {
                targetGroup.notifyHasMessage(targetMailbox, timestamp);
            } else if (tupleMap.isEmpty()) {
                targetGroup.notifyLostAllMessages(targetMailbox, timestamp);
            }
        }
    }

    @Override
    public void deliverAll(MessageSelector selector) {
        if (selector instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)selector;
            this.delivering = true;
            Map<Tuple, Integer> tupleMap = this.queue.remove(timestamp);
            for (Map.Entry<Tuple, Integer> entry : tupleMap.entrySet()) {
                Direction direction;
                int count = entry.getValue();
                if (count < 0) {
                    direction = Direction.REVOKE;
                    count = -count;
                } else {
                    direction = Direction.INSERT;
                }
                int i = 0;
                while (i < count) {
                    this.receiver.update(direction, entry.getKey(), timestamp);
                    ++i;
                }
            }
        } else {
            throw new IllegalArgumentException("Unsupported message selector " + selector);
        }
        this.delivering = false;
        this.mergeBufferIntoQueue();
        this.buffer = CollectionsFactory.createTreeMap();
    }

    protected void mergeBufferIntoQueue() {
        for (Map.Entry<Timestamp, Map<Tuple, Integer>> outerEntry : this.buffer.entrySet()) {
            Timestamp selector = outerEntry.getKey();
            Map<Tuple, Integer> tupleMap = this.queue.get(selector);
            if (tupleMap == null) {
                this.queue.put(selector, outerEntry.getValue());
                continue;
            }
            for (Map.Entry<Tuple, Integer> innerEntry : outerEntry.getValue().entrySet()) {
                Tuple tuple = innerEntry.getKey();
                Integer queueCount = tupleMap.get(tuple);
                Integer bufferCount = innerEntry.getValue();
                if (queueCount == null) {
                    tupleMap.put(tuple, bufferCount);
                    continue;
                }
                int sum = bufferCount + queueCount;
                if (sum != 0) {
                    tupleMap.put(tuple, sum);
                    continue;
                }
                tupleMap.remove(tuple);
            }
        }
    }

    public String toString() {
        return "DDF_MBOX (" + this.receiver + ") " + this.getActiveQueue();
    }

    @Override
    public Receiver getReceiver() {
        return this.receiver;
    }

    public void clear() {
        this.queue.clear();
        this.buffer.clear();
    }

    @Override
    public CommunicationGroup getCurrentGroup() {
        return this.group;
    }

    @Override
    public void setCurrentGroup(CommunicationGroup group) {
        this.group = group;
    }

    @Override
    public boolean isFallThrough() {
        return this.fallThrough;
    }

    @Override
    public void setFallThrough(boolean fallThrough) {
        this.fallThrough = fallThrough;
    }
}

