/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.ui.editor;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentRewriteSession;
import org.eclipse.jface.text.DocumentRewriteSessionType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.photran.internal.core.preferences.FortranPreferences;
import org.eclipse.photran.internal.ui.editor.HorizontalRuler;
import org.eclipse.photran.internal.ui.editor.IndentUtil;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class FortranSourceViewer
extends ProjectionViewer {
    public FortranSourceViewer(Composite parent, IVerticalRuler ruler, IOverviewRuler overviewRuler, boolean showsAnnotationOverview, int styles) {
        super(parent, ruler, overviewRuler, showsAnnotationOverview, styles);
    }

    protected void createControl(Composite parent, int styles) {
        if (FortranPreferences.ENABLE_RULER.getValue()) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout(1, false);
            layout.horizontalSpacing = 0;
            layout.verticalSpacing = 1;
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            composite.setLayout((Layout)layout);
            HorizontalRuler ruler = new HorizontalRuler(composite, 0);
            GridData gridData = new GridData(4, 128, true, false);
            gridData.heightHint = 15;
            ruler.setLayoutData(gridData);
            ruler.setSize(ruler.getSize().x, 15);
            Composite editorWrapper = new Composite(composite, 0);
            editorWrapper.setLayoutData((Object)new GridData(4, 4, true, true));
            editorWrapper.setLayout((Layout)new FillLayout());
            super.createControl(editorWrapper, styles);
            ruler.configure(this.getVerticalRuler(), this.getTextWidget());
            parent.layout(true);
        } else {
            super.createControl(parent, styles);
        }
    }

    protected void shift(boolean useDefaultPrefixes, boolean right, boolean ignoreWhitespace) {
        if (!useDefaultPrefixes && FortranPreferences.CONVERT_TABS_TO_SPACES.getValue()) {
            this.adjustIndent(right, FortranPreferences.TAB_WIDTH.getValue(), true);
        } else {
            super.shift(useDefaultPrefixes, right, ignoreWhitespace);
        }
    }

    protected void adjustIndent(boolean increase, int shiftWidth, boolean useSpaces) {
        block18: {
            if (this.fUndoManager != null) {
                this.fUndoManager.beginCompoundChange();
            }
            IDocument d = this.getDocument();
            DocumentRewriteSession rewriteSession = null;
            try {
                try {
                    if (d instanceof IDocumentExtension4) {
                        IDocumentExtension4 extension = (IDocumentExtension4)d;
                        rewriteSession = extension.startRewriteSession(DocumentRewriteSessionType.SEQUENTIAL);
                    }
                    Point selection = this.getSelectedRange();
                    int tabWidth = this.getTextWidget().getTabs();
                    int startLine = d.getLineOfOffset(selection.x);
                    int endLine = selection.y == 0 ? startLine : d.getLineOfOffset(selection.x + selection.y - 1);
                    int line = startLine;
                    while (line <= endLine) {
                        IRegion lineRegion = d.getLineInformation(line);
                        String indent = IndentUtil.getCurrentIndent(d, line, false);
                        int indentWidth = IndentUtil.computeVisualLength(indent, tabWidth);
                        int newIndentWidth = Math.max(0, indentWidth + (increase ? shiftWidth : -shiftWidth));
                        String newIndent = IndentUtil.changePrefix(indent.trim(), newIndentWidth, tabWidth, useSpaces);
                        int commonLen = FortranSourceViewer.getCommonPrefixLength(indent, newIndent);
                        if (commonLen < Math.max(indent.length(), newIndent.length())) {
                            if (commonLen > 0) {
                                indent = indent.substring(commonLen);
                                newIndent = newIndent.substring(commonLen);
                            }
                            int offset = lineRegion.getOffset() + commonLen;
                            if (!increase && newIndent.length() > indent.length() && indent.length() > 0) {
                                d.replace(offset, indent.length(), "");
                                d.replace(offset, 0, newIndent);
                            } else {
                                d.replace(offset, indent.length(), newIndent);
                            }
                        }
                        ++line;
                    }
                }
                catch (BadLocationException badLocationException) {
                    if (rewriteSession != null) {
                        ((IDocumentExtension4)d).stopRewriteSession(rewriteSession);
                    }
                    if (this.fUndoManager != null) {
                        this.fUndoManager.endCompoundChange();
                    }
                    break block18;
                }
            }
            catch (Throwable throwable) {
                if (rewriteSession != null) {
                    ((IDocumentExtension4)d).stopRewriteSession(rewriteSession);
                }
                if (this.fUndoManager != null) {
                    this.fUndoManager.endCompoundChange();
                }
                throw throwable;
            }
            if (rewriteSession != null) {
                ((IDocumentExtension4)d).stopRewriteSession(rewriteSession);
            }
            if (this.fUndoManager != null) {
                this.fUndoManager.endCompoundChange();
            }
        }
    }

    private static int getCommonPrefixLength(String s1, String s2) {
        int l1 = s1.length();
        int l2 = s2.length();
        int i = 0;
        while (i < l1 && i < l2 && s1.charAt(i) == s2.charAt(i)) {
            ++i;
        }
        return i;
    }
}

