/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.perf.ui;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.compare.IEncodedStreamContentAccessor;
import org.eclipse.compare.ResourceNode;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.linuxtools.internal.perf.ReportComparisonData;
import org.eclipse.linuxtools.internal.perf.handlers.Messages;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class ReportComparisonView
extends Viewer {
    private static final Color RED = new Color((Device)Display.getDefault(), 150, 0, 0);
    private static final Color GREEN = new Color((Device)Display.getDefault(), 0, 50, 0);
    private static final Color LIGHT_GREEN = new Color((Device)Display.getDefault(), 0, 105, 0);
    private static final Color ORANGE = new Color((Device)Display.getDefault(), 150, 100, 0);
    private static final String DIFF_ENTRY = "\\s+(\\d+(\\.\\d+)?)\\%\\s+([\\+\\-]?\\d+(\\.\\d+)?)\\%.*";
    private Composite fComposite;
    private ICompareInput fInput;
    private StyledText result;
    private Label reverseLabel;
    private boolean reverse;

    public ReportComparisonView(Composite parent) {
        this.fComposite = new Composite(parent, 0);
        this.fComposite.setLayout((Layout)new GridLayout(2, false));
        this.fComposite.setData("org.eclipse.compare.CompareUI.CompareViewerTitle", (Object)Messages.ReportComparisonView_label);
        this.reverseLabel = new Label(this.fComposite, 0);
        this.reverseLabel.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false));
        this.reverseLabel.setText(Messages.StatComparisonView_reversedLabel);
        this.reverseLabel.setVisible(false);
        Button reverse = new Button(this.fComposite, 2);
        reverse.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_ELCL_SYNCED"));
        reverse.setToolTipText(Messages.StatComparisonView_reverseToolTip);
        reverse.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        reverse.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.toggleReverse();
            this.setInput(this.fInput);
        }));
        this.result = new StyledText(this.fComposite, 768);
        this.result.setAlwaysShowScrollBars(false);
        GridData gd = new GridData(4, 4, true, true);
        gd.horizontalSpan = 2;
        this.result.setLayoutData((Object)gd);
        this.result.setEditable(false);
    }

    private void setStyledText(String input) {
        String[] lines;
        this.result.setText(input);
        this.result.setJustify(true);
        this.result.setAlignment(16384);
        this.result.setFont(JFaceResources.getFont((String)"org.eclipse.jface.textfont"));
        ArrayList<StyleRange> styles = new ArrayList<StyleRange>();
        int ptr = 0;
        String[] stringArray = lines = input.split("\n");
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            Matcher m;
            String line = stringArray[n2];
            if (Pattern.matches(DIFF_ENTRY, line) && (m = Pattern.compile(DIFF_ENTRY).matcher(line)).matches() && m.group(1) != null && m.group(3) != null) {
                try {
                    float baseline = Float.parseFloat(m.group(1).trim());
                    float delta = Float.parseFloat(m.group(3).trim());
                    if (baseline > 1.0f && Math.abs(delta) > 1.0f) {
                        StyleRange curStyleRange = delta < 0.0f ? (delta < -5.0f ? new StyleRange(ptr, line.length(), LIGHT_GREEN, null) : new StyleRange(ptr, line.length(), GREEN, null)) : (delta < 5.0f ? new StyleRange(ptr, line.length(), ORANGE, null) : new StyleRange(ptr, line.length(), RED, null));
                        styles.add(curStyleRange);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            ptr += line.length() + 1;
            ++n2;
        }
        this.result.setStyleRanges(styles.toArray(new StyleRange[0]));
    }

    public Control getControl() {
        return this.fComposite;
    }

    public Object getInput() {
        return this.fInput;
    }

    public ISelection getSelection() {
        return null;
    }

    public void refresh() {
    }

    public void setInput(Object input) {
        if (input instanceof ICompareInput) {
            this.fInput = (ICompareInput)input;
            if (this.fInput.getAncestor() != null || (this.fInput.getKind() & 0xC) != 0) {
                this.setStyledText(Messages.CompUnsupported);
            } else {
                IPath newDatum;
                IPath oldDatum;
                IProject proj = null;
                if (this.fInput.getLeft() instanceof ResourceNode) {
                    ResourceNode left = (ResourceNode)this.fInput.getLeft();
                    IResource oldData = left.getResource();
                    oldDatum = oldData.getLocation();
                    proj = oldData.getProject();
                } else {
                    IEncodedStreamContentAccessor lStream = (IEncodedStreamContentAccessor)this.fInput.getLeft();
                    oldDatum = this.generateTempFile(lStream);
                }
                if (this.fInput.getRight() instanceof ResourceNode) {
                    ResourceNode right = (ResourceNode)this.fInput.getRight();
                    IResource newData = right.getResource();
                    newDatum = newData.getLocation();
                    proj = newData.getProject();
                } else {
                    IEncodedStreamContentAccessor rStream = (IEncodedStreamContentAccessor)this.fInput.getRight();
                    newDatum = this.generateTempFile(rStream);
                }
                String title = MessageFormat.format(Messages.ContentDescription_0, oldDatum.toFile().getName(), newDatum.toFile().getName());
                ReportComparisonData diffData = this.reverse ? new ReportComparisonData(title, oldDatum, newDatum, proj) : new ReportComparisonData(title, newDatum, oldDatum, proj);
                diffData.parse();
                this.setStyledText(diffData.getPerfData());
            }
        }
        this.fComposite.layout();
    }

    public void setSelection(ISelection selection, boolean reveal) {
    }

    private IPath generateTempFile(IEncodedStreamContentAccessor stream) {
        try {
            java.nio.file.Path tmpFile = Files.createTempFile("perf-report-", ".data", new FileAttribute[0]);
            tmpFile.toFile().delete();
            Files.copy(stream.getContents(), tmpFile, new CopyOption[0]);
            return new Path(tmpFile.toString());
        }
        catch (IOException | CoreException e) {
            return null;
        }
    }

    private void toggleReverse() {
        if (this.reverse) {
            this.reverse = false;
            this.reverseLabel.setVisible(false);
        } else {
            this.reverse = true;
            this.reverseLabel.setVisible(true);
        }
    }
}

