/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.debug.core.model;

import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.wst.jsdt.chromium.JsValue;
import org.eclipse.wst.jsdt.chromium.debug.core.ChromiumDebugPlugin;
import org.eclipse.wst.jsdt.chromium.debug.core.model.DebugElementImpl;
import org.eclipse.wst.jsdt.chromium.debug.core.model.EvaluateContext;
import org.eclipse.wst.jsdt.chromium.debug.core.model.Value;
import org.eclipse.wst.jsdt.chromium.debug.core.model.Variable;

public abstract class ValueBase
extends DebugElementImpl.WithEvaluate
implements IValue {
    public static ValueBase cast(IValue value) {
        if (value instanceof ValueBase) {
            return (ValueBase)value;
        }
        return null;
    }

    protected ValueBase(EvaluateContext evaluateContext) {
        super(evaluateContext);
    }

    public abstract Value asRealValue();

    public abstract String getValueString();

    public static class ErrorMessageValue
    extends ValueBase {
        private final String message;
        private final IVariable[] innerVariables;
        private static final String REFERENCE_TYPE_NAME = "#Error Message";

        ErrorMessageValue(EvaluateContext evaluateContext, String message) {
            this(evaluateContext, message, null);
        }

        public ErrorMessageValue(EvaluateContext evaluateContext, String message, JsValue exceptionValue) {
            super(evaluateContext);
            this.message = message;
            this.innerVariables = exceptionValue == null ? Value.EMPTY_VARIABLES : new IVariable[]{Variable.forException(evaluateContext, exceptionValue)};
        }

        public String getReferenceTypeName() throws DebugException {
            return REFERENCE_TYPE_NAME;
        }

        @Override
        public String getValueString() {
            return this.message;
        }

        public boolean isAllocated() throws DebugException {
            return true;
        }

        public IVariable[] getVariables() throws DebugException {
            return this.innerVariables;
        }

        public boolean hasVariables() throws DebugException {
            return this.innerVariables.length > 0;
        }

        @Override
        public Value asRealValue() {
            return null;
        }
    }

    public static abstract class ValueWithLazyVariables
    extends ValueBase {
        static final IVariable[] EMPTY_VARIABLES = new IVariable[0];
        private final AtomicReference<IVariable[]> variablesRef = new AtomicReference<Object>(null);

        protected ValueWithLazyVariables(EvaluateContext evaluateContext) {
            super(evaluateContext);
        }

        public IVariable[] getVariables() throws DebugException {
            try {
                IVariable[] result = this.variablesRef.get();
                if (result != null) {
                    return result;
                }
                IVariable[] variables = this.calculateVariables();
                this.variablesRef.compareAndSet(null, variables);
                return this.variablesRef.get();
            }
            catch (RuntimeException e) {
                ChromiumDebugPlugin.log(e);
                throw new DebugException((IStatus)new Status(4, "org.eclipse.wst.jsdt.chromium.debug.core", "Failed to read variables", (Throwable)e));
            }
        }

        protected abstract IVariable[] calculateVariables();
    }
}

