/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.businessprocess;

import org.apache.commons.lang.Validate;
import org.eclipse.jubula.client.core.businessprocess.BasicCompNameCache;
import org.eclipse.jubula.client.core.businessprocess.IWritableComponentNameCache;
import org.eclipse.jubula.client.core.businessprocess.ObjectMappingCompNameCache;
import org.eclipse.jubula.client.core.businessprocess.ProjectCompNameCache;
import org.eclipse.jubula.client.core.businessprocess.TestCaseCompNameCache;
import org.eclipse.jubula.client.core.model.IAUTMainPO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;

public final class CompNameCacheFactory {
    private CompNameCacheFactory() {
    }

    public static IWritableComponentNameCache createCompNameCache(IPersistentObject node) throws IllegalArgumentException {
        Validate.notNull((Object)node);
        if (node instanceof ISpecTestCasePO || node instanceof ITestSuitePO) {
            return new TestCaseCompNameCache(node);
        }
        if (node instanceof IAUTMainPO) {
            return new ObjectMappingCompNameCache(node);
        }
        if (node instanceof IProjectPO) {
            return new ProjectCompNameCache(node);
        }
        return new BasicCompNameCache(node);
    }
}

