/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.commands;

import java.util.List;
import org.eclipse.bpel.ui.BPELEditor;
import org.eclipse.bpel.ui.commands.util.AutoUndoCommand;
import org.eclipse.bpel.ui.util.TransferBuffer;
import org.eclipse.emf.ecore.EObject;

public class BPELCopyCommand
extends AutoUndoCommand {
    TransferBuffer.Contents undo;
    TransferBuffer.Contents redo;
    BPELEditor fBpelEditor;
    List<EObject> fOriginalObjects;

    public BPELCopyCommand(BPELEditor bpelEditor) {
        super((EObject)bpelEditor.getProcess());
        this.fBpelEditor = bpelEditor;
    }

    @Override
    public boolean canDoExecute() {
        return this.fOriginalObjects != null && this.fOriginalObjects.size() > 0;
    }

    @Override
    public void doExecute() {
        TransferBuffer transferBuffer = this.fBpelEditor.getTransferBuffer();
        this.undo = transferBuffer.getContents();
        transferBuffer.copyObjectsToTransferBuffer(this.fOriginalObjects, this.fBpelEditor.getExtensionMap());
        this.redo = transferBuffer.getContents();
    }

    public void setObjectList(List<EObject> copyList) {
        this.fOriginalObjects = copyList;
    }
}

