/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.repository.sail.config;

import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.util.Configurations;
import org.eclipse.rdf4j.model.util.ModelException;
import org.eclipse.rdf4j.model.util.Values;
import org.eclipse.rdf4j.model.vocabulary.CONFIG;
import org.eclipse.rdf4j.repository.config.AbstractRepositoryImplConfig;
import org.eclipse.rdf4j.repository.config.RepositoryConfigException;
import org.eclipse.rdf4j.repository.sail.config.ProxyRepositorySchema;

public class ProxyRepositoryConfig
extends AbstractRepositoryImplConfig {
    private String proxiedID;

    public ProxyRepositoryConfig() {
        super("openrdf:ProxyRepository");
    }

    public ProxyRepositoryConfig(String proxiedID) {
        this();
        this.setProxiedRepositoryID(proxiedID);
    }

    public final void setProxiedRepositoryID(String value) {
        this.proxiedID = value;
    }

    public String getProxiedRepositoryID() {
        return this.proxiedID;
    }

    @Override
    public void validate() throws RepositoryConfigException {
        super.validate();
        if (null == this.proxiedID) {
            throw new RepositoryConfigException("No id specified for proxied repository");
        }
    }

    @Override
    public Resource export(Model model) {
        if (Configurations.useLegacyConfig()) {
            return this.exportLegacy(model);
        }
        Resource implNode = super.export(model);
        if (null != this.proxiedID) {
            model.setNamespace(CONFIG.NS);
            model.add(implNode, CONFIG.Proxy.proxiedID, Values.literal(this.proxiedID), new Resource[0]);
        }
        return implNode;
    }

    private Resource exportLegacy(Model model) {
        Resource implNode = super.export(model);
        if (null != this.proxiedID) {
            model.add(implNode, ProxyRepositorySchema.PROXIED_ID, Values.literal(this.proxiedID), new Resource[0]);
        }
        return implNode;
    }

    @Override
    public void parse(Model model, Resource implNode) throws RepositoryConfigException {
        super.parse(model, implNode);
        try {
            Configurations.getLiteralValue(model, implNode, CONFIG.Proxy.proxiedID, ProxyRepositorySchema.PROXIED_ID).ifPresent(lit -> this.setProxiedRepositoryID(lit.getLabel()));
        }
        catch (ModelException e) {
            throw new RepositoryConfigException(e.getMessage(), e);
        }
    }
}

