/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb.volume;

import java.io.File;
import java.nio.ByteBuffer;
import org.mapdb.DataInput2;
import org.mapdb.volume.Volume;

public final class ReadOnlyVolume
extends Volume {
    protected final Volume vol;

    public ReadOnlyVolume(Volume vol) {
        this.vol = vol;
    }

    @Override
    public void ensureAvailable(long offset) {
    }

    @Override
    public void truncate(long size) {
        throw new IllegalAccessError("read-only");
    }

    @Override
    public void putLong(long offset, long value) {
        throw new IllegalAccessError("read-only");
    }

    @Override
    public void putInt(long offset, int value) {
        throw new IllegalAccessError("read-only");
    }

    @Override
    public void putByte(long offset, byte value) {
        throw new IllegalAccessError("read-only");
    }

    @Override
    public void putData(long offset, byte[] src, int srcPos, int srcSize) {
        throw new IllegalAccessError("read-only");
    }

    @Override
    public void putData(long offset, ByteBuffer buf) {
        throw new IllegalAccessError("read-only");
    }

    @Override
    public void putDataOverlap(long offset, byte[] src, int srcPos, int srcSize) {
        throw new IllegalAccessError("read-only");
    }

    @Override
    public long getLong(long offset) {
        return this.vol.getLong(offset);
    }

    @Override
    public int getInt(long offset) {
        return this.vol.getInt(offset);
    }

    @Override
    public byte getByte(long offset) {
        return this.vol.getByte(offset);
    }

    @Override
    public DataInput2 getDataInput(long offset, int size) {
        return this.vol.getDataInput(offset, size);
    }

    @Override
    public DataInput2 getDataInputOverlap(long offset, int size) {
        return this.vol.getDataInputOverlap(offset, size);
    }

    @Override
    public void getData(long offset, byte[] bytes, int bytesPos, int size) {
        this.vol.getData(offset, bytes, bytesPos, size);
    }

    @Override
    public boolean isClosed() {
        return this.vol.isClosed();
    }

    @Override
    public void close() {
        this.vol.close();
    }

    @Override
    public void sync() {
        this.vol.sync();
    }

    @Override
    public int sliceSize() {
        return this.vol.sliceSize();
    }

    @Override
    public void deleteFile() {
        throw new IllegalAccessError("read-only");
    }

    @Override
    public boolean isSliced() {
        return this.vol.isSliced();
    }

    @Override
    public long length() {
        return this.vol.length();
    }

    @Override
    public void putUnsignedShort(long offset, int value) {
        throw new IllegalAccessError("read-only");
    }

    @Override
    public int getUnsignedShort(long offset) {
        return this.vol.getUnsignedShort(offset);
    }

    @Override
    public int getUnsignedByte(long offset) {
        return this.vol.getUnsignedByte(offset);
    }

    @Override
    public void putUnsignedByte(long offset, int b) {
        throw new IllegalAccessError("read-only");
    }

    @Override
    public long getSixLong(long pos) {
        return this.vol.getSixLong(pos);
    }

    @Override
    public void putSixLong(long pos, long value) {
        throw new IllegalAccessError("read-only");
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public File getFile() {
        return this.vol.getFile();
    }

    @Override
    public boolean getFileLocked() {
        return this.vol.getFileLocked();
    }

    @Override
    public void copyTo(long inputOffset, Volume target, long targetOffset, long size) {
        this.vol.copyTo(inputOffset, target, targetOffset, size);
    }

    @Override
    public void clear(long startOffset, long endOffset) {
        throw new IllegalAccessError("read-only");
    }
}

