/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.model.base;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAmount;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicLong;
import javax.xml.datatype.XMLGregorianCalendar;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Triple;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.base.AbstractBNode;
import org.eclipse.rdf4j.model.base.AbstractIRI;
import org.eclipse.rdf4j.model.base.AbstractLiteral;
import org.eclipse.rdf4j.model.base.AbstractStatement;
import org.eclipse.rdf4j.model.base.AbstractTriple;
import org.eclipse.rdf4j.model.base.CoreDatatype;

public abstract class AbstractValueFactory
implements ValueFactory {
    private static final Literal TRUE = new AbstractLiteral.BooleanLiteral(true);
    private static final Literal FALSE = new AbstractLiteral.BooleanLiteral(false);
    private final AtomicLong nodeID = new AtomicLong(ThreadLocalRandom.current().nextLong());
    static AbstractLiteral.TypedLiteral[] smallIntLiterals = new AbstractLiteral.TypedLiteral[1000];

    @Override
    public BNode createBNode() {
        return new AbstractBNode.GenericBNode(Long.toHexString(Math.abs(this.nodeID.getAndIncrement())));
    }

    @Override
    public BNode createBNode(String nodeID) {
        Objects.requireNonNull(nodeID, "null nodeID");
        return new AbstractBNode.GenericBNode(nodeID);
    }

    @Override
    public IRI createIRI(String iri) {
        Objects.requireNonNull(iri, "null iri");
        if (iri.indexOf(58) < 0) {
            throw new IllegalArgumentException("missing colon in absolute IRI");
        }
        return new AbstractIRI.GenericIRI(iri);
    }

    @Override
    public IRI createIRI(String namespace, String localName) {
        Objects.requireNonNull(namespace, "null namespace");
        Objects.requireNonNull(localName, "null localName");
        if (namespace.indexOf(58) < 0) {
            throw new IllegalArgumentException("missing colon in absolute namespace IRI");
        }
        return new AbstractIRI.GenericIRI(namespace, localName);
    }

    @Override
    public Literal createLiteral(String label) {
        Objects.requireNonNull(label, "null label");
        return new AbstractLiteral.TypedLiteral(label);
    }

    @Override
    public Literal createLiteral(String label, IRI datatype) {
        Objects.requireNonNull(label, "null label");
        if (AbstractLiteral.reserved(datatype)) {
            throw new IllegalArgumentException("reserved datatype <" + String.valueOf(datatype) + ">");
        }
        return new AbstractLiteral.TypedLiteral(label, datatype);
    }

    @Override
    public Literal createLiteral(String label, CoreDatatype datatype) {
        Objects.requireNonNull(label, "Label may not be null");
        Objects.requireNonNull(datatype, "CoreDatatype may not be null");
        if (AbstractLiteral.reserved(datatype)) {
            throw new IllegalArgumentException("reserved datatype <" + String.valueOf(datatype) + ">");
        }
        if (datatype == CoreDatatype.XSD.INTEGER) {
            if (label.length() <= 3 && !label.startsWith("+") && !label.startsWith("-")) {
                try {
                    int v = Integer.parseInt(label);
                    if (v >= 0 && v <= 999 && label.equals(Integer.toString(v))) {
                        return smallIntLiterals[v];
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            }
        } else if (datatype == CoreDatatype.XSD.BOOLEAN) {
            if ("true".equals(label) || "1".equals(label)) {
                return TRUE;
            }
            if ("false".equals(label) || "0".equals(label)) {
                return FALSE;
            }
        }
        return new AbstractLiteral.TypedLiteral(label, datatype);
    }

    @Override
    public Literal createLiteral(String label, IRI datatype, CoreDatatype coreDatatype) {
        Objects.requireNonNull(label, "Label may not be null");
        Objects.requireNonNull(datatype, "Datatype may not be null");
        Objects.requireNonNull(coreDatatype, "CoreDatatype may not be null");
        if (AbstractLiteral.reserved(coreDatatype)) {
            throw new IllegalArgumentException("reserved datatype <" + String.valueOf(datatype) + ">");
        }
        return new AbstractLiteral.TypedLiteral(label, datatype, coreDatatype);
    }

    @Override
    public Literal createLiteral(String label, String language) {
        Objects.requireNonNull(label, "null label");
        Objects.requireNonNull(language, "null language");
        if (language.isEmpty()) {
            throw new IllegalArgumentException("empty language tag");
        }
        return new AbstractLiteral.TaggedLiteral(label, language);
    }

    @Override
    public Literal createLiteral(boolean value) {
        return value ? TRUE : FALSE;
    }

    @Override
    public Literal createLiteral(byte value) {
        return new AbstractLiteral.NumberLiteral(value);
    }

    @Override
    public Literal createLiteral(short value) {
        return new AbstractLiteral.NumberLiteral(value);
    }

    @Override
    public Literal createLiteral(int value) {
        return new AbstractLiteral.NumberLiteral(value);
    }

    @Override
    public Literal createLiteral(long value) {
        return new AbstractLiteral.NumberLiteral(value);
    }

    @Override
    public Literal createLiteral(long value, CoreDatatype.XSD datatype) {
        return new AbstractLiteral.NumberLiteral(value, datatype);
    }

    @Override
    public Literal createLiteral(float value) {
        return new AbstractLiteral.NumberLiteral(value);
    }

    @Override
    public Literal createLiteral(double value) {
        return new AbstractLiteral.NumberLiteral(value);
    }

    @Override
    public Literal createLiteral(BigInteger bigInteger) {
        Objects.requireNonNull(bigInteger, "null bigIntegr");
        return new AbstractLiteral.IntegerLiteral(bigInteger);
    }

    @Override
    public Literal createLiteral(BigDecimal bigDecimal) {
        Objects.requireNonNull(bigDecimal, "null bigDecimal");
        return new AbstractLiteral.DecimalLiteral(bigDecimal);
    }

    @Override
    public Literal createLiteral(TemporalAccessor value) {
        Objects.requireNonNull(value, "null value");
        return new AbstractLiteral.TemporalAccessorLiteral(value);
    }

    @Override
    public Literal createLiteral(TemporalAmount value) {
        Objects.requireNonNull(value, "null value");
        return new AbstractLiteral.TemporalAmountLiteral(value);
    }

    @Override
    public Literal createLiteral(XMLGregorianCalendar calendar) {
        Objects.requireNonNull(calendar, "null calendar");
        return new AbstractLiteral.CalendarLiteral(calendar);
    }

    @Override
    public Literal createLiteral(Date date) {
        Objects.requireNonNull(date, "null date");
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        return new AbstractLiteral.CalendarLiteral(calendar);
    }

    @Override
    public Triple createTriple(Resource subject, IRI predicate, Value object) {
        Objects.requireNonNull(subject, "null subject");
        Objects.requireNonNull(predicate, "null predicate");
        Objects.requireNonNull(object, "null object");
        return new AbstractTriple.GenericTriple(subject, predicate, object);
    }

    @Override
    public Statement createStatement(Resource subject, IRI predicate, Value object) {
        Objects.requireNonNull(subject, "null subject");
        Objects.requireNonNull(predicate, "null predicate");
        Objects.requireNonNull(object, "null object");
        return new GenericStatement(subject, predicate, object, null);
    }

    @Override
    public Statement createStatement(Resource subject, IRI predicate, Value object, Resource context) {
        Objects.requireNonNull(subject, "null subject");
        Objects.requireNonNull(predicate, "null predicate");
        Objects.requireNonNull(object, "null object");
        return new GenericStatement(subject, predicate, object, context);
    }

    static {
        for (int i = 0; i <= 999; ++i) {
            AbstractValueFactory.smallIntLiterals[i] = new AbstractLiteral.TypedLiteral("" + i, CoreDatatype.XSD.INTEGER);
        }
    }

    static class GenericStatement
    extends AbstractStatement {
        private static final long serialVersionUID = -4116676621136121342L;
        private final Resource subject;
        private final IRI predicate;
        private final Value object;
        private final Resource context;

        GenericStatement(Resource subject, IRI predicate, Value object, Resource context) {
            this.subject = subject;
            this.predicate = predicate;
            this.object = object;
            this.context = context;
        }

        @Override
        public Resource getSubject() {
            return this.subject;
        }

        @Override
        public IRI getPredicate() {
            return this.predicate;
        }

        @Override
        public Value getObject() {
            return this.object;
        }

        @Override
        public Resource getContext() {
            return this.context;
        }
    }
}

