/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.planNodes;

import java.util.List;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Namespace;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.SimpleNamespace;
import org.eclipse.rdf4j.model.vocabulary.DCAT;
import org.eclipse.rdf4j.model.vocabulary.FOAF;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.SHACL;
import org.eclipse.rdf4j.model.vocabulary.XSD;

public class Formatter {
    public static String prefix(Value in) {
        if (in == null) {
            return "null";
        }
        if (in instanceof IRI) {
            String namespace = ((IRI)in).getNamespace();
            List<Namespace> namespaces = List.of(RDF.NS, SHACL.NS, FOAF.NS, DCAT.NS, new SimpleNamespace("http://example.com/ns#", "ex"), XSD.NS);
            for (Namespace ns : namespaces) {
                if (!namespace.equals(ns.getName())) continue;
                return ns.getPrefix() + ":" + ((IRI)in).getLocalName();
            }
        }
        return in.toString();
    }

    public static String formatSparqlQuery(String query) {
        StringBuilder stringBuilder = new StringBuilder();
        query = query.replace(" .", " .\n");
        query = query.replace("\n\n", "\n");
        String[] split = query.split("\n");
        int indent = 0;
        for (String s : split) {
            if ((s = s.trim()).startsWith("}")) {
                --indent;
            }
            for (int i = 0; i < indent; ++i) {
                stringBuilder.append("\t");
            }
            stringBuilder.append(s).append("\n");
            if (!s.endsWith("{")) continue;
            ++indent;
        }
        return stringBuilder.toString().trim();
    }
}

