/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated.util;

import java.net.URI;
import java.net.URL;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Version {
    protected static final Logger log = LoggerFactory.getLogger(Version.class);
    protected String project = "FedX";
    protected String date = "88.88.8888";
    protected String longVersion = "8.8 (build 8888)";
    protected String build = "8888";
    protected String version = "FedX 8.8";
    protected String contact = "info@fluidops.com";
    protected String companyName = "fluid Operations AG";
    protected String productName = "fluid FedX";
    private static final Version instance = new Version();

    public static Version getVersionInfo() {
        return instance;
    }

    private Version() {
        String jarPath = this.getJarPath();
        if (jarPath != null) {
            this.initializedVersionInfo(jarPath);
        }
    }

    private void initializedVersionInfo(String jarPath) {
        try (JarFile jar = new JarFile(jarPath);){
            Manifest buildManifest = jar.getManifest();
            if (buildManifest != null) {
                this.project = buildManifest.getMainAttributes().getValue("project");
                this.date = buildManifest.getMainAttributes().getValue("date");
                this.longVersion = buildManifest.getMainAttributes().getValue("version");
                this.build = buildManifest.getMainAttributes().getValue("build");
                this.version = buildManifest.getMainAttributes().getValue("ProductVersion");
                this.contact = buildManifest.getMainAttributes().getValue("ProductContact");
                this.companyName = buildManifest.getMainAttributes().getValue("CompanyName");
                this.productName = buildManifest.getMainAttributes().getValue("ProductName");
            }
        }
        catch (Exception e) {
            log.warn("Error while reading version from jar manifest: " + e.getMessage());
            log.debug("Details:", (Throwable)e);
        }
    }

    protected String getJarPath() {
        URL url = Version.class.getResource("/org/eclipse/rdf4j/federated/util/Version.class");
        String urlPath = url.getPath();
        if (!urlPath.contains("!")) {
            return null;
        }
        try {
            URI uri = new URI(url.getPath().split("!")[0]);
            return uri.getPath();
        }
        catch (Exception e) {
            log.warn("Error while retrieving jar path", (Throwable)e);
            return null;
        }
    }

    public String getVersionString() {
        return this.project + " " + this.longVersion;
    }

    public void printVersionInformation() {
        System.out.println("Version Information: " + this.project + " " + this.longVersion);
    }

    public String getProject() {
        return this.project;
    }

    public String getDate() {
        return this.date;
    }

    public String getLongVersion() {
        return this.longVersion;
    }

    public String getBuild() {
        return this.build;
    }

    public String getVersion() {
        return this.version;
    }

    public String getContact() {
        return this.contact;
    }

    public String getCompanyName() {
        return this.companyName;
    }

    public String getProductName() {
        return this.productName;
    }

    public static void main(String[] args) {
        Version.getVersionInfo().printVersionInformation();
    }
}

