/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.spin.function.spif;

import java.util.stream.Stream;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.vocabulary.RDFS;
import org.eclipse.rdf4j.model.vocabulary.SPIF;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryPreparer;
import org.eclipse.rdf4j.query.algebra.evaluation.TripleSource;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.function.Function;
import org.eclipse.rdf4j.query.algebra.evaluation.util.TripleSources;
import org.eclipse.rdf4j.spin.function.AbstractSpinFunction;

public class Name
extends AbstractSpinFunction
implements Function {
    public Name() {
        super(SPIF.NAME_FUNCTION.stringValue());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Value evaluate(ValueFactory valueFactory, Value ... args) throws ValueExprEvaluationException {
        if (args.length != 1) {
            throw new ValueExprEvaluationException(String.format("%s requires 1 argument, got %d", this.getURI(), args.length));
        }
        if (args[0] instanceof Literal) {
            return valueFactory.createLiteral(((Literal)args[0]).getLabel());
        }
        QueryPreparer qp = this.getCurrentQueryPreparer();
        try (Stream stream = TripleSources.getObjectLiterals((Resource)((Resource)args[0]), (IRI)RDFS.LABEL, (TripleSource)qp.getTripleSource()).stream();){
            Value value = (Value)stream.findFirst().orElseGet(() -> valueFactory.createLiteral(args[0].stringValue()));
            return value;
        }
        catch (QueryEvaluationException e) {
            throw new ValueExprEvaluationException((Throwable)e);
        }
    }
}

