/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.planNodes;

import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.shacl.planNodes.IteratorData;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.Tuple;
import org.eclipse.rdf4j.sail.shacl.planNodes.ValidationExecutionLogger;

public class DebugPlanNode
implements PlanNode {
    private final String message;
    PlanNode parent;
    private boolean printed;
    private ValidationExecutionLogger validationExecutionLogger;

    public DebugPlanNode(PlanNode parent, String message) {
        this.parent = parent;
        this.message = message;
    }

    @Override
    public CloseableIteration<Tuple, SailException> iterator() {
        return new CloseableIteration<Tuple, SailException>(){
            final CloseableIteration<Tuple, SailException> iterator;
            {
                this.iterator = DebugPlanNode.this.parent.iterator();
            }

            @Override
            public boolean hasNext() throws SailException {
                return this.iterator.hasNext();
            }

            @Override
            public Tuple next() throws SailException {
                Tuple next = (Tuple)this.iterator.next();
                DebugPlanNode.this.validationExecutionLogger.log(DebugPlanNode.this.depth(), DebugPlanNode.this.message, next, DebugPlanNode.this, DebugPlanNode.this.getId());
                return next;
            }

            @Override
            public void remove() throws SailException {
                this.iterator.remove();
            }

            @Override
            public void close() throws SailException {
                this.iterator.close();
            }
        };
    }

    @Override
    public int depth() {
        return this.parent.depth() + 1;
    }

    @Override
    public void getPlanAsGraphvizDot(StringBuilder stringBuilder) {
        if (this.printed) {
            return;
        }
        this.printed = true;
        stringBuilder.append(this.getId() + " [label=\"" + StringEscapeUtils.escapeJava((String)this.toString()) + "\"];").append("\n");
        stringBuilder.append(this.parent.getId() + " -> " + this.getId()).append("\n");
        this.parent.getPlanAsGraphvizDot(stringBuilder);
    }

    @Override
    public String getId() {
        return System.identityHashCode(this) + "";
    }

    public String toString() {
        return "DebugPlanNode";
    }

    @Override
    public IteratorData getIteratorDataType() {
        return this.parent.getIteratorDataType();
    }

    @Override
    public void receiveLogger(ValidationExecutionLogger validationExecutionLogger) {
        this.validationExecutionLogger = validationExecutionLogger;
        this.parent.receiveLogger(validationExecutionLogger);
    }
}

