/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.core;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.rcptt.core.persistence.PersistenceManager;
import org.eclipse.rcptt.internal.core.RcpttPlugin;

public class WorkspaceMonitor {
    public static final Object SAVE_JOB_FAMILY = "save_job_family";
    private static WorkspaceMonitor instance;
    private final Set<String> extensions = new HashSet<String>();
    private final Map<IFile, Long> fileToDate = new HashMap<IFile, Long>();
    private final ResourceSet resources = new ResourceSetImpl(){

        protected void handleDemandLoadException(Resource resource, IOException exception) throws RuntimeException {
        }
    };

    public static WorkspaceMonitor getInstance() {
        if (instance == null) {
            instance = new WorkspaceMonitor();
        }
        return instance;
    }

    private WorkspaceMonitor() {
        this.extensions.add("ctx");
        this.extensions.add("scenario");
        this.extensions.add("test");
    }

    void stop() {
        PersistenceManager.shutdown();
    }

    public static boolean isFileEmpty(IFile file) {
        boolean fileIsEmpty;
        block14: {
            fileIsEmpty = false;
            BufferedInputStream stream = null;
            try {
                try {
                    stream = new BufferedInputStream(file.getContents());
                    byte[] bb = new byte[4096];
                    int read = ((InputStream)stream).read(bb);
                    if (read == 0 || read == -1) {
                        fileIsEmpty = true;
                    }
                }
                catch (Throwable ey) {
                    if (ey instanceof EOFException) {
                        fileIsEmpty = true;
                    }
                    if (stream == null) break block14;
                    try {
                        ((InputStream)stream).close();
                    }
                    catch (IOException e) {
                        RcpttPlugin.log(e);
                    }
                }
            }
            finally {
                if (stream != null) {
                    try {
                        ((InputStream)stream).close();
                    }
                    catch (IOException e) {
                        RcpttPlugin.log(e);
                    }
                }
            }
        }
        return fileIsEmpty;
    }

    public static boolean isIgnored(IResource resource) {
        IPath path = resource.getFullPath();
        if (resource instanceof IFile) {
            path = path.removeLastSegments(1);
        }
        int i = 0;
        while (i < path.segmentCount()) {
            if (path.segment(i).startsWith(".") && path.segment(i).endsWith("ctx")) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Long removeFromFileToDate(IFile file) {
        return this.fileToDate.remove(file);
    }

    public void addToFileToDate(IFile file, Long timestamp) {
        this.fileToDate.put(file, timestamp);
    }
}

