/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ecl.data.internal.commands;

import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.rcptt.ecl.core.Command;
import org.eclipse.rcptt.ecl.data.commands.ReadXmlFile;
import org.eclipse.rcptt.ecl.data.internal.EclDataPlugin;
import org.eclipse.rcptt.ecl.data.internal.commands.XmlFileService;
import org.eclipse.rcptt.ecl.data.objects.Attribute;
import org.eclipse.rcptt.ecl.data.objects.ObjectsFactory;
import org.eclipse.rcptt.ecl.data.objects.Tree;
import org.eclipse.rcptt.ecl.filesystem.EclFile;
import org.eclipse.rcptt.ecl.filesystem.FileResolver;
import org.eclipse.rcptt.ecl.runtime.ICommandService;
import org.eclipse.rcptt.ecl.runtime.IProcess;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class ReadXmlFileService
implements ICommandService {
    public IStatus service(Command command, IProcess context) throws InterruptedException, CoreException {
        ReadXmlFile rxf = (ReadXmlFile)command;
        String xPath = rxf.getXPath();
        String uri = rxf.getUri();
        EclFile file = FileResolver.resolve((String)uri);
        Document document = XmlFileService.readXml(file);
        if (xPath != null && !xPath.equals("")) {
            NodeList nodes = null;
            try {
                XPathFactory xPathFactory = XPathFactory.newInstance();
                XPathExpression nodeXPath = xPathFactory.newXPath().compile(xPath);
                nodes = (NodeList)nodeXPath.evaluate(document, XPathConstants.NODESET);
            }
            catch (XPathExpressionException e) {
                return EclDataPlugin.createErr(e, "Invalid xPath expression %s", file.toURI());
            }
            int i = 0;
            while (i < nodes.getLength()) {
                Node child = nodes.item(i);
                if (child instanceof Element) {
                    Element childElement = (Element)child;
                    Tree tree = this.readTree(childElement);
                    context.getOutput().write((Object)tree);
                }
                if (child instanceof Attr) {
                    Attr childAttr = (Attr)child;
                    Attribute attr = ObjectsFactory.eINSTANCE.createAttribute();
                    attr.setName(childAttr.getNodeName());
                    attr.setValue(childAttr.getNodeValue());
                    context.getOutput().write((Object)attr);
                }
                if (child instanceof Text) {
                    String text = this.getText(child);
                    context.getOutput().write((Object)text);
                }
                ++i;
            }
        } else {
            Element root = document.getDocumentElement();
            Tree tree = this.readTree(root);
            context.getOutput().write((Object)tree);
        }
        return Status.OK_STATUS;
    }

    private Tree readTree(Element element) {
        Tree treeItem = ObjectsFactory.eINSTANCE.createTree();
        treeItem.setName(element.getNodeName());
        NodeList childs = element.getChildNodes();
        int i = 0;
        while (i < childs.getLength()) {
            Node child = childs.item(i);
            if (child instanceof Element) {
                Element childElement = (Element)child;
                Tree childItem = this.readTree(childElement);
                treeItem.getChildren().add((Object)childItem);
            }
            ++i;
        }
        NamedNodeMap attributes = element.getAttributes();
        int i2 = 0;
        while (i2 < attributes.getLength()) {
            Attribute attr = ObjectsFactory.eINSTANCE.createAttribute();
            Node attribute = attributes.item(i2);
            attr.setName(attribute.getNodeName());
            attr.setValue(attribute.getNodeValue());
            treeItem.getAttributes().add((Object)attr);
            ++i2;
        }
        if (treeItem.getChildren().size() == 0) {
            treeItem.setText(this.getText(element));
        }
        return treeItem;
    }

    private String getText(Node node) {
        String text = node.getTextContent();
        text = text.replaceAll("\\n", "");
        text = text.replaceAll("\\t", "");
        text = text.replaceAll("^ +", "");
        text = text.replaceAll(" +$", "");
        text = text.replaceAll("  +", " ");
        return text;
    }
}

