/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.apt.core.internal.declaration;

import com.sun.mirror.declaration.FieldDeclaration;
import com.sun.mirror.type.TypeMirror;
import com.sun.mirror.util.DeclarationVisitor;
import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.apt.core.internal.declaration.ASTBasedMemberDeclarationImpl;
import org.eclipse.jdt.apt.core.internal.declaration.EclipseMirrorObject;
import org.eclipse.jdt.apt.core.internal.env.BaseProcessorEnv;
import org.eclipse.jdt.apt.core.internal.util.Factory;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;

public class ASTBasedFieldDeclarationImpl
extends ASTBasedMemberDeclarationImpl
implements FieldDeclaration {
    public ASTBasedFieldDeclarationImpl(VariableDeclarationFragment astNode, IFile file, BaseProcessorEnv env) {
        super((ASTNode)astNode, file, env);
        assert (astNode.getParent() != null && astNode.getParent().getNodeType() == 23) : "parent isn't a field declaration";
    }

    @Override
    public void accept(DeclarationVisitor visitor) {
        visitor.visitFieldDeclaration(this);
    }

    @Override
    public String getConstantExpression() {
        Object constant = this.getConstantValue();
        if (constant == null) {
            return null;
        }
        return constant.toString();
    }

    @Override
    public Object getConstantValue() {
        VariableDeclarationFragment fragment = this.getAstNode();
        Expression initializer = fragment.getInitializer();
        if (initializer == null) {
            return null;
        }
        return initializer.resolveConstantExpressionValue();
    }

    @Override
    public String getSimpleName() {
        VariableDeclarationFragment fragment = this.getAstNode();
        SimpleName nameNode = fragment.getName();
        return nameNode == null ? "" : nameNode.getIdentifier();
    }

    @Override
    public TypeMirror getType() {
        org.eclipse.jdt.core.dom.FieldDeclaration fieldASTNode = this.getFieldDeclarationAstNode();
        Type type = fieldASTNode.getType();
        if (type == null) {
            return null;
        }
        ITypeBinding typeBinding = type.resolveBinding();
        if (typeBinding == null) {
            return Factory.createErrorClassType(type.toString());
        }
        TypeMirror typeMirror = Factory.createTypeMirror(typeBinding, this._env);
        if (typeMirror == null) {
            typeMirror = Factory.createErrorClassType(typeBinding);
        }
        return typeMirror;
    }

    public String toString() {
        return this.getSimpleName();
    }

    @Override
    public EclipseMirrorObject.MirrorKind kind() {
        return EclipseMirrorObject.MirrorKind.FIELD;
    }

    VariableDeclarationFragment getAstNode() {
        return (VariableDeclarationFragment)this._astNode;
    }

    org.eclipse.jdt.core.dom.FieldDeclaration getFieldDeclarationAstNode() {
        return (org.eclipse.jdt.core.dom.FieldDeclaration)this._astNode.getParent();
    }
}

