/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.editors.text;

import java.net.URI;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.editors.text.ILocationProvider;
import org.eclipse.ui.editors.text.ILocationProviderExtension;

public class IURIEditorInputAdapterFactory
implements IAdapterFactory {
    private static final Class<?>[] ADAPTER_LIST = new Class[]{ILocationProvider.class};
    private ILocationProvider fLocationProvider = new LocationProvider();

    public <T> T getAdapter(Object adaptableObject, Class<T> adapterType) {
        if (ILocationProvider.class.equals(adapterType) && adaptableObject instanceof IURIEditorInput) {
            return (T)this.fLocationProvider;
        }
        return null;
    }

    public Class<?>[] getAdapterList() {
        return ADAPTER_LIST;
    }

    private static class LocationProvider
    implements ILocationProvider,
    ILocationProviderExtension {
        private LocationProvider() {
        }

        @Override
        public IPath getPath(Object element) {
            URI uri = this.getURI(element);
            if (uri != null) {
                return URIUtil.toPath((URI)uri);
            }
            return null;
        }

        @Override
        public URI getURI(Object element) {
            if (element instanceof IURIEditorInput) {
                IURIEditorInput input = (IURIEditorInput)element;
                return input.getURI();
            }
            return null;
        }
    }
}

