/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.preferences;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.pde.internal.ui.IPreferenceConstants;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.text.ColorManager;
import org.eclipse.pde.internal.ui.preferences.ManifestSyntaxColorTab;
import org.eclipse.pde.internal.ui.preferences.XMLSyntaxColorTab;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.TabFolderLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class EditorPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
IPreferenceConstants {
    private XMLSyntaxColorTab fXMLTab;
    private ManifestSyntaxColorTab fManifestTab;
    private final ColorManager fColorManager;

    public EditorPreferencePage() {
        this.setDescription(PDEUIMessages.EditorPreferencePage_colorSettings);
        this.fColorManager = new ColorManager();
    }

    public boolean performOk() {
        this.fXMLTab.performOk();
        this.fManifestTab.performOk();
        PDEPlugin.getDefault().getPreferenceManager().savePluginPreferences();
        return super.performOk();
    }

    public void dispose() {
        this.fXMLTab.dispose();
        this.fManifestTab.dispose();
        super.dispose();
    }

    protected void performDefaults() {
        this.fXMLTab.performDefaults();
        this.fManifestTab.performDefaults();
        super.performDefaults();
    }

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        Link link = new Link(parent, 0);
        link.setText(PDEUIMessages.EditorPreferencePage_link);
        link.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            if ("org.eclipse.ui.preferencePages.GeneralTextEditor".equals(e.text)) {
                PreferencesUtil.createPreferenceDialogOn((Shell)link.getShell(), (String)e.text, null, null);
            } else if ("org.eclipse.ui.preferencePages.ColorsAndFonts".equals(e.text)) {
                PreferencesUtil.createPreferenceDialogOn((Shell)link.getShell(), (String)e.text, null, (Object)"selectFont:org.eclipse.jface.textfont");
            }
        }));
        GridData gd = new GridData(32);
        Button foldingButton = new Button(parent, 16480);
        foldingButton.setText(PDEUIMessages.EditorPreferencePage_folding);
        foldingButton.setLayoutData((Object)gd);
        foldingButton.setSelection(PDEPlugin.getDefault().getPreferenceStore().getBoolean("editor.folding"));
        foldingButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            IPreferenceStore store = PDEPlugin.getDefault().getPreferenceStore();
            store.setValue("editor.folding", ((Button)e.getSource()).getSelection());
        }));
        TabFolder folder = new TabFolder(parent, 0);
        folder.setLayout((Layout)new TabFolderLayout());
        folder.setLayoutData((Object)new GridData(1808));
        this.createXMLTab(folder);
        this.createManifestTab(folder);
        Dialog.applyDialogFont((Control)this.getControl());
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.pde.doc.user.editor_preference_page");
        return parent;
    }

    private void createXMLTab(TabFolder folder) {
        this.fXMLTab = new XMLSyntaxColorTab(this.fColorManager);
        TabItem item = new TabItem(folder, 0);
        item.setText(PDEUIMessages.EditorPreferencePage_xml);
        item.setControl(this.fXMLTab.createContents((Composite)folder));
    }

    private void createManifestTab(TabFolder folder) {
        this.fManifestTab = new ManifestSyntaxColorTab(this.fColorManager);
        TabItem item = new TabItem(folder, 0);
        item.setText(PDEUIMessages.EditorPreferencePage_manifest);
        item.setControl(this.fManifestTab.createContents((Composite)folder));
    }
}

