/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.codemanipulation.tostringgeneration;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.internal.corext.codemanipulation.tostringgeneration.AbstractToStringGenerator;

public class StringFormatGenerator
extends AbstractToStringGenerator {
    private List<Expression> arguments;
    private StringBuffer buffer;

    @Override
    protected void initialize() {
        super.initialize();
        this.arguments = new ArrayList<Expression>();
        this.buffer = new StringBuffer();
    }

    @Override
    protected void complete() throws CoreException {
        super.complete();
        ReturnStatement rStatement = this.fAst.newReturnStatement();
        String formatClass = "java.lang.String";
        MethodInvocation formatInvocation = this.createMethodInvocation((Expression)this.addImport(formatClass), "format", null);
        StringLiteral literal = this.fAst.newStringLiteral();
        literal.setLiteralValue(this.buffer.toString());
        formatInvocation.arguments().add(literal);
        formatInvocation.arguments().addAll(this.arguments);
        rStatement.setExpression((Expression)formatInvocation);
        this.toStringMethod.getBody().statements().add(rStatement);
    }

    @Override
    protected Object processElement(String templateElement, Object member) {
        if ("${member.value}".equals(templateElement)) {
            return this.createMemberAccessExpression(member, false, false);
        }
        return super.processElement(templateElement, member);
    }

    @Override
    protected void addElement(Object element) {
        if (element instanceof String) {
            this.buffer.append((String)element);
        }
        if (element instanceof Expression) {
            this.arguments.add((Expression)element);
            this.buffer.append("%s");
        }
    }
}

