/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.report;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.rcptt.internal.ui.Messages;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;
import org.eclipse.rcptt.reporting.core.IReportRenderer;
import org.eclipse.rcptt.reporting.core.ReportRendererManager;
import org.eclipse.rcptt.reporting.util.FileContentFactory;
import org.eclipse.rcptt.reporting.util.Q7ReportIterator;
import org.eclipse.rcptt.ui.report.ReportMainPage;
import org.eclipse.rcptt.ui.report.WorkspaceContentFactory;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class ReportWizard
extends Wizard {
    private ReportMainPage mainPage;
    private Q7ReportIterator report;
    private String name;
    private String[] disabled;
    private String initialWorkspaceLocatio;

    public ReportWizard(Q7ReportIterator report, String name) {
        this.report = report;
        this.name = name;
    }

    public Q7ReportIterator getReport() {
        return this.report;
    }

    public String getName() {
        return this.name;
    }

    public boolean performFinish() {
        IReportRenderer reportRenderer;
        ReportRendererManager.ReportRenderer renderer = this.mainPage.getRenderer();
        final String reportName = this.mainPage.getReportName();
        boolean toWorkspace = this.mainPage.isToWorkspace();
        String location = this.mainPage.getLocation();
        final WorkspaceContentFactory factory = toWorkspace ? new WorkspaceContentFactory((IPath)new Path(location)) : new FileContentFactory((IPath)new Path(location));
        if (!this.checkForFileOverwrite(factory, reportName, reportRenderer = renderer.getRenderer())) {
            return false;
        }
        try {
            this.getContainer().run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    IStatus status;
                    if (reportRenderer instanceof IReportRenderer.ProgressMonitorSupport) {
                        ((IReportRenderer.ProgressMonitorSupport)reportRenderer).setProgressMonitor(monitor);
                    }
                    if (!(status = reportRenderer.generateReport(factory, reportName, (Iterable)ReportWizard.this.getReport())).isOK()) {
                        ReportWizard.this.getShell().getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                MessageBox box = new MessageBox(ReportWizard.this.getShell());
                                box.setMessage(status.getMessage());
                                box.setText(ReportWizard.this.getShell().getText());
                                box.open();
                            }
                        });
                    }
                }
            });
        }
        catch (Throwable e) {
            Q7UIPlugin.log(e);
            return false;
        }
        return true;
    }

    private boolean checkForFileOverwrite(IReportRenderer.IContentFactory factory, String reportName, IReportRenderer reportRenderer) {
        String[] fileNames = reportRenderer.getGeneratedFileNames(reportName);
        StringBuilder existingFiles = new StringBuilder();
        int existingFilesCount = 0;
        String[] stringArray = fileNames;
        int n = fileNames.length;
        int n2 = 0;
        while (n2 < n) {
            String fname = stringArray[n2];
            List existFiles = factory.matchFiles(fname);
            if (!existFiles.isEmpty()) {
                if (existingFilesCount > 0) {
                    existingFiles.append(",\n");
                }
                ++existingFilesCount;
                existingFiles.append('\'').append(fname).append("(").append(existFiles.size()).append(")").append("'");
            }
            ++n2;
        }
        if (existingFilesCount > 0) {
            String message = existingFilesCount == 1 ? Messages.bind((String)Messages.ReportWizard_FileOverwriteDialogMsg_OneFile, (Object)existingFiles) : Messages.bind((String)Messages.ReportWizard_FileOverwriteDialogMsg_ManyFiles, (Object)existingFiles);
            return MessageDialog.openQuestion((Shell)this.getShell(), (String)Messages.ReportWizard_FileOverwriteDialogTitle, (String)message);
        }
        return true;
    }

    public void addPages() {
        this.mainPage = new ReportMainPage(this, this.disabled, this.initialWorkspaceLocatio);
        this.addPage((IWizardPage)this.mainPage);
    }

    public void setDisabledReports(String ... disabled) {
        this.disabled = disabled;
    }

    public void setInitialWorkspaceLocation(String initialWorkspaceLocation) {
        this.initialWorkspaceLocatio = initialWorkspaceLocation;
    }
}

