/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.util;

import org.eclipse.jdt.internal.corext.refactoring.changes.TextChangeCompatibility;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;

public class TextEditUtil {
    public static void insert(TextEdit parent, TextEdit edit) {
        TextChangeCompatibility.insert(parent, edit);
    }

    public static boolean isPacked(TextEdit edit) {
        if (!(edit instanceof MultiTextEdit)) {
            return true;
        }
        if (!edit.hasChildren()) {
            return true;
        }
        TextEdit[] children = edit.getChildren();
        if (edit.getOffset() != children[0].getOffset()) {
            return false;
        }
        if (edit.getExclusiveEnd() != children[children.length - 1].getExclusiveEnd()) {
            return false;
        }
        TextEdit[] textEditArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            TextEdit child = textEditArray[n2];
            if (!TextEditUtil.isPacked(child)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static MultiTextEdit flatten(TextEdit edit) {
        MultiTextEdit result = new MultiTextEdit();
        TextEditUtil.flatten(edit, result);
        return result;
    }

    private static void flatten(TextEdit edit, MultiTextEdit result) {
        if (!edit.hasChildren()) {
            result.addChild(edit);
        } else {
            TextEdit[] textEditArray = edit.getChildren();
            int n = textEditArray.length;
            int n2 = 0;
            while (n2 < n) {
                TextEdit child = textEditArray[n2];
                child.getParent().removeChild(0);
                TextEditUtil.flatten(child, result);
                ++n2;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public static boolean overlaps(TextEdit edit1, TextEdit edit2) {
        block15: {
            if (!(edit1 instanceof MultiTextEdit) || !(edit2 instanceof MultiTextEdit)) break block15;
            multiTextEdit1 = (MultiTextEdit)edit1;
            if (!multiTextEdit1.hasChildren()) {
                return false;
            }
            multiTextEdit2 = (MultiTextEdit)edit2;
            if (!multiTextEdit2.hasChildren()) {
                return false;
            }
            children1 = multiTextEdit1.getChildren();
            children2 = multiTextEdit2.getChildren();
            i1 = 0;
            i2 = 0;
            ** GOTO lbl29
            {
                if (++i1 >= children1.length) {
                    return false;
                }
                do {
                    if (children1[i1].getExclusiveEnd() < children2[i2].getOffset()) continue block0;
                    while (children2[i2].getExclusiveEnd() < children1[i1].getOffset()) {
                        if (++i2 < children2.length) continue;
                        return false;
                    }
                    if (children1[i1].getExclusiveEnd() < children2[i2].getOffset()) continue;
                    if (TextEditUtil.overlaps(children1[i1], children2[i2])) {
                        return true;
                    }
                    mergeEnd = Math.max(children1[i1].getExclusiveEnd(), children2[i2].getExclusiveEnd());
                    ++i2;
                    if (++i1 < children1.length && children1[i1].getOffset() < mergeEnd) {
                        return true;
                    }
                    if (i2 >= children2.length || children2[i2].getOffset() >= mergeEnd) continue;
                    return true;
lbl29:
                    // 3 sources

                } while (i1 < children1.length && i2 < children2.length);
            }
            return false;
        }
        if (edit1 instanceof MultiTextEdit) {
            multiTextEdit1 = (MultiTextEdit)edit1;
            if (!multiTextEdit1.hasChildren()) {
                return false;
            }
            children = multiTextEdit1.getChildren();
            i = 0;
            while (children[i].getExclusiveEnd() < edit2.getOffset()) {
                if (++i < children.length) continue;
                return false;
            }
            return TextEditUtil.overlaps(children[i], edit2) != false;
        }
        if (edit2 instanceof MultiTextEdit) {
            multiTextEdit2 = (MultiTextEdit)edit2;
            if (!multiTextEdit2.hasChildren()) {
                return false;
            }
            children = multiTextEdit2.getChildren();
            i = 0;
            while (children[i].getExclusiveEnd() < edit1.getOffset()) {
                if (++i < children.length) continue;
                return false;
            }
            return TextEditUtil.overlaps(children[i], edit1) != false;
        }
        start1 = edit1.getOffset();
        end1 = start1 + edit1.getLength();
        start2 = edit2.getOffset();
        end2 = start2 + edit2.getLength();
        if (start1 > end2) {
            return false;
        }
        return start2 <= end1;
    }

    public static TextEdit merge(TextEdit edit1, TextEdit edit2) {
        if (edit1 instanceof MultiTextEdit && !edit1.hasChildren()) {
            return edit2;
        }
        if (edit2 instanceof MultiTextEdit && !edit2.hasChildren()) {
            return edit1;
        }
        MultiTextEdit result = new MultiTextEdit();
        TextEditUtil.merge(edit1, edit2, result);
        return result;
    }

    /*
     * Unable to fully structure code
     */
    private static void merge(TextEdit edit1, TextEdit edit2, MultiTextEdit result) {
        block18: {
            block17: {
                if (!(edit1 instanceof MultiTextEdit) || !(edit2 instanceof MultiTextEdit)) break block17;
                multiTextEdit1 = (MultiTextEdit)edit1;
                if (!multiTextEdit1.hasChildren()) {
                    result.addChild(edit2);
                    return;
                }
                multiTextEdit2 = (MultiTextEdit)edit2;
                if (!multiTextEdit2.hasChildren()) {
                    result.addChild(edit1);
                    return;
                }
                children1 = multiTextEdit1.getChildren();
                children2 = multiTextEdit2.getChildren();
                i1 = 0;
                i2 = 0;
                ** GOTO lbl37
                {
                    edit1.removeChild(0);
                    result.addChild(children1[i1]);
                    ++i1;
                    do {
                        if (i1 < children1.length && children1[i1].getExclusiveEnd() < children2[i2].getOffset()) continue block0;
                        if (i1 < children1.length) ** GOTO lbl27
                        break block0;
lbl-1000:
                        // 1 sources

                        {
                            edit2.removeChild(0);
                            result.addChild(children2[i2]);
                            ++i2;
lbl27:
                            // 2 sources

                            ** while (i2 < children2.length && children2[i2].getExclusiveEnd() < children1[i1].getOffset())
                        }
lbl28:
                        // 1 sources

                        if (i2 >= children2.length) break block0;
                        if (children1[i1].getExclusiveEnd() < children2[i2].getOffset()) continue;
                        edit1.removeChild(0);
                        edit2.removeChild(0);
                        TextEditUtil.merge(children1[i1], children2[i2], result);
                        ++i1;
                        ++i2;
lbl37:
                        // 3 sources

                    } while (i1 < children1.length && i2 < children2.length);
                }
                while (i1 < children1.length) {
                    edit1.removeChild(0);
                    result.addChild(children1[i1]);
                    ++i1;
                }
                while (i2 < children2.length) {
                    edit2.removeChild(0);
                    result.addChild(children2[i2]);
                    ++i2;
                }
                break block18;
            }
            if (edit1 instanceof MultiTextEdit) {
                children = edit1.getChildren();
                i = 0;
                while (children[i].getExclusiveEnd() < edit2.getOffset()) {
                    edit1.removeChild(0);
                    result.addChild(children[i]);
                    if (++i < children.length) continue;
                    result.addChild(edit2);
                    return;
                }
                edit1.removeChild(0);
                TextEditUtil.merge(children[i], edit2, result);
                ++i;
                while (i < children.length) {
                    edit1.removeChild(0);
                    result.addChild(children[i]);
                    ++i;
                }
            } else if (edit2 instanceof MultiTextEdit) {
                children = edit2.getChildren();
                i = 0;
                while (children[i].getExclusiveEnd() < edit1.getOffset()) {
                    edit2.removeChild(0);
                    result.addChild(children[i]);
                    if (++i < children.length) continue;
                    result.addChild(edit1);
                    return;
                }
                edit2.removeChild(0);
                TextEditUtil.merge(edit1, children[i], result);
                ++i;
                while (i < children.length) {
                    edit2.removeChild(0);
                    result.addChild(children[i]);
                    ++i;
                }
            } else if (edit1.getExclusiveEnd() < edit2.getOffset()) {
                result.addChild(edit1);
                result.addChild(edit2);
            } else {
                result.addChild(edit2);
                result.addChild(edit1);
            }
        }
    }

    private TextEditUtil() {
    }
}

