/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jsch.internal.core;

import com.jcraft.jsch.SocketFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jsch.internal.core.JSchCorePlugin;
import org.eclipse.jsch.internal.core.Messages;
import org.eclipse.jsch.internal.core.Policy;
import org.eclipse.osgi.util.NLS;

public class ResponsiveSocketFactory
implements SocketFactory {
    private static final String JAVA_NET_PROXY = "java.net.Proxy";
    private static final int DEFAULT_TIMEOUT = 60;
    InputStream in = null;
    OutputStream out = null;
    private IProgressMonitor monitor;
    private final int timeout;
    private static Class<?> proxyClass;
    private static boolean hasProxyClass;

    static {
        hasProxyClass = true;
    }

    public ResponsiveSocketFactory(IProgressMonitor monitor, int timeout) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        this.monitor = monitor;
        this.timeout = timeout;
    }

    public InputStream getInputStream(Socket socket) throws IOException {
        if (this.in == null) {
            this.in = socket.getInputStream();
        }
        return this.in;
    }

    public OutputStream getOutputStream(Socket socket) throws IOException {
        if (this.out == null) {
            this.out = socket.getOutputStream();
        }
        return this.out;
    }

    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        Socket socket = null;
        socket = this.createSocket(host, port, this.timeout / 1000, this.monitor);
        this.monitor = new NullProgressMonitor();
        socket.setSoTimeout(this.timeout);
        return socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private Socket createSocket(String host, int port, int timeout, IProgressMonitor monitor) throws UnknownHostException, IOException {
        Socket[] socket = new Socket[1];
        Exception[] exception = new Exception[1];
        Thread thread = new Thread(() -> {
            try {
                Socket newSocket = this.internalCreateSocket(host, port);
                Socket[] socketArray2 = socket;
                synchronized (socket) {
                    if (Thread.interrupted()) {
                        newSocket.close();
                    } else {
                        socketArray[0] = newSocket;
                    }
                    // ** MonitorExit[var6_8] (shouldn't be in output)
                }
            }
            catch (UnknownHostException e1) {
                exceptionArray[0] = e1;
            }
            catch (IOException e2) {
                exceptionArray[0] = e2;
            }
            {
                return;
            }
        });
        thread.start();
        if (timeout == 0) {
            timeout = 60;
        }
        int i = 0;
        while (i < timeout) {
            try {
                thread.join(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Socket[] socketArray = socket;
            // MONITORENTER : socket
            if (monitor.isCanceled()) {
                if (thread.isAlive()) {
                    thread.interrupt();
                }
                if (socket[0] != null) {
                    socket[0].close();
                }
                Policy.checkCanceled(monitor);
            }
            // MONITOREXIT : socketArray
            ++i;
        }
        Socket[] socketArray = socket;
        // MONITORENTER : socket
        if (thread.isAlive()) {
            thread.interrupt();
        }
        // MONITOREXIT : socketArray
        if (exception[0] != null) {
            if (!(exception[0] instanceof UnknownHostException)) throw (IOException)exception[0];
            throw (UnknownHostException)exception[0];
        }
        if (socket[0] != null) return socket[0];
        throw new InterruptedIOException(NLS.bind((String)Messages.Util_timeout, (Object[])new String[]{host}));
    }

    Socket internalCreateSocket(String host, int port) throws UnknownHostException, IOException {
        Class<?> proxyClass = this.getProxyClass();
        if (proxyClass != null) {
            try {
                Field field = proxyClass.getField("NO_PROXY");
                Object noProxyObject = field.get(null);
                Constructor constructor = Socket.class.getConstructor(proxyClass);
                Object o = constructor.newInstance(noProxyObject);
                if (o instanceof Socket) {
                    Socket socket = (Socket)o;
                    socket.connect(new InetSocketAddress(host, port), this.timeout * 1000);
                    return socket;
                }
            }
            catch (SecurityException e) {
                JSchCorePlugin.log(4, NLS.bind((String)"An internal error occurred while connecting to {0}", (Object)host), e);
            }
            catch (NoSuchFieldException e) {
                JSchCorePlugin.log(4, NLS.bind((String)"An internal error occurred while connecting to {0}", (Object)host), e);
            }
            catch (IllegalArgumentException e) {
                JSchCorePlugin.log(4, NLS.bind((String)"An internal error occurred while connecting to {0}", (Object)host), e);
            }
            catch (IllegalAccessException e) {
                JSchCorePlugin.log(4, NLS.bind((String)"An internal error occurred while connecting to {0}", (Object)host), e);
            }
            catch (NoSuchMethodException e) {
                JSchCorePlugin.log(4, NLS.bind((String)"An internal error occurred while connecting to {0}", (Object)host), e);
            }
            catch (InstantiationException e) {
                JSchCorePlugin.log(4, NLS.bind((String)"An internal error occurred while connecting to {0}", (Object)host), e);
            }
            catch (InvocationTargetException e) {
                JSchCorePlugin.log(4, NLS.bind((String)"An internal error occurred while connecting to {0}", (Object)host), e);
            }
        }
        return new Socket(host, port);
    }

    private synchronized Class<?> getProxyClass() {
        if (hasProxyClass && proxyClass == null) {
            try {
                proxyClass = Class.forName(JAVA_NET_PROXY);
            }
            catch (ClassNotFoundException e) {
                hasProxyClass = false;
            }
        }
        return proxyClass;
    }
}

