/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.core.refactoring;

import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringTickProvider;

public class CheckConditionsOperation
implements IWorkspaceRunnable {
    private Refactoring fRefactoring;
    private int fStyle;
    private RefactoringStatus fStatus;
    public static final int NONE = 0;
    public static final int INITIAL_CONDITONS = 2;
    public static final int FINAL_CONDITIONS = 4;
    public static final int ALL_CONDITIONS = 6;
    private static final int LAST = 8;

    public CheckConditionsOperation(Refactoring refactoring, int style) {
        Assert.isNotNull((Object)((Object)refactoring));
        this.fRefactoring = refactoring;
        this.fStyle = style;
        Assert.isTrue((boolean)this.checkStyle(this.fStyle));
    }

    public void run(IProgressMonitor pm) throws CoreException {
        if (pm == null) {
            pm = new NullProgressMonitor();
        }
        try {
            this.fStatus = null;
            if ((this.fStyle & 6) == 6) {
                this.fStatus = this.fRefactoring.checkAllConditions(pm);
            } else if ((this.fStyle & 2) == 2) {
                this.fStatus = this.fRefactoring.checkInitialConditions(pm);
            } else if ((this.fStyle & 4) == 4) {
                this.fStatus = this.fRefactoring.checkFinalConditions(pm);
            }
        }
        finally {
            pm.done();
        }
    }

    public RefactoringStatus getStatus() {
        return this.fStatus;
    }

    public Refactoring getRefactoring() {
        return this.fRefactoring;
    }

    public int getStyle() {
        return this.fStyle;
    }

    private boolean checkStyle(int style) {
        return style > 0 && style < 8;
    }

    int getTicks(RefactoringTickProvider provider) {
        if ((this.fStyle & 6) == 6) {
            return provider.getCheckAllConditionsTicks();
        }
        if ((this.fStyle & 2) == 2) {
            return provider.getCheckInitialConditionsTicks();
        }
        if ((this.fStyle & 4) == 4) {
            return provider.getCheckFinalConditionsTicks();
        }
        return 0;
    }
}

