/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.push;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egit.core.op.PushOperationResult;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.gerrit.GerritDialogSettings;
import org.eclipse.egit.ui.internal.push.PushOperationUI;
import org.eclipse.egit.ui.internal.push.PushResultDialog;
import org.eclipse.egit.ui.internal.push.RefSpecDialog;
import org.eclipse.egit.ui.internal.push.RefSpecWizard;
import org.eclipse.egit.ui.internal.repository.SelectUriWizard;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;

public class SimpleConfigurePushDialog
extends TitleAreaDialog {
    private static final int DRY_RUN = 98;
    private static final int SAVE_ONLY = 97;
    private static final int REVERT = 96;
    private static final String ADVANCED_MODE_PREFERENCE = String.valueOf(SimpleConfigurePushDialog.class.getName()) + "_ADVANCED_MODE";
    private final Repository repository;
    private RemoteConfig config;
    private final boolean showBranchInfo;
    private Text commonUriText;
    private TableViewer uriViewer;
    private TableViewer specViewer;
    private Button changeCommonUri;
    private Button deleteCommonUri;
    private Button addRefSpec;
    private Button changeRefSpec;
    private Button addRefSpecAdvanced;

    public static Dialog getDialog(Shell shell, Repository repository) {
        RemoteConfig configToUse = SimpleConfigurePushDialog.getConfiguredRemote(repository);
        return new SimpleConfigurePushDialog(shell, repository, configToUse, true);
    }

    public static Dialog getDialog(Shell shell, Repository repository, String remoteName) {
        RemoteConfig configToUse;
        try {
            configToUse = new RemoteConfig((Config)repository.getConfig(), remoteName);
        }
        catch (URISyntaxException e) {
            Activator.handleError(e.getMessage(), e, true);
            return null;
        }
        return new SimpleConfigurePushDialog(shell, repository, configToUse, false);
    }

    public static RemoteConfig getConfiguredRemote(Repository repository) {
        ArrayList allRemotes;
        String branch;
        try {
            branch = repository.getBranch();
        }
        catch (IOException e) {
            Activator.handleError(e.getMessage(), e, true);
            return null;
        }
        if (branch == null) {
            return null;
        }
        String remoteName = null;
        if (!ObjectId.isId((String)branch)) {
            remoteName = repository.getConfig().getString("branch", branch, "remote");
        }
        try {
            allRemotes = RemoteConfig.getAllRemoteConfigs((Config)repository.getConfig());
        }
        catch (URISyntaxException e) {
            allRemotes = new ArrayList();
        }
        RemoteConfig configuredConfig = null;
        RemoteConfig defaultConfig = null;
        for (RemoteConfig config : allRemotes) {
            if (remoteName != null && config.getName().equals(remoteName)) {
                configuredConfig = config;
            }
            if (!config.getName().equals("origin")) continue;
            defaultConfig = config;
        }
        if (configuredConfig != null) {
            return configuredConfig;
        }
        if (defaultConfig != null && !defaultConfig.getPushRefSpecs().isEmpty()) {
            return defaultConfig;
        }
        return null;
    }

    private SimpleConfigurePushDialog(Shell shell, Repository repository, RemoteConfig config, boolean showBranchInfo) {
        super(shell);
        this.setHelpAvailable(false);
        this.setShellStyle(this.getShellStyle() | 0x4F0);
        this.repository = repository;
        this.config = config;
        this.showBranchInfo = showBranchInfo;
    }

    protected Control createDialogArea(Composite parent) {
        boolean advancedMode = Activator.getDefault().getPreferenceStore().getBoolean(ADVANCED_MODE_PREFERENCE);
        final Composite main = new Composite(parent, 0);
        main.setLayout((Layout)new GridLayout(1, false));
        GridDataFactory.fillDefaults().grab(true, true).minSize(-1, -1).applyTo((Control)main);
        if (this.showBranchInfo) {
            String branch;
            Composite branchArea = new Composite(main, 0);
            GridLayoutFactory.swtDefaults().numColumns(2).equalWidth(false).applyTo(branchArea);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)branchArea);
            Label branchLabel = new Label(branchArea, 0);
            branchLabel.setText(UIText.SimpleConfigurePushDialog_BranchLabel);
            try {
                branch = this.repository.getBranch();
            }
            catch (IOException e2) {
                branch = null;
            }
            if (branch == null || ObjectId.isId((String)branch)) {
                branch = UIText.SimpleConfigurePushDialog_DetachedHeadMessage;
            }
            Text branchText = new Text(branchArea, 2056);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)branchText);
            branchText.setText(branch);
        }
        this.addDefaultOriginWarningIfNeeded(main);
        Composite sameUriDetails = new Composite(main, 0);
        sameUriDetails.setLayout((Layout)new GridLayout(4, false));
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)sameUriDetails);
        Label commonUriLabel = new Label(sameUriDetails, 0);
        commonUriLabel.setText(UIText.SimpleConfigurePushDialog_URILabel);
        this.commonUriText = new Text(sameUriDetails, 2056);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.commonUriText);
        this.changeCommonUri = new Button(sameUriDetails, 8);
        this.changeCommonUri.setText(UIText.SimpleConfigurePushDialog_ChangeUriButton);
        this.changeCommonUri.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectUriWizard wiz = SimpleConfigurePushDialog.this.commonUriText.getText().length() > 0 ? new SelectUriWizard(false, SimpleConfigurePushDialog.this.commonUriText.getText()) : new SelectUriWizard(false);
                if (new WizardDialog(SimpleConfigurePushDialog.this.getShell(), (IWizard)wiz).open() == 0) {
                    if (SimpleConfigurePushDialog.this.commonUriText.getText().length() > 0) {
                        try {
                            SimpleConfigurePushDialog.this.config.removeURI(new URIish(SimpleConfigurePushDialog.this.commonUriText.getText()));
                        }
                        catch (URISyntaxException ex) {
                            Activator.handleError(ex.getMessage(), ex, true);
                        }
                    }
                    SimpleConfigurePushDialog.this.config.addURI(wiz.getUri());
                    SimpleConfigurePushDialog.this.updateControls();
                }
            }
        });
        this.deleteCommonUri = new Button(sameUriDetails, 8);
        this.deleteCommonUri.setText(UIText.SimpleConfigurePushDialog_DeleteUriButton);
        this.deleteCommonUri.setEnabled(false);
        this.deleteCommonUri.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SimpleConfigurePushDialog.this.config.removeURI((URIish)SimpleConfigurePushDialog.this.config.getURIs().get(0));
                SimpleConfigurePushDialog.this.updateControls();
            }
        });
        this.commonUriText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SimpleConfigurePushDialog.this.deleteCommonUri.setEnabled(SimpleConfigurePushDialog.this.commonUriText.getText().length() > 0);
            }
        });
        ExpandableComposite pushUriArea = new ExpandableComposite(main, 20);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)pushUriArea);
        pushUriArea.setExpanded(!this.config.getPushURIs().isEmpty());
        pushUriArea.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                main.layout(true, true);
                main.getShell().pack();
            }
        });
        pushUriArea.setText(UIText.SimpleConfigurePushDialog_PushUrisLabel);
        Composite pushUriDetails = new Composite((Composite)pushUriArea, 0);
        pushUriArea.setClient((Control)pushUriDetails);
        pushUriDetails.setLayout((Layout)new GridLayout(2, false));
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)pushUriDetails);
        this.uriViewer = new TableViewer(pushUriDetails, 2050);
        GridDataFactory.fillDefaults().grab(true, true).minSize(-1, 30).applyTo((Control)this.uriViewer.getTable());
        this.uriViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        Composite uriButtonArea = new Composite(pushUriDetails, 0);
        GridLayoutFactory.fillDefaults().applyTo(uriButtonArea);
        GridDataFactory.fillDefaults().grab(false, true).applyTo((Control)uriButtonArea);
        Button addUri = new Button(uriButtonArea, 8);
        addUri.setText(UIText.SimpleConfigurePushDialog_AddPushUriButton);
        GridDataFactory.fillDefaults().applyTo((Control)addUri);
        addUri.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectUriWizard wiz = new SelectUriWizard(false);
                if (new WizardDialog(SimpleConfigurePushDialog.this.getShell(), (IWizard)wiz).open() == 0) {
                    SimpleConfigurePushDialog.this.config.addPushURI(wiz.getUri());
                    SimpleConfigurePushDialog.this.updateControls();
                }
            }
        });
        final Button changeUri = new Button(uriButtonArea, 8);
        changeUri.setText(UIText.SimpleConfigurePushDialog_ChangePushUriButton);
        GridDataFactory.fillDefaults().applyTo((Control)changeUri);
        changeUri.setEnabled(false);
        changeUri.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                URIish uri = (URIish)((IStructuredSelection)SimpleConfigurePushDialog.this.uriViewer.getSelection()).getFirstElement();
                SelectUriWizard wiz = new SelectUriWizard(false, uri.toPrivateString());
                if (new WizardDialog(SimpleConfigurePushDialog.this.getShell(), (IWizard)wiz).open() == 0) {
                    SimpleConfigurePushDialog.this.config.removePushURI(uri);
                    SimpleConfigurePushDialog.this.config.addPushURI(wiz.getUri());
                    SimpleConfigurePushDialog.this.updateControls();
                }
            }
        });
        final Button deleteUri = new Button(uriButtonArea, 8);
        deleteUri.setText(UIText.SimpleConfigurePushDialog_DeletePushUriButton);
        GridDataFactory.fillDefaults().applyTo((Control)deleteUri);
        deleteUri.setEnabled(false);
        deleteUri.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                URIish uri = (URIish)((IStructuredSelection)SimpleConfigurePushDialog.this.uriViewer.getSelection()).getFirstElement();
                SimpleConfigurePushDialog.this.config.removePushURI(uri);
                SimpleConfigurePushDialog.this.updateControls();
            }
        });
        this.uriViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                deleteUri.setEnabled(!SimpleConfigurePushDialog.this.uriViewer.getSelection().isEmpty());
                changeUri.setEnabled(((IStructuredSelection)SimpleConfigurePushDialog.this.uriViewer.getSelection()).size() == 1);
            }
        });
        Group refSpecGroup = new Group(main, 16);
        GridDataFactory.fillDefaults().grab(true, true).minSize(-1, -1).applyTo((Control)refSpecGroup);
        refSpecGroup.setText(UIText.SimpleConfigurePushDialog_RefMappingGroup);
        refSpecGroup.setLayout((Layout)new GridLayout(2, false));
        this.specViewer = new TableViewer((Composite)refSpecGroup, 2050);
        this.specViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        GridDataFactory.fillDefaults().grab(true, true).minSize(-1, 30).applyTo((Control)this.specViewer.getTable());
        this.specViewer.getTable().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.stateMask == SWT.MOD1 && e.keyCode == 118) {
                    SimpleConfigurePushDialog.this.doPaste();
                }
            }
        });
        Composite refButtonArea = new Composite((Composite)refSpecGroup, 0);
        GridLayoutFactory.fillDefaults().applyTo(refButtonArea);
        GridDataFactory.fillDefaults().grab(false, true).minSize(-1, -1).applyTo((Control)refButtonArea);
        this.addRefSpec = new Button(refButtonArea, 8);
        this.addRefSpec.setText(UIText.SimpleConfigurePushDialog_AddRefSpecButton);
        GridDataFactory.fillDefaults().applyTo((Control)this.addRefSpec);
        this.addRefSpec.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RefSpecDialog dlg = new RefSpecDialog(SimpleConfigurePushDialog.this.getShell(), SimpleConfigurePushDialog.this.repository, SimpleConfigurePushDialog.this.config, true);
                if (dlg.open() == 0) {
                    SimpleConfigurePushDialog.this.config.addPushRefSpec(dlg.getSpec());
                }
                SimpleConfigurePushDialog.this.updateControls();
            }
        });
        this.changeRefSpec = new Button(refButtonArea, 8);
        this.changeRefSpec.setText(UIText.SimpleConfigurePushDialog_ChangeRefSpecButton);
        GridDataFactory.fillDefaults().applyTo((Control)this.changeRefSpec);
        this.changeRefSpec.setEnabled(false);
        GridDataFactory.fillDefaults().exclude(!advancedMode).applyTo((Control)this.changeRefSpec);
        this.changeRefSpec.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RefSpec oldSpec = (RefSpec)((IStructuredSelection)SimpleConfigurePushDialog.this.specViewer.getSelection()).getFirstElement();
                RefSpecDialog dlg = new RefSpecDialog(SimpleConfigurePushDialog.this.getShell(), SimpleConfigurePushDialog.this.repository, SimpleConfigurePushDialog.this.config, oldSpec, true);
                if (dlg.open() == 0) {
                    SimpleConfigurePushDialog.this.config.removePushRefSpec(oldSpec);
                    SimpleConfigurePushDialog.this.config.addPushRefSpec(dlg.getSpec());
                }
                SimpleConfigurePushDialog.this.updateControls();
            }
        });
        final Button deleteRefSpec = new Button(refButtonArea, 8);
        deleteRefSpec.setText(UIText.SimpleConfigurePushDialog_DeleteRefSpecButton);
        GridDataFactory.fillDefaults().applyTo((Control)deleteRefSpec);
        deleteRefSpec.setEnabled(false);
        deleteRefSpec.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object[] objectArray = ((IStructuredSelection)SimpleConfigurePushDialog.this.specViewer.getSelection()).toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object spec = objectArray[n2];
                    SimpleConfigurePushDialog.this.config.removePushRefSpec((RefSpec)spec);
                    ++n2;
                }
                SimpleConfigurePushDialog.this.updateControls();
            }
        });
        final Button copySpec = new Button(refButtonArea, 8);
        copySpec.setText(UIText.SimpleConfigurePushDialog_CopyRefSpecButton);
        GridDataFactory.fillDefaults().applyTo((Control)copySpec);
        copySpec.setEnabled(false);
        copySpec.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String toCopy = ((IStructuredSelection)SimpleConfigurePushDialog.this.specViewer.getSelection()).getFirstElement().toString();
                Clipboard clipboard = new Clipboard(SimpleConfigurePushDialog.this.getShell().getDisplay());
                try {
                    clipboard.setContents((Object[])new String[]{toCopy}, (Transfer[])new TextTransfer[]{TextTransfer.getInstance()});
                }
                finally {
                    clipboard.dispose();
                }
            }
        });
        Button pasteSpec = new Button(refButtonArea, 8);
        pasteSpec.setText(UIText.SimpleConfigurePushDialog_PasteRefSpecButton);
        GridDataFactory.fillDefaults().applyTo((Control)pasteSpec);
        pasteSpec.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SimpleConfigurePushDialog.this.doPaste();
            }
        });
        this.addRefSpecAdvanced = new Button(refButtonArea, 8);
        this.addRefSpecAdvanced.setText(UIText.SimpleConfigurePushDialog_EditAdvancedButton);
        GridDataFactory.fillDefaults().applyTo((Control)this.addRefSpecAdvanced);
        this.addRefSpecAdvanced.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (new WizardDialog(SimpleConfigurePushDialog.this.getShell(), (IWizard)new RefSpecWizard(SimpleConfigurePushDialog.this.repository, SimpleConfigurePushDialog.this.config, true)).open() == 0) {
                    SimpleConfigurePushDialog.this.updateControls();
                }
            }
        });
        this.specViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel = (IStructuredSelection)SimpleConfigurePushDialog.this.specViewer.getSelection();
                copySpec.setEnabled(sel.size() == 1);
                SimpleConfigurePushDialog.this.changeRefSpec.setEnabled(sel.size() == 1);
                deleteRefSpec.setEnabled(!sel.isEmpty());
            }
        });
        SimpleConfigurePushDialog.applyDialogFont((Control)main);
        return main;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, UIText.SimpleConfigurePushDialog_SaveAndPushButton, true);
        this.createButton(parent, 97, UIText.SimpleConfigurePushDialog_SaveButton, false);
        this.createButton(parent, 98, UIText.SimpleConfigurePushDialog_DryRunButton, false);
        this.createButton(parent, 96, UIText.SimpleConfigurePushDialog_RevertButton, false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    public void create() {
        super.create();
        this.setTitle(NLS.bind((String)UIText.SimpleConfigurePushDialog_DialogTitle, (Object)this.config.getName()));
        this.setMessage(UIText.SimpleConfigurePushDialog_DialogMessage);
        this.updateControls();
    }

    private void updateControls() {
        boolean anyFetchUri = !this.config.getURIs().isEmpty();
        boolean anyPushUri = !this.config.getPushURIs().isEmpty();
        boolean anyUri = anyFetchUri || anyPushUri;
        this.setErrorMessage(null);
        if (!anyUri) {
            this.setErrorMessage(UIText.SimpleConfigurePushDialog_MissingUriMessage);
        }
        if (anyFetchUri) {
            this.commonUriText.setText(((URIish)this.config.getURIs().get(0)).toPrivateString());
        } else {
            this.commonUriText.setText("");
        }
        this.uriViewer.getTable().setEnabled(anyPushUri);
        if (anyPushUri) {
            this.uriViewer.setInput((Object)this.config.getPushURIs());
        } else if (anyFetchUri) {
            this.uriViewer.setInput((Object)new String[]{NLS.bind((String)UIText.SimpleConfigurePushDialog_UseUriForPushUriMessage, (Object)this.commonUriText.getText())});
        } else {
            this.uriViewer.setInput(null);
        }
        if (this.config.getPushRefSpecs().isEmpty()) {
            this.specViewer.setInput((Object)new String[]{UIText.SimpleConfigurePushDialog_DefaultPushNoRefspec});
        } else {
            this.specViewer.setInput((Object)this.config.getPushRefSpecs());
        }
        this.specViewer.getTable().setEnabled(!this.config.getPushRefSpecs().isEmpty());
        this.addRefSpec.setEnabled(anyUri);
        this.addRefSpecAdvanced.setEnabled(anyUri);
        this.changeCommonUri.setEnabled(!anyPushUri);
        this.deleteCommonUri.setEnabled(!anyPushUri && anyUri);
        this.commonUriText.setEnabled(!anyPushUri);
        this.getButton(0).setEnabled(anyUri);
        this.getButton(98).setEnabled(anyUri);
        this.getButton(97).setEnabled(anyUri);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(UIText.SimpleConfigurePushDialog_WindowTitle);
    }

    public void buttonPressed(int buttonId) {
        if (buttonId == 98) {
            try {
                new ProgressMonitorDialog(this.getShell()).run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        final PushOperationUI op = new PushOperationUI(SimpleConfigurePushDialog.this.repository, SimpleConfigurePushDialog.this.config, true);
                        try {
                            final PushOperationResult result = op.execute(monitor);
                            SimpleConfigurePushDialog.this.getShell().getDisplay().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    PushResultDialog dlg = new PushResultDialog(SimpleConfigurePushDialog.this.getShell(), SimpleConfigurePushDialog.this.repository, result, op.getDestinationString(), true);
                                    dlg.showConfigureButton(false);
                                    dlg.open();
                                }
                            });
                        }
                        catch (CoreException e) {
                            Activator.handleError(e.getMessage(), e, true);
                        }
                    }
                });
            }
            catch (InvocationTargetException e1) {
                Activator.handleError(e1.getMessage(), e1, true);
            }
            catch (InterruptedException e1) {
                // empty catch block
            }
            return;
        }
        if (buttonId == 96) {
            try {
                this.config = new RemoteConfig((Config)this.repository.getConfig(), this.config.getName());
                this.updateControls();
            }
            catch (URISyntaxException e) {
                Activator.handleError(e.getMessage(), e, true);
            }
            return;
        }
        if (buttonId == 0 || buttonId == 97) {
            this.config.update((Config)this.repository.getConfig());
            try {
                this.repository.getConfig().save();
            }
            catch (IOException e) {
                Activator.handleError(e.getMessage(), e, true);
            }
            GerritDialogSettings.updateRemoteConfig(this.repository, this.config);
            if (buttonId == 0) {
                try {
                    new ProgressMonitorDialog(this.getShell()).run(true, true, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            PushOperationUI op = new PushOperationUI(SimpleConfigurePushDialog.this.repository, SimpleConfigurePushDialog.this.config.getName(), false);
                            op.start();
                        }
                    });
                }
                catch (InvocationTargetException e) {
                    Activator.handleError(e.getMessage(), e, true);
                }
                catch (InterruptedException e) {
                    Activator.handleError(e.getMessage(), e, true);
                }
            }
            this.okPressed();
            return;
        }
        super.buttonPressed(buttonId);
    }

    private void doPaste() {
        Clipboard clipboard = new Clipboard(this.getShell().getDisplay());
        try {
            String content = (String)clipboard.getContents((Transfer)TextTransfer.getInstance());
            if (content == null) {
                MessageDialog.openConfirm((Shell)this.getShell(), (String)UIText.SimpleConfigurePushDialog_EmptyClipboardDialogTitle, (String)UIText.SimpleConfigurePushDialog_EmptyClipboardDialogMessage);
            }
            try {
                Ref source;
                RefSpec spec = new RefSpec(content);
                try {
                    source = this.repository.findRef(spec.getSource());
                }
                catch (IOException e1) {
                    source = null;
                }
                if (source != null || MessageDialog.openQuestion((Shell)this.getShell(), (String)UIText.SimpleConfigurePushDialog_InvalidRefDialogTitle, (String)NLS.bind((String)UIText.SimpleConfigurePushDialog_InvalidRefDialogMessage, (Object)spec.toString()))) {
                    this.config.addPushRefSpec(spec);
                }
                this.updateControls();
            }
            catch (IllegalArgumentException ex) {
                MessageDialog.openError((Shell)this.getShell(), (String)UIText.SimpleConfigurePushDialog_NoRefSpecDialogTitle, (String)UIText.SimpleConfigurePushDialog_NoRefSpecDialogMessage);
            }
        }
        finally {
            clipboard.dispose();
        }
    }

    private void addDefaultOriginWarningIfNeeded(Composite parent) {
        String currentBranch;
        if (!this.showBranchInfo) {
            return;
        }
        ArrayList<String> otherBranches = new ArrayList<String>();
        try {
            currentBranch = this.repository.getBranch();
        }
        catch (IOException e) {
            return;
        }
        String currentRemote = this.config.getName();
        StoredConfig repositoryConfig = this.repository.getConfig();
        Set branches = repositoryConfig.getSubsections("branch");
        for (String branch : branches) {
            String remote;
            if (branch.equals(currentBranch) || ((remote = repositoryConfig.getString("branch", branch, "remote")) != null || !currentRemote.equals("origin")) && (remote == null || !remote.equals(currentRemote))) continue;
            otherBranches.add(branch);
        }
        if (otherBranches.isEmpty()) {
            return;
        }
        Composite warningAboutOrigin = new Composite(parent, 0);
        warningAboutOrigin.setLayout((Layout)new GridLayout(2, false));
        Label warningLabel = new Label(warningAboutOrigin, 0);
        warningLabel.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK"));
        Text warningText = new Text(warningAboutOrigin, 8);
        warningText.setText(NLS.bind((String)UIText.SimpleConfigurePushDialog_ReusedOriginWarning, (Object)this.config.getName(), (Object)otherBranches.size()));
        warningText.setToolTipText(((Object)otherBranches).toString());
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)warningLabel);
    }
}

