/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.mail;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import java.util.function.BiConsumer;
import javax.activation.CommandMap;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.MailcapCommandMap;
import javax.activation.URLDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.eclipse.passage.lic.email.EmailDescriptor;
import org.eclipse.passage.lic.email.Mailing;
import org.eclipse.passage.lic.internal.mail.EmailDescriptorImpl;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;

@Component
public class MailImpl
implements Mailing {
    @Activate
    public void activate() {
        MailcapCommandMap mc = (MailcapCommandMap)CommandMap.getDefaultCommandMap();
        mc.addMailcap("text/plain;;\t\tx-java-content-handler=org.apache.geronimo.mail.handlers.TextHandler");
        mc.addMailcap("text/xml;;\t\tx-java-content-handler=org.apache.geronimo.mail.handlers.XMLHandler");
        mc.addMailcap("text/html;;\t\tx-java-content-handler=org.apache.geronimo.mail.handlers.HtmlHandler");
        mc.addMailcap("message/rfc822;;\tx-java-content-handler=org.apache.geronimo.mail.handlers.MessageHandler");
        mc.addMailcap("multipart/*;;\t\tx-java-content-handler=org.apache.geronimo.mail.handlers.MultipartHandler; x-java-fallback-entry=true");
    }

    public void writeEml(EmailDescriptor descriptor, OutputStream output, BiConsumer<String, Throwable> consumerStatus) {
        try {
            Message message = this.createMessage(descriptor);
            this.fulfillMessage(descriptor, message);
            message.writeTo(output);
        }
        catch (IOException | MessagingException e) {
            consumerStatus.accept(e.getMessage(), e);
        }
    }

    private Message createMessage(EmailDescriptor descriptor) throws MessagingException, AddressException {
        MimeMessage message = new MimeMessage(Session.getInstance((Properties)System.getProperties()));
        message.setFrom((Address)new InternetAddress(descriptor.getFrom()));
        message.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)descriptor.getTo()));
        message.setSubject(descriptor.getSubject());
        return message;
    }

    private void fulfillMessage(EmailDescriptor descriptor, Message message) throws MessagingException, IOException {
        Multipart multipart = this.createBody(descriptor.getBody());
        this.attachFiles(descriptor, multipart);
        message.setContent(multipart);
    }

    private Multipart createBody(String body) throws MessagingException {
        MimeMultipart multipart = new MimeMultipart("mixed");
        MimeBodyPart content = new MimeBodyPart();
        multipart.addBodyPart((BodyPart)content);
        content.setText(body, "UTF-8");
        return multipart;
    }

    private void attachFiles(EmailDescriptor descriptor, Multipart multipart) throws MessagingException, IOException {
        Iterable attachmentPaths = descriptor.getAttachmentPaths();
        for (String path : attachmentPaths) {
            File attache = new File(path);
            MimeBodyPart attachment = new MimeBodyPart();
            URLDataSource fds = new URLDataSource(attache.toURI().toURL());
            attachment.setDataHandler(new DataHandler((DataSource)fds));
            attachment.addHeader("Content-Transfer-Encoding", "base64");
            attachment.setDisposition("attachment");
            attachment.setFileName(attache.getName());
            multipart.addBodyPart((BodyPart)attachment);
        }
    }

    public EmailDescriptor createMail(String to, String from, String subject, String body, Iterable<String> attachments) {
        return new EmailDescriptorImpl(to, from, subject, body, attachments);
    }
}

