/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.internal.products.core;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.passage.lic.products.ProductDescriptor;
import org.eclipse.passage.lic.products.ProductLineDescriptor;
import org.eclipse.passage.lic.products.ProductVersionDescriptor;
import org.eclipse.passage.lic.products.ProductVersionFeatureDescriptor;
import org.eclipse.passage.lic.products.model.api.Product;
import org.eclipse.passage.lic.products.model.api.ProductLine;
import org.eclipse.passage.lic.products.model.api.ProductVersion;
import org.eclipse.passage.lic.products.model.api.ProductVersionFeature;
import org.eclipse.passage.loc.internal.emf.DomainContentAdapter;
import org.eclipse.passage.loc.internal.emf.EditingDomainRegistry;
import org.eclipse.passage.loc.internal.products.core.ProductDomainRegistry;

public class ProductsDomainRegistryTracker
extends DomainContentAdapter<ProductLineDescriptor, ProductDomainRegistry> {
    public ProductsDomainRegistryTracker(ProductDomainRegistry registry) {
        super((EditingDomainRegistry)registry);
    }

    public void notifyChanged(Notification notification) {
        Object notifier = notification.getNotifier();
        if (notifier instanceof ProductLine) {
            ProductLine productLine = (ProductLine)notifier;
            switch (notification.getFeatureID(ProductLine.class)) {
                case 0: {
                    this.processProductLineIdentifier(productLine, notification);
                    break;
                }
                case 3: {
                    this.processProductLineProducts(productLine, notification);
                    break;
                }
            }
        } else if (notifier instanceof Product) {
            Product product = (Product)notifier;
            switch (notification.getFeatureID(Product.class)) {
                case 0: {
                    this.processProductIdentifier(product, notification);
                    break;
                }
                case 4: {
                    this.processProductProductVersions(product, notification);
                    break;
                }
            }
        } else if (notifier instanceof ProductVersion) {
            ProductVersion productVersion = (ProductVersion)notifier;
            switch (notification.getFeatureID(ProductVersion.class)) {
                case 0: {
                    this.processProductVersionVersion(productVersion, notification);
                    break;
                }
                case 6: {
                    this.processProductVersionProductVersionFeatures(productVersion, notification);
                    break;
                }
            }
        } else if (notifier instanceof ProductVersionFeature) {
            ProductVersionFeature productVersionFeature = (ProductVersionFeature)notifier;
            switch (notification.getFeatureID(ProductVersionFeature.class)) {
                case 0: {
                    this.processProductVersionFeatureFeatureIdentifier(productVersionFeature, notification);
                    break;
                }
            }
        }
        super.notifyChanged(notification);
    }

    protected void processProductLineIdentifier(ProductLine productLine, Notification notification) {
        String oldValue = notification.getOldStringValue();
        String newValue = notification.getNewStringValue();
        switch (notification.getEventType()) {
            case 1: {
                if (oldValue != null) {
                    ((ProductDomainRegistry)this.registry).unregisterProductLine(oldValue);
                }
                if (newValue == null) break;
                ((ProductDomainRegistry)this.registry).registerProductLine((ProductLineDescriptor)productLine);
                break;
            }
        }
    }

    protected void processProductLineProducts(ProductLine productLine, Notification notification) {
        Object oldValue = notification.getOldValue();
        Object newValue = notification.getNewValue();
        switch (notification.getEventType()) {
            case 3: {
                Product product;
                String identifier;
                if (!(newValue instanceof Product) || (identifier = (product = (Product)newValue).getIdentifier()) == null) break;
                ((ProductDomainRegistry)this.registry).registerProduct((ProductDescriptor)product);
                break;
            }
            case 4: {
                Product product;
                String identifier;
                if (!(oldValue instanceof Product) || (identifier = (product = (Product)oldValue).getIdentifier()) == null) break;
                ((ProductDomainRegistry)this.registry).unregisterProduct(identifier);
                break;
            }
        }
    }

    protected void processProductIdentifier(Product product, Notification notification) {
        String oldValue = notification.getOldStringValue();
        String newValue = notification.getNewStringValue();
        switch (notification.getEventType()) {
            case 1: {
                if (oldValue != null) {
                    ((ProductDomainRegistry)this.registry).unregisterProduct(oldValue);
                }
                if (newValue == null) break;
                ((ProductDomainRegistry)this.registry).registerProduct((ProductDescriptor)product);
                break;
            }
        }
    }

    protected void processProductProductVersions(Product product, Notification notification) {
        Object oldValue = notification.getOldValue();
        Object newValue = notification.getNewValue();
        switch (notification.getEventType()) {
            case 3: {
                ProductVersion productVersion;
                String version;
                if (!(newValue instanceof ProductVersion) || (version = (productVersion = (ProductVersion)newValue).getVersion()) == null) break;
                ((ProductDomainRegistry)this.registry).registerProductVersion((ProductDescriptor)product, (ProductVersionDescriptor)productVersion);
                break;
            }
            case 4: {
                ProductVersion productVersion;
                String version;
                if (!(oldValue instanceof ProductVersion) || (version = (productVersion = (ProductVersion)oldValue).getVersion()) == null) break;
                ((ProductDomainRegistry)this.registry).unregisterProductVersion(product.getIdentifier(), version);
                break;
            }
        }
    }

    protected void processProductVersionVersion(ProductVersion productVersion, Notification notification) {
        Product product = productVersion.getProduct();
        if (product == null) {
            return;
        }
        String oldValue = notification.getOldStringValue();
        String newValue = notification.getNewStringValue();
        switch (notification.getEventType()) {
            case 1: {
                if (oldValue != null) {
                    ((ProductDomainRegistry)this.registry).unregisterProductVersion(product.getIdentifier(), oldValue);
                }
                if (newValue == null) break;
                ((ProductDomainRegistry)this.registry).registerProductVersion((ProductDescriptor)product, (ProductVersionDescriptor)productVersion);
                break;
            }
        }
    }

    protected void processProductVersionProductVersionFeatures(ProductVersion productVersion, Notification notification) {
        Product product = productVersion.getProduct();
        if (product == null) {
            return;
        }
        Object oldValue = notification.getOldValue();
        Object newValue = notification.getNewValue();
        switch (notification.getEventType()) {
            case 3: {
                ProductVersionFeature productVersionFeature;
                String featureId;
                if (!(newValue instanceof ProductVersionFeature) || (featureId = (productVersionFeature = (ProductVersionFeature)newValue).getFeatureIdentifier()) == null) break;
                ((ProductDomainRegistry)this.registry).registerProductVersionFeature((ProductDescriptor)product, (ProductVersionDescriptor)productVersion, (ProductVersionFeatureDescriptor)productVersionFeature);
                break;
            }
            case 4: {
                ProductVersionFeature productVersionFeature;
                String featureId;
                if (!(oldValue instanceof ProductVersionFeature) || (featureId = (productVersionFeature = (ProductVersionFeature)oldValue).getFeatureIdentifier()) == null) break;
                ((ProductDomainRegistry)this.registry).unregisterProductVersionFeature(product.getIdentifier(), productVersion.getVersion(), featureId);
                break;
            }
        }
    }

    protected void processProductVersionFeatureFeatureIdentifier(ProductVersionFeature productVersionFeature, Notification notification) {
        ProductVersion productVersion = productVersionFeature.getProductVersion();
        if (productVersion == null) {
            return;
        }
        Product product = productVersion.getProduct();
        if (product == null) {
            return;
        }
        String oldValue = notification.getOldStringValue();
        String newValue = notification.getNewStringValue();
        switch (notification.getEventType()) {
            case 1: {
                if (oldValue != null) {
                    String productId = product.getIdentifier();
                    String version = productVersion.getVersion();
                    ((ProductDomainRegistry)this.registry).unregisterProductVersionFeature(productId, version, oldValue);
                }
                if (newValue == null) break;
                ((ProductDomainRegistry)this.registry).registerProductVersionFeature((ProductDescriptor)product, (ProductVersionDescriptor)productVersion, (ProductVersionFeatureDescriptor)productVersionFeature);
                break;
            }
        }
    }
}

