/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.internal.products.core;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.service.environment.EnvironmentInfo;
import org.eclipse.passage.lic.products.ProductVersionDescriptor;
import org.eclipse.passage.loc.internal.api.OperatorProductEvents;
import org.eclipse.passage.loc.internal.api.OperatorProductService;
import org.eclipse.passage.loc.internal.products.core.ProductVersionKeys;
import org.eclipse.passage.loc.internal.products.core.ProductVersionPassword;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.event.EventAdmin;

@Component
public class ProductOperatorServiceImpl
implements OperatorProductService {
    private String plugin;
    private EnvironmentInfo environment;
    private EventAdmin events;

    @Activate
    public void activate(BundleContext context) {
        this.plugin = context.getBundle().getSymbolicName();
    }

    @Reference
    public void bindEnvironmentInfo(EnvironmentInfo info) {
        this.environment = info;
    }

    public void unbindEnvironmentInfo(EnvironmentInfo info) {
        if (this.environment == info) {
            this.environment = null;
        }
    }

    @Reference
    public void bindEventAdmin(EventAdmin admin) {
        this.events = admin;
    }

    public void unbindEventAdmin(EventAdmin admin) {
        if (this.events == admin) {
            this.events = null;
        }
    }

    public String createPassword(ProductVersionDescriptor descriptor) {
        return new ProductVersionPassword(descriptor).get();
    }

    public IStatus createProductKeys(ProductVersionDescriptor target) {
        return new ProductVersionKeys(this.plugin, this::broadcast).createKeys(target);
    }

    private void broadcast(String info) {
        this.events.postEvent(OperatorProductEvents.keysCreated((String)info));
    }
}

