/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.internal.products.core;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Optional;
import java.util.function.Function;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.passage.lic.api.LicensedProduct;
import org.eclipse.passage.lic.api.LicensingException;
import org.eclipse.passage.lic.base.BaseLicensedProduct;
import org.eclipse.passage.lic.internal.emf.EObjectFromBytes;
import org.eclipse.passage.lic.keys.model.api.KeyPair;
import org.eclipse.passage.loc.internal.api.workspace.Keys;
import org.eclipse.passage.loc.internal.api.workspace.ResourceHandle;
import org.eclipse.passage.loc.internal.equinox.OperatorGearAware;
import org.eclipse.passage.loc.internal.products.core.i18n.IssuingMessages;

public final class ProductKeys {
    private final LicensedProduct product;

    public ProductKeys(LicensedProduct product) {
        this.product = product;
    }

    public ProductKeys(String product, String version) {
        this((LicensedProduct)new BaseLicensedProduct(product, version));
    }

    public InputStream scrStream() throws LicensingException {
        return this.getStream(KeyPair::getScr);
    }

    public InputStream pubStream() throws LicensingException {
        return this.getStream(KeyPair::getPub);
    }

    public byte[] scrBytes() throws LicensingException {
        return this.getBytes(KeyPair::getScr);
    }

    public byte[] pubBytes() throws LicensingException {
        return this.getBytes(KeyPair::getPub);
    }

    private InputStream getStream(Function<KeyPair, String> get) throws LicensingException {
        return new ByteArrayInputStream(this.getBytes(get));
    }

    private byte[] getBytes(Function<KeyPair, String> get) throws LicensingException {
        Keys.Smart keys = new Keys.Smart(this.keys());
        if (!keys.exists(this.product)) {
            throw new LicensingException(String.format(IssuingMessages.ProductKeys_keys_no_storage_for_product, this.product));
        }
        ResourceHandle source = keys.located(this.product);
        try {
            KeyPair pair = (KeyPair)new EObjectFromBytes(source.content(), KeyPair.class, XMIResourceImpl::new).get();
            return get.apply(pair).getBytes();
        }
        catch (Exception e) {
            throw new LicensingException(String.format(IssuingMessages.ProductKeys_keys_reading_failed, this.product, source.info()));
        }
    }

    private Keys keys() throws LicensingException {
        Optional keys = new OperatorGearAware().withGear(gear -> Optional.of(gear.workspace().keys()));
        if (!keys.isPresent()) {
            throw new LicensingException(IssuingMessages.ProductKeys_keys_no_service);
        }
        return (Keys)keys.get();
    }
}

