/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.internal.products.core;

import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.osgi.util.NLS;
import org.eclipse.passage.lic.equinox.io.InstallationPath;
import org.eclipse.passage.lic.internal.equinox.events.EquinoxEvent;
import org.eclipse.passage.lic.products.ProductDescriptor;
import org.eclipse.passage.lic.products.ProductLineDescriptor;
import org.eclipse.passage.lic.products.ProductVersionDescriptor;
import org.eclipse.passage.lic.products.ProductVersionFeatureDescriptor;
import org.eclipse.passage.lic.products.model.meta.ProductsPackage;
import org.eclipse.passage.lic.products.model.util.ProductsResourceImpl;
import org.eclipse.passage.loc.internal.emf.BaseDomainRegistry;
import org.eclipse.passage.loc.internal.emf.DomainContentAdapter;
import org.eclipse.passage.loc.internal.emf.EditingDomainRegistry;
import org.eclipse.passage.loc.internal.products.ProductRegistry;
import org.eclipse.passage.loc.internal.products.core.ProductsDomainRegistryTracker;
import org.eclipse.passage.loc.internal.products.core.i18n.ProductsCoreMessages;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.event.EventAdmin;

@Component(property={"org.eclipse.passage.lic.emf.edit.domain.name=products", "org.eclipse.passage.lic.emf.edit.file.extension=products_xmi"})
public class ProductDomainRegistry
extends BaseDomainRegistry<ProductLineDescriptor>
implements ProductRegistry,
EditingDomainRegistry<ProductLineDescriptor> {
    private final Map<String, ProductLineDescriptor> productLineIndex = new HashMap<String, ProductLineDescriptor>();
    private final Map<String, ProductDescriptor> productIndex = new HashMap<String, ProductDescriptor>();
    private final Map<String, Map<String, ProductVersionDescriptor>> productVersionIndex = new HashMap<String, Map<String, ProductVersionDescriptor>>();
    private final Map<String, Map<String, Map<String, ProductVersionFeatureDescriptor>>> productVersionFeatureIndex = new HashMap<String, Map<String, Map<String, ProductVersionFeatureDescriptor>>>();
    private EventAdmin events;

    @Reference
    public void bindEventAdmin(EventAdmin admin) {
        this.events = admin;
    }

    public void unbindEventAdmin(EventAdmin admin) {
        this.events = null;
    }

    @Activate
    public void activate(Map<String, Object> properties) {
        super.activate(properties);
    }

    @Deactivate
    public void deactivate(Map<String, Object> properties) {
        Collection<Map<String, ProductVersionDescriptor>> values = this.productVersionIndex.values();
        for (Map<String, ProductVersionDescriptor> map : values) {
            map.clear();
        }
        this.productVersionIndex.clear();
        this.productIndex.clear();
        this.productLineIndex.clear();
        super.deactivate(properties);
    }

    public String getFileExtension() {
        return "products_xmi";
    }

    public Class<ProductLineDescriptor> getContentClass() {
        return ProductLineDescriptor.class;
    }

    public String resolveIdentifier(ProductLineDescriptor content) {
        return content.getIdentifier();
    }

    @Override
    public Iterable<? extends ProductLineDescriptor> getProductLines() {
        return new ArrayList<ProductLineDescriptor>(this.productLineIndex.values());
    }

    @Override
    public ProductLineDescriptor getProductLine(String identifier) {
        return this.productLineIndex.get(identifier);
    }

    public Iterable<ProductDescriptor> getProducts() {
        return new ArrayList<ProductDescriptor>(this.productIndex.values());
    }

    @Override
    public Iterable<? extends ProductDescriptor> getProducts(String productLineId) {
        ProductLineDescriptor productLine = this.productLineIndex.get(productLineId);
        if (productLine == null) {
            return Collections.emptyList();
        }
        return productLine.getProducts();
    }

    @Override
    public ProductDescriptor getProduct(String productId) {
        return this.productIndex.get(productId);
    }

    public Iterable<ProductVersionDescriptor> getProductVersions() {
        ArrayList<ProductVersionDescriptor> list = new ArrayList<ProductVersionDescriptor>();
        Collection<Map<String, ProductVersionDescriptor>> values = this.productVersionIndex.values();
        for (Map<String, ProductVersionDescriptor> map : values) {
            list.addAll(map.values());
        }
        return list;
    }

    public Iterable<ProductVersionDescriptor> getProductVersions(String productId) {
        Map<String, ProductVersionDescriptor> map = this.productVersionIndex.get(productId);
        if (map == null) {
            return Collections.emptyList();
        }
        return new ArrayList<ProductVersionDescriptor>(map.values());
    }

    @Override
    public ProductVersionDescriptor getProductVersion(String product, String version) {
        Map<String, ProductVersionDescriptor> map = this.productVersionIndex.get(product);
        if (map == null) {
            return null;
        }
        return map.get(version);
    }

    public Iterable<ProductVersionFeatureDescriptor> getProductVersionFeatures() {
        ArrayList<ProductVersionFeatureDescriptor> productVersionFeatures = new ArrayList<ProductVersionFeatureDescriptor>();
        Collection<Map<String, Map<String, ProductVersionFeatureDescriptor>>> versionValues = this.productVersionFeatureIndex.values();
        for (Map<String, Map<String, ProductVersionFeatureDescriptor>> versions : versionValues) {
            Collection<Map<String, ProductVersionFeatureDescriptor>> values = versions.values();
            for (Map<String, ProductVersionFeatureDescriptor> map : values) {
                productVersionFeatures.addAll(map.values());
            }
        }
        return productVersionFeatures;
    }

    public Iterable<ProductVersionFeatureDescriptor> getProductVersionFeatures(String productId, String version) {
        Map<String, Map<String, ProductVersionFeatureDescriptor>> versions = this.productVersionFeatureIndex.get(productId);
        if (versions == null) {
            return Collections.emptyList();
        }
        Map<String, ProductVersionFeatureDescriptor> map = versions.get(version);
        if (map == null) {
            return Collections.emptyList();
        }
        ArrayList<ProductVersionFeatureDescriptor> result = new ArrayList<ProductVersionFeatureDescriptor>();
        map.values().forEach(result::add);
        return result;
    }

    protected DomainContentAdapter<ProductLineDescriptor, ProductDomainRegistry> createContentAdapter() {
        return new ProductsDomainRegistryTracker(this);
    }

    @Override
    public void registerProductLine(ProductLineDescriptor productLine) {
        String identifier = productLine.getIdentifier();
        ProductLineDescriptor existing = this.productLineIndex.put(identifier, productLine);
        if (existing != null) {
            String msg = NLS.bind((String)ProductsCoreMessages.ProductDomain_instance_duplication_message, (Object)existing, (Object)productLine);
            Platform.getLog(this.getClass()).warn(msg);
        }
        this.events.postEvent(new EquinoxEvent("org/eclipse/passage/lic/products/registry/ProductLine/create", (Object)productLine).get());
        productLine.getProducts().forEach(p -> this.registerProduct((ProductDescriptor)p));
    }

    @Override
    public void registerProduct(ProductDescriptor product) {
        String identifier = product.getIdentifier();
        ProductDescriptor existing = this.productIndex.put(identifier, product);
        if (existing != null) {
            String msg = NLS.bind((String)ProductsCoreMessages.ProductDomain_instance_duplication_message, (Object)existing, (Object)product);
            Platform.getLog(this.getClass()).warn(msg);
        }
        this.events.postEvent(new EquinoxEvent("org/eclipse/passage/lic/products/registry/Product/create", (Object)product).get());
        product.getProductVersions().forEach(pv -> this.registerProductVersion(product, (ProductVersionDescriptor)pv));
    }

    @Override
    public void registerProductVersion(ProductDescriptor product, ProductVersionDescriptor productVersion) {
        String version;
        String identifier = product.getIdentifier();
        Map versions = this.productVersionIndex.computeIfAbsent(identifier, key -> new HashMap());
        ProductVersionDescriptor existing = versions.put(version = productVersion.getVersion(), productVersion);
        if (existing != null) {
            String msg = NLS.bind((String)ProductsCoreMessages.ProductDomain_instance_duplication_message, (Object)existing, (Object)productVersion);
            Platform.getLog(this.getClass()).warn(msg);
        }
        this.events.postEvent(new EquinoxEvent("org/eclipse/passage/lic/products/registry/ProductVersion/create", (Object)productVersion).get());
    }

    @Override
    public void registerProductVersionFeature(ProductDescriptor product, ProductVersionDescriptor productVersion, ProductVersionFeatureDescriptor productVersionFeature) {
        String featureIdentifier;
        String version;
        String identifier = product.getIdentifier();
        Map versions = this.productVersionFeatureIndex.computeIfAbsent(identifier, key -> new HashMap());
        Map features = versions.computeIfAbsent(version = productVersion.getVersion(), key -> new HashMap());
        ProductVersionFeatureDescriptor existing = features.put(featureIdentifier = productVersionFeature.getFeatureIdentifier(), productVersionFeature);
        if (existing != null) {
            String msg = NLS.bind((String)ProductsCoreMessages.ProductDomain_instance_duplication_message, (Object)existing, (Object)productVersionFeature);
            Platform.getLog(this.getClass()).warn(msg);
        }
        this.events.postEvent(new EquinoxEvent("org/eclipse/passage/lic/products/registry/ProductVersionFeature/create", (Object)productVersionFeature).get());
    }

    @Override
    public void unregisterProductLine(String productLineId) {
        ProductLineDescriptor removed = this.productLineIndex.remove(productLineId);
        if (removed != null) {
            this.events.postEvent(new EquinoxEvent("org/eclipse/passage/lic/products/registry/ProductLine/delete", (Object)removed).get());
            removed.getProducts().forEach(p -> this.unregisterProduct(p.getIdentifier()));
        }
    }

    @Override
    public void unregisterProduct(String productId) {
        ProductDescriptor removed = this.productIndex.remove(productId);
        if (removed != null) {
            this.events.postEvent(new EquinoxEvent("org/eclipse/passage/lic/products/registry/Product/delete", (Object)removed).get());
            removed.getProductVersions().forEach(pv -> this.unregisterProductVersion(productId, pv.getVersion()));
        }
    }

    @Override
    public void unregisterProductVersion(String productId, String version) {
        Map<String, ProductVersionDescriptor> versions = this.productVersionIndex.get(productId);
        if (versions != null) {
            ProductVersionDescriptor removed = versions.remove(version);
            if (removed != null) {
                this.events.postEvent(new EquinoxEvent("org/eclipse/passage/lic/products/registry/ProductVersion/delete", (Object)removed).get());
                removed.getProductVersionFeatures().forEach(pvf -> this.unregisterProductVersionFeature(productId, version, pvf.getFeatureIdentifier()));
            }
            if (versions.isEmpty()) {
                this.productVersionIndex.remove(productId);
            }
        }
    }

    @Override
    public void unregisterProductVersionFeature(String productId, String version, String featureId) {
        Map<String, Map<String, ProductVersionFeatureDescriptor>> versions = this.productVersionFeatureIndex.get(productId);
        if (versions != null) {
            Map<String, ProductVersionFeatureDescriptor> features = versions.get(version);
            if (features != null) {
                ProductVersionFeatureDescriptor removed = features.remove(featureId);
                if (removed != null) {
                    this.events.postEvent(new EquinoxEvent("org/eclipse/passage/lic/products/registry/ProductVersionFeature/delete", (Object)removed).get());
                }
                if (features.isEmpty()) {
                    versions.remove(version);
                }
            }
            if (versions.isEmpty()) {
                this.productVersionFeatureIndex.remove(productId);
            }
        }
    }

    public EClass getContentClassifier() {
        return ProductsPackage.eINSTANCE.getProductLine();
    }

    public EStructuralFeature getContentIdentifierAttribute() {
        return ProductsPackage.eINSTANCE.getProductLine_Identifier();
    }

    public EStructuralFeature getContentNameAttribute() {
        return ProductsPackage.eINSTANCE.getProductLine_Name();
    }

    public void registerContent(ProductLineDescriptor content) {
        this.registerProductLine(content);
    }

    public void unregisterContent(String identifier) {
        this.unregisterProductLine(identifier);
    }

    protected Path getResourceSetPath() throws Exception {
        Path passagePath = new InstallationPath().get();
        Files.createDirectories(passagePath, new FileAttribute[0]);
        return passagePath.resolve(this.domainName);
    }

    protected final Resource createResource(URI uri) {
        return new ProductsResourceImpl(uri);
    }
}

