/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.report.internal.core;

import java.io.IOException;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.eclipse.passage.loc.report.internal.core.ExistingFileStream;
import org.eclipse.passage.loc.report.internal.core.Messages;
import org.eclipse.passage.loc.report.internal.core.ProductCustomer;
import org.eclipse.passage.loc.yars.internal.api.ListMedia;
import org.eclipse.passage.loc.yars.internal.api.ReportException;
import org.eclipse.passage.loc.yars.internal.api.Unsafe;

final class Csv
implements ListMedia<ProductCustomer> {
    private final CSVPrinter stream;

    public Csv(ExistingFileStream target, String ... header) throws ReportException {
        try {
            this.stream = new CSVPrinter(target.stream(), CSVFormat.EXCEL.withDelimiter(';').withHeader(header));
        }
        catch (IOException e) {
            throw new ReportException(Messages.getString("Csv.action_printer_construction_failure"), (Throwable)e);
        }
    }

    public final void start() throws ReportException {
    }

    public final void finish() throws ReportException {
        this.unsafeCall((Unsafe<IOException>)((Unsafe)() -> ((CSVPrinter)this.stream).close()), Messages.getString("Csv.action_printer_closure_failure"));
    }

    public final void startNode(ProductCustomer node) {
    }

    public final void finishNode(ProductCustomer node) throws ReportException {
        this.unsafeCall((Unsafe<IOException>)((Unsafe)() -> ((CSVPrinter)this.stream).println()), Messages.getString("Csv.action_closing_row"));
    }

    public final void inner(String data, String name) throws ReportException {
        this.unsafeCall((Unsafe<IOException>)((Unsafe)() -> this.stream.print((Object)data)), String.format(Messages.getString("Csv.action_filling_cell"), data, name));
    }

    private void unsafeCall(Unsafe<IOException> unsafe, String happening) throws ReportException {
        try {
            unsafe.call();
        }
        catch (IOException e) {
            throw new ReportException(String.format(Messages.getString("Csv.action_failed"), happening), (Throwable)e);
        }
    }
}

