/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.dashboard.ui.wizards;

import java.io.File;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.passage.lic.api.LicensingResult;
import org.eclipse.passage.lic.api.access.LicensingRequest;
import org.eclipse.passage.lic.licenses.LicensePackDescriptor;
import org.eclipse.passage.lic.licenses.LicensePlanDescriptor;
import org.eclipse.passage.lic.products.ProductVersionDescriptor;
import org.eclipse.passage.lic.users.UserDescriptor;
import org.eclipse.passage.lic.users.model.api.UserLicense;
import org.eclipse.passage.lic.users.model.meta.UsersPackage;
import org.eclipse.passage.loc.api.OperatorLicenseService;
import org.eclipse.passage.loc.dashboard.ui.wizards.IssueLicenseDetailsPage;
import org.eclipse.passage.loc.dashboard.ui.wizards.IssueLicenseMailJob;
import org.eclipse.passage.loc.dashboard.ui.wizards.IssueLicensePackPage;
import org.eclipse.passage.loc.dashboard.ui.wizards.IssueLicenseRequestPage;
import org.eclipse.passage.loc.internal.dashboard.ui.i18n.IssueLicensePageMessages;
import org.eclipse.passage.loc.workbench.LocWokbench;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class IssueLicenseWizard
extends Wizard {
    private final IEclipseContext context;
    private LicensePlanDescriptor licensePlanDescriptor;
    private UserDescriptor userDescriptor;
    private ProductVersionDescriptor productVersionDescriptor;
    private IssueLicenseRequestPage requestPage;
    private IssueLicensePackPage packPage;
    private IssueLicenseDetailsPage infoPage;

    public IssueLicenseWizard(IEclipseContext context) {
        this.context = context;
        this.setWindowTitle(IssueLicensePageMessages.IssueLicenseWizard_window_title);
    }

    public void init(LicensePlanDescriptor plan, UserDescriptor user, ProductVersionDescriptor version) {
        this.licensePlanDescriptor = plan;
        this.userDescriptor = user;
        this.productVersionDescriptor = version;
    }

    public void addPages() {
        this.requestPage = new IssueLicenseRequestPage(IssueLicenseRequestPage.class.getName(), this.context);
        this.requestPage.init(this.licensePlanDescriptor, this.userDescriptor, this.productVersionDescriptor);
        this.addPage((IWizardPage)this.requestPage);
        this.packPage = new IssueLicensePackPage(IssueLicensePackPage.class.getName(), this.context);
        this.addPage((IWizardPage)this.packPage);
        this.infoPage = new IssueLicenseDetailsPage(IssueLicenseDetailsPage.class.getName());
        this.addPage((IWizardPage)this.infoPage);
    }

    public IWizardPage getNextPage(IWizardPage page) {
        IWizardPage nextPage = super.getNextPage(page);
        if (((Object)((Object)this.packPage)).equals(nextPage)) {
            this.packPage.init(this.requestPage.getLicensingRequest());
        }
        if (((Object)((Object)this.infoPage)).equals(nextPage)) {
            this.infoPage.init(this.packPage.getLicensePack());
        }
        return nextPage;
    }

    public boolean performFinish() {
        LicensePackDescriptor licensePack;
        LicensingRequest request;
        OperatorLicenseService licenseService = (OperatorLicenseService)this.context.get(OperatorLicenseService.class);
        LicensingResult result = licenseService.issueLicensePack(request = this.requestPage.getLicensingRequest(), licensePack = this.packPage.getLicensePack());
        int severity = result.getSeverity();
        if (severity >= 4) {
            this.setErrorMessage(result.getMessage());
            return false;
        }
        this.setErrorMessage(null);
        int kind = severity == 2 ? 4 : 2;
        MessageDialog.open((int)kind, (Shell)this.getShell(), (String)IssueLicensePageMessages.IssueLicenseWizard_ok_licensed_title, (String)result.getMessage(), (int)0);
        this.broadcastResult(result);
        this.processingMail(result);
        return true;
    }

    private void processingMail(LicensingResult result) {
        final IssueLicenseMailJob processingMail = new IssueLicenseMailJob(IssueLicensePageMessages.IssueLicensingMailJob_task_text, result, this.infoPage.getMailSupport(), this.infoPage.isCreateMail(), this.infoPage.isCreateEml());
        processingMail.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (processingMail.getEmlFile().isPresent()) {
                    File emlFile = processingMail.getEmlFile().get();
                    String msg = NLS.bind((String)IssueLicensePageMessages.IssueLicenseMailRequestDialog_text, (Object)emlFile.getAbsolutePath());
                    Display.getDefault().asyncExec(() -> MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)IssueLicensePageMessages.IssueLicenseMailRequestDialog_title, (String)msg));
                }
            }
        });
        processingMail.schedule(1000L);
    }

    private void broadcastResult(LicensingResult result) {
        Object attached = result.getAttachment(UsersPackage.eINSTANCE.getUserLicense().getName());
        if (attached instanceof UserLicense) {
            UserLicense userLicense = (UserLicense)attached;
            String perspectiveId = "org.eclipse.passage.loc.users.ui.perspective.main";
            LocWokbench.switchPerspective((IEclipseContext)this.context, (String)perspectiveId);
            IEventBroker broker = (IEventBroker)this.context.get(IEventBroker.class);
            broker.post("org/eclipse/passage/loc/workbench/show", (Object)userLicense);
        }
    }

    private void setErrorMessage(String message) {
        IWizardContainer container = this.getContainer();
        if (container instanceof TitleAreaDialog) {
            TitleAreaDialog dialog = (TitleAreaDialog)container;
            dialog.setErrorMessage(message);
        }
    }
}

