/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.report.internal.ui.jface;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.passage.lic.users.UserDescriptor;
import org.eclipse.passage.loc.report.internal.core.CustomerStorage;
import org.eclipse.passage.loc.report.internal.ui.i18n.ExportCustomersWizardMessages;
import org.eclipse.passage.loc.report.internal.ui.jface.DataForExport;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;

final class PreviewPage
extends WizardPage {
    private final CustomerStorage customers;
    private List users;
    private Text path;
    private final DataForExport data;

    protected PreviewPage(CustomerStorage customers, DataForExport data) {
        super("preview");
        this.customers = customers;
        this.data = data;
        this.setTitle(ExportCustomersWizardMessages.PreviewPage_title);
        this.setMessage(ExportCustomersWizardMessages.PreviewPage_description);
    }

    public void createControl(Composite parent) {
        Composite content = new Composite(parent, 0);
        content.setLayout((Layout)new GridLayout(1, false));
        this.users = new List(content, 2056);
        this.users.setLayoutData((Object)new GridData(4, 4, true, true));
        this.path = new Text(content, 2056);
        this.path.setLayoutData((Object)new GridData(4, 1024, true, false));
        this.setControl((Control)content);
    }

    void updateTargetPath() {
        this.path.setText(this.data.target().toString());
    }

    void updateUsers() {
        this.users.removeAll();
        this.customers.forProducts(this.data.products()).stream().map(this::userInfo).sorted().forEach(arg_0 -> ((List)this.users).add(arg_0));
    }

    private String userInfo(UserDescriptor user) {
        return NLS.bind((String)"{0} ({1})", (Object)user.getFullName(), (Object)user.getEmail());
    }
}

