/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.internal.products.core;

import java.util.Collections;
import org.eclipse.passage.lic.emf.edit.SelectionCommandAdvisor;
import org.eclipse.passage.lic.products.model.meta.ProductsPackage;
import org.eclipse.passage.lic.products.registry.ProductRegistry;
import org.eclipse.passage.loc.internal.products.core.i18n.ProductsCoreMessages;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"org.eclipse.passage.lic.emf.edit.domain.name=products"})
public class ProductsSelectionCommandAdvisor
implements SelectionCommandAdvisor {
    private ProductRegistry productRegistry;

    @Reference
    public void bindDomainRegistry(ProductRegistry registry) {
        this.productRegistry = registry;
    }

    public void unbindDomainRegistry(ProductRegistry registry) {
        if (this.productRegistry == registry) {
            this.productRegistry = null;
        }
    }

    public String getSelectionTitle(String classifier) {
        if (ProductsPackage.eINSTANCE.getProductLine().getName().equals(classifier)) {
            return ProductsCoreMessages.ProductsSelectionCommandAdvisor_select_product_line;
        }
        if (ProductsPackage.eINSTANCE.getProduct().getName().equals(classifier)) {
            return ProductsCoreMessages.ProductsSelectionCommandAdvisor_select_product;
        }
        if (ProductsPackage.eINSTANCE.getProductVersion().getName().equals(classifier)) {
            return ProductsCoreMessages.ProductsSelectionCommandAdvisor_select_product_version;
        }
        if (ProductsPackage.eINSTANCE.getProductVersionFeature().getName().equals(classifier)) {
            return ProductsCoreMessages.ProductsSelectionCommandAdvisor_select_product_version_feature;
        }
        return null;
    }

    public Iterable<?> getSelectionInput(String classifier) {
        if (this.productRegistry == null) {
            return Collections.emptyList();
        }
        if (ProductsPackage.eINSTANCE.getProductLine().getName().equals(classifier)) {
            return this.productRegistry.getProductLines();
        }
        if (ProductsPackage.eINSTANCE.getProduct().getName().equals(classifier)) {
            return this.productRegistry.getProducts();
        }
        if (ProductsPackage.eINSTANCE.getProductVersion().getName().equals(classifier)) {
            return this.productRegistry.getProductVersions();
        }
        if (ProductsPackage.eINSTANCE.getProductVersionFeature().getName().equals(classifier)) {
            return this.productRegistry.getProductVersionFeatures();
        }
        return Collections.emptyList();
    }
}

