/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.internal.products.core;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.osgi.service.environment.EnvironmentInfo;
import org.eclipse.passage.lic.api.io.StreamCodec;
import org.eclipse.passage.lic.emf.ecore.LicensingEcore;
import org.eclipse.passage.lic.products.ProductDescriptor;
import org.eclipse.passage.lic.products.ProductVersionDescriptor;
import org.eclipse.passage.lic.products.model.api.Product;
import org.eclipse.passage.lic.products.model.api.ProductVersion;
import org.eclipse.passage.loc.api.OperatorProductEvents;
import org.eclipse.passage.loc.api.OperatorProductService;
import org.eclipse.passage.loc.internal.products.core.i18n.ProductsCoreMessages;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.event.EventAdmin;

@Component
public class ProductOperatorServiceImpl
implements OperatorProductService {
    private String pluginId;
    private EnvironmentInfo environmentInfo;
    private EventAdmin eventAdmin;
    private StreamCodec streamCodec;

    @Activate
    public void activate(BundleContext context) {
        this.pluginId = context.getBundle().getSymbolicName();
    }

    @Reference
    public void bindEnvironmentInfo(EnvironmentInfo info) {
        this.environmentInfo = info;
    }

    public void unbindEnvironmentInfo(EnvironmentInfo info) {
        if (this.environmentInfo == info) {
            this.environmentInfo = null;
        }
    }

    @Reference
    public void bindEventAdmin(EventAdmin admin) {
        this.eventAdmin = admin;
    }

    public void unbindEventAdmin(EventAdmin admin) {
        if (this.eventAdmin == admin) {
            this.eventAdmin = null;
        }
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL)
    public void bindStreamCodec(StreamCodec codec) {
        this.streamCodec = codec;
    }

    public void unbindStreamCodec(StreamCodec codec) {
        if (this.streamCodec == codec) {
            this.streamCodec = null;
        }
    }

    public String createPassword(ProductVersionDescriptor descriptor) {
        String id = null;
        String version = null;
        if (descriptor != null) {
            ProductDescriptor product = descriptor.getProduct();
            if (product != null) {
                id = product.getIdentifier();
            }
            version = descriptor.getVersion();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(id).append("###").append(version);
        return sb.toString();
    }

    public IStatus createProductKeys(ProductVersionDescriptor descriptor) {
        File privateFile;
        File publicFile;
        ProductVersion productVersion = null;
        if (descriptor instanceof ProductVersion) {
            productVersion = (ProductVersion)descriptor;
        }
        if (productVersion == null) {
            return new Status(4, this.pluginId, ProductsCoreMessages.ProductOperatorServiceImpl_e_invalid_product_version);
        }
        String installationToken = productVersion.getInstallationToken();
        if (installationToken != null && (publicFile = new File(installationToken)).exists()) {
            String pattern = ProductsCoreMessages.ProductOperatorServiceImpl_e_public_key_already_defined;
            String message = String.format(pattern, publicFile.getAbsolutePath());
            return new Status(4, this.pluginId, message);
        }
        String secureToken = productVersion.getSecureToken();
        if (secureToken != null && (privateFile = new File(secureToken)).exists()) {
            String pattern = ProductsCoreMessages.ProductOperatorServiceImpl_e_private_key_already_defined;
            String message = String.format(pattern, privateFile.getAbsolutePath());
            return new Status(4, this.pluginId, message);
        }
        Product product = productVersion.getProduct();
        String errors = LicensingEcore.extractValidationError((EObject)product);
        if (errors != null) {
            return new Status(4, this.pluginId, errors);
        }
        String identifier = product.getIdentifier();
        String version = productVersion.getVersion();
        if (this.streamCodec == null) {
            String pattern = ProductsCoreMessages.ProductOperatorServiceImpl_e_unable_to_create_keys;
            String message = String.format(pattern, version, product.getName());
            return new Status(4, this.pluginId, message);
        }
        Path basePath = this.getBasePath();
        try {
            Path path = basePath.resolve(identifier).resolve(version);
            Files.createDirectories(path, new FileAttribute[0]);
            String storageKeyFolder = path.toFile().getAbsolutePath();
            String keyFileName = String.valueOf(identifier) + '_' + version;
            String publicKeyPath = String.valueOf(storageKeyFolder) + File.separator + keyFileName + ".pub";
            String privateKeyPath = String.valueOf(storageKeyFolder) + File.separator + keyFileName + ".scr";
            this.streamCodec.createKeyPair(publicKeyPath, privateKeyPath, identifier, this.createPassword((ProductVersionDescriptor)productVersion));
            productVersion.setInstallationToken(publicKeyPath);
            productVersion.setSecureToken(privateKeyPath);
            this.eventAdmin.postEvent(OperatorProductEvents.publicCreated((String)publicKeyPath));
            this.eventAdmin.postEvent(OperatorProductEvents.privateCreated((String)privateKeyPath));
            String format = ProductsCoreMessages.ProductOperatorServiceImpl_ok_keys_exported;
            String message = String.format(format, publicKeyPath, privateKeyPath);
            return new Status(0, this.pluginId, message);
        }
        catch (Exception e) {
            return new Status(4, this.pluginId, ProductsCoreMessages.ProductOperatorServiceImpl_e_export_error, (Throwable)e);
        }
    }

    public Path getBasePath() {
        String areaValue = this.environmentInfo.getProperty("user.home");
        Path passagePath = Paths.get(areaValue, ".passage");
        try {
            Files.createDirectories(passagePath, new FileAttribute[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return passagePath;
    }
}

