/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.filetransfer.browse;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.net.URLConnection;
import org.eclipse.ecf.core.security.Callback;
import org.eclipse.ecf.core.security.CallbackHandler;
import org.eclipse.ecf.core.security.IConnectContext;
import org.eclipse.ecf.core.security.NameCallback;
import org.eclipse.ecf.core.security.ObjectCallback;
import org.eclipse.ecf.core.security.UnsupportedCallbackException;
import org.eclipse.ecf.core.util.Proxy;
import org.eclipse.ecf.filetransfer.BrowseFileTransferException;
import org.eclipse.ecf.filetransfer.IRemoteFile;
import org.eclipse.ecf.filetransfer.IRemoteFileSystemListener;
import org.eclipse.ecf.filetransfer.IncomingFileTransferException;
import org.eclipse.ecf.filetransfer.identity.IFileID;
import org.eclipse.ecf.internal.provider.filetransfer.Activator;
import org.eclipse.ecf.internal.provider.filetransfer.IURLConnectionModifier;
import org.eclipse.ecf.internal.provider.filetransfer.Messages;
import org.eclipse.ecf.provider.filetransfer.browse.AbstractFileSystemBrowser;
import org.eclipse.ecf.provider.filetransfer.browse.URLRemoteFile;
import org.eclipse.ecf.provider.filetransfer.util.JREProxyHelper;
import org.eclipse.osgi.util.NLS;

public class URLFileSystemBrowser
extends AbstractFileSystemBrowser {
    private static final String USERNAME_PREFIX = Messages.UrlConnectionRetrieveFileTransfer_USERNAME_PROMPT;
    private static final String JRE_CONNECT_TIMEOUT_PROPERTY = "sun.net.client.defaultConnectTimeout";
    private static final String DEFAULT_CONNECT_TIMEOUT = System.getProperty("org.eclipse.ecf.provider.filetransfer.browse.connectTimeout", "30000");
    private static final String JRE_READ_TIMEOUT_PROPERTY = "sun.net.client.defaultReadTimeout";
    private static final String DEFAULT_READ_TIMEOUT = System.getProperty("org.eclipse.ecf.provider.filetransfer.browse.readTimeout", "30000");
    private JREProxyHelper proxyHelper = new JREProxyHelper();
    protected String username = null;
    protected String password = null;

    public URLFileSystemBrowser(IFileID directoryOrFileID, IRemoteFileSystemListener listener, URL directoryOrFileURL, IConnectContext connectContext, Proxy proxy) {
        super(directoryOrFileID, listener, directoryOrFileURL, connectContext, proxy);
    }

    private void setupTimeouts() {
        String existingTimeout = System.getProperty(JRE_CONNECT_TIMEOUT_PROPERTY);
        if (existingTimeout == null) {
            System.setProperty(JRE_CONNECT_TIMEOUT_PROPERTY, DEFAULT_CONNECT_TIMEOUT);
        }
        if ((existingTimeout = System.getProperty(JRE_READ_TIMEOUT_PROPERTY)) == null) {
            System.setProperty(JRE_READ_TIMEOUT_PROPERTY, DEFAULT_READ_TIMEOUT);
        }
    }

    @Override
    protected void runRequest() throws Exception {
        int code = -1;
        try {
            this.setupProxies();
            this.setupAuthentication();
            this.setupTimeouts();
            URLConnection urlConnection = this.directoryOrFile.openConnection();
            if (this.directoryOrFile.getProtocol().equalsIgnoreCase("jar")) {
                urlConnection.setUseCaches(false);
            }
            urlConnection.setRequestProperty("Connection", "close");
            IURLConnectionModifier connectionModifier = Activator.getDefault().getURLConnectionModifier();
            if (connectionModifier != null) {
                connectionModifier.setSocketFactoryForConnection(urlConnection);
            }
            if (urlConnection instanceof HttpURLConnection) {
                HttpURLConnection httpConnection = (HttpURLConnection)urlConnection;
                httpConnection.setRequestMethod("HEAD");
                httpConnection.connect();
            } else {
                InputStream ins = urlConnection.getInputStream();
                ins.close();
            }
            code = this.getResponseCode(urlConnection);
            if (this.isHTTP() && code != 200) {
                if (code == 404) {
                    throw new BrowseFileTransferException(NLS.bind((String)"File not found: {0}", (Object)this.directoryOrFile.toString()), code);
                }
                if (code == 401) {
                    throw new BrowseFileTransferException("Unauthorized", code);
                }
                if (code == 403) {
                    throw new BrowseFileTransferException("Forbidden", code);
                }
                if (code == 407) {
                    throw new BrowseFileTransferException("Proxy auth required", code);
                }
                throw new BrowseFileTransferException(NLS.bind((String)"General connection error with response code={0} and header(0)={1}", (Object)code, (Object)urlConnection.getHeaderField(0)), code);
            }
            this.remoteFiles = new IRemoteFile[1];
            this.remoteFiles[0] = new URLRemoteFile(urlConnection.getLastModified(), urlConnection.getContentLength(), this.fileID);
        }
        catch (FileNotFoundException e) {
            throw new IncomingFileTransferException(NLS.bind((String)"File not found: {0}", (Object)this.directoryOrFile.toString()), 404);
        }
        catch (Exception e) {
            Exception except = e instanceof BrowseFileTransferException ? e : new BrowseFileTransferException(NLS.bind((String)"Could not connect to {0}", (Object)this.directoryOrFile), (Throwable)e, code);
            throw except;
        }
    }

    private boolean isHTTP() {
        String protocol = this.directoryOrFile.getProtocol();
        return protocol.equalsIgnoreCase("http") || protocol.equalsIgnoreCase("https");
    }

    private int getResponseCode(URLConnection urlConnection) {
        int responseCode = -1;
        String response = urlConnection.getHeaderField(0);
        if (response == null) {
            responseCode = -1;
            return responseCode;
        }
        if (!response.startsWith("HTTP/")) {
            return -1;
        }
        int mark = (response = response.trim()).indexOf(" ") + 1;
        if (mark == 0) {
            return -1;
        }
        int last = mark + 3;
        if (last > response.length()) {
            last = response.length();
        }
        responseCode = Integer.parseInt(response.substring(mark, last));
        return responseCode;
    }

    protected void setupAuthentication() throws IOException, UnsupportedCallbackException {
        if (this.connectContext == null) {
            return;
        }
        CallbackHandler callbackHandler = this.connectContext.getCallbackHandler();
        if (callbackHandler == null) {
            return;
        }
        NameCallback usernameCallback = new NameCallback(USERNAME_PREFIX);
        ObjectCallback passwordCallback = new ObjectCallback();
        callbackHandler.handle(new Callback[]{usernameCallback, passwordCallback});
        this.username = usernameCallback.getName();
        Object o = passwordCallback.getObject();
        if (!(o instanceof String)) {
            throw new UnsupportedCallbackException((Callback)passwordCallback, Messages.UrlConnectionRetrieveFileTransfer_UnsupportedCallbackException);
        }
        this.password = (String)passwordCallback.getObject();
        Authenticator.setDefault(new UrlConnectionAuthenticator());
    }

    @Override
    protected void setupProxy(Proxy proxy2) {
        this.proxyHelper.setupProxy(proxy2);
    }

    class UrlConnectionAuthenticator
    extends Authenticator {
        UrlConnectionAuthenticator() {
        }

        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(URLFileSystemBrowser.this.username, URLFileSystemBrowser.this.password.toCharArray());
        }
    }
}

