/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.publisher.eclipse;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.equinox.frameworkadmin.BundleInfo;
import org.eclipse.equinox.internal.p2.core.helpers.CollectionUtils;
import org.eclipse.equinox.internal.p2.publisher.eclipse.DataLoader;
import org.eclipse.equinox.internal.p2.publisher.eclipse.IProductDescriptor;
import org.eclipse.equinox.internal.provisional.frameworkadmin.ConfigData;
import org.eclipse.equinox.p2.metadata.IVersionedId;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.publisher.AbstractAdvice;
import org.eclipse.equinox.p2.publisher.AbstractPublisherAction;
import org.eclipse.equinox.p2.publisher.actions.ILicenseAdvice;
import org.eclipse.equinox.p2.publisher.eclipse.IBrandingAdvice;
import org.eclipse.equinox.p2.publisher.eclipse.IConfigAdvice;
import org.eclipse.equinox.p2.publisher.eclipse.IExecutableAdvice;
import org.eclipse.equinox.p2.publisher.eclipse.IMacOsBundleUrlType;
import org.eclipse.equinox.p2.repository.IRepositoryReference;

public class ProductFileAdvice
extends AbstractAdvice
implements ILicenseAdvice,
IExecutableAdvice,
IConfigAdvice,
IBrandingAdvice {
    private static final String OSGI_SPLASH_PATH = "osgi.splashPath";
    private static final String SPLASH_PREFIX = "platform:/base/plugins/";
    private final IProductDescriptor product;
    private final String configSpec;
    private String ws;
    private String os;
    private String arch;
    private final ProductConfigData configData;

    protected String getId() {
        return this.product.getId();
    }

    protected Version getVersion() {
        return Version.parseVersion((String)this.product.getVersion());
    }

    public ProductFileAdvice(IProductDescriptor product, String configSpec) {
        this.product = product;
        this.configSpec = configSpec;
        String[] config = AbstractPublisherAction.parseConfigSpec((String)configSpec);
        this.ws = config[0];
        if (this.ws == null) {
            this.ws = "ANY";
        }
        this.os = config[1];
        if (this.os == null) {
            this.os = "ANY";
        }
        this.arch = config[2];
        if (this.arch == null) {
            this.arch = "ANY";
        }
        this.configData = this.getConfigData();
    }

    @Override
    public String[] getProgramArguments() {
        String line = this.product.getProgramArguments(this.os, this.arch);
        return AbstractPublisherAction.getArrayFromString((String)line, (String)" ");
    }

    @Override
    public String[] getVMArguments() {
        String line = this.product.getVMArguments(this.os, this.arch);
        return AbstractPublisherAction.getArrayFromString((String)line, (String)" ");
    }

    @Override
    public BundleInfo[] getBundles() {
        return (BundleInfo[])Stream.concat(this.getBundles(false), this.getBundles(true)).toArray(BundleInfo[]::new);
    }

    Stream<BundleInfo> getBundles(boolean configOnly) {
        if (configOnly) {
            return this.configData.configBundles.stream();
        }
        return Arrays.stream(this.configData.data.getBundles());
    }

    @Override
    public Map<String, String> getProperties() {
        HashMap<String, String> result = new HashMap<String, String>();
        CollectionUtils.putAll((Properties)this.configData.data.getProperties(), result);
        result.putAll(this.product.getConfigurationProperties(this.os, this.arch));
        return result;
    }

    @Override
    public String getExecutableName() {
        return this.product.getLauncherName();
    }

    public IProductDescriptor getProductFile() {
        return this.product;
    }

    @Override
    public String[] getIcons() {
        return this.product.getIcons(this.os);
    }

    @Override
    public String getOS() {
        return this.os;
    }

    public String getLicenseURL() {
        return this.product.getLicenseURL();
    }

    public String getLicenseText() {
        return this.product.getLicenseText();
    }

    @Override
    public List<IMacOsBundleUrlType> getMacOsBundleUrlTypes() {
        return this.product.getMacOsBundleUrlTypes();
    }

    public List<IRepositoryReference> getUpdateRepositories() {
        return this.product.getRepositoryEntries();
    }

    private ProductConfigData getConfigData() {
        String location;
        DataLoader loader = this.createDataLoader();
        ConfigData result = loader != null ? loader.getConfigData() : this.generateConfigData();
        ProductConfigData data = new ProductConfigData(result);
        this.addProductFileBundles(data);
        this.addProductFileConfigBundles(data);
        if (this.product.getProductId() != null) {
            result.setProperty("eclipse.product", this.product.getProductId());
        }
        if (this.product.getApplication() != null) {
            result.setProperty("eclipse.application", this.product.getApplication());
        }
        if ((location = this.getSplashLocation()) != null) {
            result.setProperty(OSGI_SPLASH_PATH, SPLASH_PREFIX + location);
        }
        return data;
    }

    private void addProductFileConfigBundles(ProductConfigData productConfigData) {
        Map<String, List<BundleInfo>> configBundleMap = Arrays.stream(productConfigData.data.getBundles()).collect(Collectors.groupingBy(BundleInfo::getSymbolicName));
        for (BundleInfo configBundleInfo : this.product.getBundleInfos()) {
            List<BundleInfo> matches = configBundleMap.get(configBundleInfo.getSymbolicName());
            if (matches == null || matches.isEmpty()) {
                productConfigData.configBundles.add(configBundleInfo);
                continue;
            }
            for (BundleInfo target : matches) {
                target.setStartLevel(configBundleInfo.getStartLevel());
                target.setMarkedAsStarted(configBundleInfo.isMarkedAsStarted());
            }
        }
    }

    private void addProductFileBundles(ProductConfigData productConfigData) {
        if (this.product.useFeatures()) {
            return;
        }
        List<IVersionedId> bundles = this.product.getBundles();
        HashSet<BundleInfo> set = new HashSet<BundleInfo>();
        set.addAll(Arrays.asList(productConfigData.data.getBundles()));
        for (IVersionedId vid : bundles) {
            BundleInfo bundleInfo = new BundleInfo();
            bundleInfo.setSymbolicName(vid.getId());
            bundleInfo.setVersion(vid.getVersion().toString());
            if (set.contains(bundleInfo)) continue;
            productConfigData.data.addBundle(bundleInfo);
        }
    }

    private ConfigData generateConfigData() {
        ConfigData result = new ConfigData(null, null, null, null);
        if (this.product.useFeatures()) {
            return result;
        }
        List<IVersionedId> bundles = this.product.getBundles();
        for (IVersionedId vid : bundles) {
            BundleInfo bundleInfo = new BundleInfo();
            bundleInfo.setSymbolicName(vid.getId());
            bundleInfo.setVersion(vid.getVersion().toString());
            result.addBundle(bundleInfo);
        }
        return result;
    }

    private String getSplashLocation() {
        return this.product.getSplashLocation();
    }

    protected String getConfigSpec() {
        return this.configSpec;
    }

    protected boolean matchConfig(String spec, boolean includeDefault) {
        if (spec != null) {
            String targetWS = AbstractPublisherAction.parseConfigSpec((String)spec)[0];
            if (targetWS == null) {
                targetWS = "ANY";
            }
            if (!(this.ws.equals(targetWS) || this.ws.equals("ANY") || targetWS.equals("ANY"))) {
                return false;
            }
            String targetOS = AbstractPublisherAction.parseConfigSpec((String)spec)[1];
            if (targetOS == null) {
                targetOS = "ANY";
            }
            if (!(this.os.equals(targetOS) || this.os.equals("ANY") || targetOS.equals("ANY"))) {
                return false;
            }
            String targetArch = AbstractPublisherAction.parseConfigSpec((String)spec)[2];
            if (targetArch == null) {
                targetArch = "ANY";
            }
            if (!(this.arch.equals(targetArch) || this.arch.equals("ANY") || targetArch.equals("ANY"))) {
                return false;
            }
        }
        return true;
    }

    private DataLoader createDataLoader() {
        File parent;
        String location = this.product.getConfigIniPath(this.os);
        if (location == null) {
            location = this.product.getConfigIniPath(null);
        }
        if (location == null) {
            return null;
        }
        File configFile = new File(location);
        if (!configFile.isAbsolute() || !configFile.exists()) {
            configFile = new File(this.product.getLocation().getParentFile(), location);
        }
        if ((parent = configFile.getParentFile()).getName().equals("configuration") && parent.getParentFile() != null) {
            parent = parent.getParentFile();
        }
        return new DataLoader(configFile, parent);
    }

    private static final class ProductConfigData {
        private final List<BundleInfo> configBundles = new ArrayList<BundleInfo>();
        private final ConfigData data;

        public ProductConfigData(ConfigData data) {
            this.data = data;
        }
    }
}

