/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.engine;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.equinox.internal.p2.engine.Phase;
import org.eclipse.equinox.internal.p2.engine.PhaseSet;
import org.eclipse.equinox.internal.p2.engine.SizingPhaseSet;
import org.eclipse.equinox.p2.engine.IPhaseSet;
import org.eclipse.equinox.p2.engine.ISizingPhaseSet;

public class PhaseSetFactory {
    public static final String PHASE_CHECK_TRUST = "checkTrust";
    public static final String PHASE_COLLECT = "collect";
    public static final String PHASE_CONFIGURE = "configure";
    public static final String PHASE_INSTALL = "install";
    public static final String PHASE_PROPERTY = "property";
    public static final String PHASE_UNCONFIGURE = "unconfigure";
    public static final String PHASE_UNINSTALL = "uninstall";
    public static final String NATIVE_ARTIFACTS = "nativeArtifacts";
    private static final List<String> ALL_PHASES_LIST = Arrays.asList("collect", "unconfigure", "uninstall", "property", "checkTrust", "install", "configure");

    public static final IPhaseSet createDefaultPhaseSetExcluding(String[] exclude) {
        if (exclude == null || exclude.length == 0) {
            return PhaseSetFactory.createDefaultPhaseSet();
        }
        List<String> excludeList = Arrays.asList(exclude);
        ArrayList<String> includeList = new ArrayList<String>(ALL_PHASES_LIST);
        includeList.removeAll(excludeList);
        return PhaseSetFactory.createPhaseSetIncluding(includeList.toArray(new String[includeList.size()]));
    }

    public static final IPhaseSet createPhaseSetIncluding(String[] include) {
        if (include == null || include.length == 0) {
            return new PhaseSet(new Phase[0]);
        }
        return new PhaseSet(include);
    }

    public static IPhaseSet createDefaultPhaseSet() {
        return PhaseSetFactory.createPhaseSetIncluding((String[])ALL_PHASES_LIST.toArray(String[]::new));
    }

    public static ISizingPhaseSet createSizingPhaseSet() {
        return new SizingPhaseSet();
    }
}

